/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.text.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.ClipBoardManager;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.wizard.integrity.gui.IntegrityMessagePanel;
import net.sf.jabref.wizard.text.TagToMarkedTextStore;
import net.sf.jabref.wizard.text.gui.BasicAction;
import net.sf.jabref.wizard.text.gui.OverlayPanel;
import net.sf.jabref.wizard.text.gui.PopupListener;

public class TextInputDialog
extends JDialog
implements ActionListener {
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton insertButton = new JButton();
    private JPanel panel1 = new JPanel();
    private JPanel buttons = new JPanel();
    private JPanel rawPanel = new JPanel();
    private JPanel sourcePanel = new JPanel();
    private IntegrityMessagePanel warnPanel;
    private JList fieldList;
    private JRadioButton overRadio;
    private JRadioButton appRadio;
    private OverlayPanel testPanel;
    private BibtexEntry entry;
    public JPopupMenu inputMenu = new JPopupMenu();
    private StyledDocument doc;
    private JTextPane textPane;
    private JTextArea preview;
    private boolean inputChanged;
    private TagToMarkedTextStore marked;
    private JabRefFrame _frame;
    private boolean okPressed = false;

    public TextInputDialog(JabRefFrame jabRefFrame, BasePanel basePanel, String string, boolean bl, BibtexEntry bibtexEntry) {
        super(jabRefFrame, string, bl);
        this.warnPanel = new IntegrityMessagePanel(basePanel);
        this.inputChanged = true;
        this._frame = jabRefFrame;
        this.entry = bibtexEntry;
        this.marked = new TagToMarkedTextStore();
        try {
            this.jbInit(jabRefFrame);
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateSourceView();
    }

    private void jbInit(JabRefFrame jabRefFrame) {
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        String string = Globals.lang("for");
        if (this.entry != null && this.entry.getType() != null) {
            string = string + " " + this.entry.getType().getName();
        }
        this.setTitle(Globals.lang("Plain_text_import") + " " + string);
        this.getContentPane().add((Component)this.panel1, "Center");
        this.initRawPanel();
        this.initButtonPanel();
        this.initSourcePanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (TextInputDialog.this.inputChanged) {
                    TextInputDialog.this.warnPanel.updateView(TextInputDialog.this.entry);
                }
            }
        });
        jTabbedPane.add((Component)this.rawPanel, Globals.lang("Raw_source"));
        jTabbedPane.add((Component)this.sourcePanel, Globals.lang("BibTeX_source"));
        jTabbedPane.add((Component)this.warnPanel, Globals.lang("Messages_and_Hints"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints.fill = 2;
        this.panel1.setLayout(new BorderLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.panel1.add((Component)jTabbedPane, "Center");
        this.panel1.add((Component)this.buttons, "South");
        ActionMap actionMap = this.buttons.getActionMap();
        InputMap inputMap = this.buttons.getInputMap(2);
        inputMap.put(jabRefFrame.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextInputDialog.this.dispose();
            }
        });
    }

    private void initRawPanel() {
        this.rawPanel.setLayout(new BorderLayout());
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.doc = this.textPane.getStyledDocument();
        this.addStylesToDocument(this.doc);
        try {
            this.doc.insertString(0, "", this.doc.getStyle("regular"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.testPanel = new OverlayPanel(this.textPane, Globals.lang("Text_Input_Area"));
        this.testPanel.setPreferredSize(new Dimension(450, 255));
        this.testPanel.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        PasteAction pasteAction = new PasteAction();
        JMenuItem jMenuItem = new JMenuItem(pasteAction);
        this.inputMenu.add(new MenuHeaderAction());
        this.inputMenu.addSeparator();
        this.inputMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener(this.inputMenu);
        this.textPane.addMouseListener(popupListener);
        this.testPanel.addMouseListener(popupListener);
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new ClearAction());
        jToolBar.setBorderPainted(false);
        jToolBar.addSeparator();
        jToolBar.add(pasteAction);
        jToolBar.add(new LoadAction());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jToolBar, "North");
        jPanel.add((Component)this.testPanel, "Center");
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        jPanel2.setLayout(gridBagLayout);
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), Globals.lang("Input"));
        jPanel2.setBorder(titledBorder);
        jPanel2.setMinimumSize(new Dimension(10, 10));
        this.fieldList = new JList<String>(this.getAllFields());
        this.fieldList.setCellRenderer(new SimpleCellRenderer(this.fieldList.getFont()));
        ListSelectionModel listSelectionModel = this.fieldList.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new FieldListSelectionHandler());
        this.fieldList.addMouseListener(new FieldListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.fieldList);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.insertButton.setText(Globals.lang("Insert"));
        this.insertButton.addActionListener(this);
        this.appRadio = new JRadioButton(Globals.lang("Append"));
        this.appRadio.setToolTipText(Globals.lang("append_the_selected_text_to_bibtex_key"));
        this.appRadio.setMnemonic(65);
        this.appRadio.setSelected(true);
        this.overRadio = new JRadioButton(Globals.lang("Override"));
        this.overRadio.setToolTipText(Globals.lang("override_the_bibtex_key_by_the_selected_text"));
        this.overRadio.setMnemonic(79);
        this.overRadio.setSelected(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.appRadio);
        buttonGroup.add(this.overRadio);
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
        jPanel3.add(this.appRadio);
        jPanel3.add(this.overRadio);
        JLabel jLabel = new JLabel(Globals.lang("Available fields"));
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.insertButton, gridBagConstraints);
        jPanel2.add(this.insertButton);
        this.rawPanel.add((Component)jPanel, "Center");
        this.rawPanel.add((Component)jPanel2, "East");
        JEditorPane jEditorPane = new JEditorPane();
        boolean bl = false;
        URL uRL = JabRef.class.getResource(GUIGlobals.getLocaleHelpPath() + GUIGlobals.shortPlainImport);
        if (uRL != null) {
            try {
                jEditorPane.setPage(uRL);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            jEditorPane.setText(Globals.lang("This_is_a_simple_copy_and_paste_dialog_for_import_some_fields_from_normal_text."));
        }
        jEditorPane.setEditable(false);
        jEditorPane.setBackground(GUIGlobals.infoField);
        jEditorPane.setBorder(new EtchedBorder(1));
        jEditorPane.setPreferredSize(new Dimension(220, 50));
        jEditorPane.setMinimumSize(new Dimension(180, 50));
        this.rawPanel.add((Component)jEditorPane, "South");
    }

    private void initButtonPanel() {
        this.okButton.setText(Globals.lang("Accept"));
        this.okButton.addActionListener(this);
        this.cancelButton.setText(Globals.lang("Cancel"));
        this.cancelButton.addActionListener(this);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded(this.okButton);
        buttonBarBuilder.addGridded(this.cancelButton);
        buttonBarBuilder.addGlue();
    }

    private void initSourcePanel() {
        this.preview = new JTextArea();
        this.preview.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.preview);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(500, 255));
        jScrollPane.setMinimumSize(new Dimension(10, 10));
        this.sourcePanel.setLayout(new BorderLayout());
        this.sourcePanel.add((Component)jScrollPane, "Center");
    }

    protected void addStylesToDocument(StyledDocument styledDocument) {
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = styledDocument.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "SansSerif");
        StyleConstants.setFontSize(style, 12);
        Style style3 = styledDocument.addStyle("oldused", style2);
        StyleConstants.setItalic(style3, true);
        StyleConstants.setForeground(style3, Color.blue);
        style3 = styledDocument.addStyle("used", style2);
        StyleConstants.setBold(style3, true);
        StyleConstants.setForeground(style3, Color.blue);
        style3 = styledDocument.addStyle("marked", style2);
        StyleConstants.setBold(style3, true);
        StyleConstants.setForeground(style3, Color.red);
        style3 = styledDocument.addStyle("small", style2);
        StyleConstants.setFontSize(style3, 10);
        style3 = styledDocument.addStyle("large", style2);
        StyleConstants.setFontSize(style3, 16);
    }

    private void insertTextForTag() {
        String string;
        String string2 = (String)this.fieldList.getSelectedValue();
        if (string2 != null && (string = this.textPane.getSelectedText()) != null) {
            int n = this.textPane.getSelectionStart();
            int n2 = this.textPane.getSelectionEnd();
            this.textPane.setSelectionEnd(n);
            this.doc.setCharacterAttributes(n, n2 - n, this.doc.getStyle("marked"), true);
            if (this.overRadio.isSelected()) {
                this.entry.setField(string2, string);
                this.marked.setStyleForTag(string2, "regular", this.doc);
                this.marked.insertPosition(string2, n, n2);
            } else {
                this.marked.appendPosition(string2, n, n2);
                String string3 = (String)this.entry.getField(string2);
                if (string3 != null) {
                    if (string2.hashCode() == "author".hashCode()) {
                        this.entry.setField(string2, string3 + " and " + string);
                    } else {
                        this.entry.setField(string2, string3 + string);
                    }
                } else {
                    this.entry.setField(string2, string);
                }
            }
            this.updateSourceView();
        }
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.okPressed = true;
            this.dispose();
        } else if (object == this.cancelButton) {
            this.dispose();
        } else if (object == this.insertButton) {
            this.insertTextForTag();
        }
    }

    private final void updateSourceView() {
        StringWriter stringWriter = new StringWriter(200);
        try {
            this.entry.write(stringWriter, new LatexFieldFormatter(), false);
            String string = stringWriter.getBuffer().toString();
            this.preview.setText(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fieldList.clearSelection();
    }

    private final String[] getAllFields() {
        int n = 0;
        String[][] stringArrayArray = new String[3][];
        if (this.entry != null) {
            stringArrayArray[0] = this.entry.getRequiredFields();
            stringArrayArray[1] = this.entry.getGeneralFields();
            stringArrayArray[2] = this.entry.getOptionalFields();
        }
        for (int i = 0; i < 3; ++i) {
            if (stringArrayArray[i] == null) continue;
            n += stringArrayArray[i].length;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            if (stringArrayArray[i] == null) continue;
            System.arraycopy(stringArrayArray[i], 0, stringArray, n2, stringArrayArray[i].length);
            n2 += stringArrayArray[i].length;
        }
        return stringArray;
    }

    class FieldListMouseListener
    extends MouseAdapter {
        FieldListMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                TextInputDialog.this.insertTextForTag();
            }
        }
    }

    class SimpleCellRenderer
    extends DefaultListCellRenderer {
        private Font baseFont;
        private Font usedFont;
        private ImageIcon okIcon = GUIGlobals.getImage("complete");
        private ImageIcon needIcon = GUIGlobals.getImage("wrong");

        public SimpleCellRenderer(Font font) {
            this.baseFont = font;
            this.usedFont = this.baseFont.deriveFont(2);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = object.toString();
            if (TextInputDialog.this.entry.getField(string) != null) {
                this.setForeground(Color.gray);
                this.setFont(this.usedFont);
                this.setIcon(this.okIcon);
                this.setToolTipText("filled");
            } else {
                this.setIcon(this.needIcon);
                this.setToolTipText("field is missing");
            }
            return this;
        }
    }

    class FieldListSelectionHandler
    implements ListSelectionListener {
        private int lastIndex = -1;

        FieldListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl;
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            int n = listSelectionModel.getAnchorSelectionIndex();
            if (n != this.lastIndex && !(bl = listSelectionEvent.getValueIsAdjusting())) {
                String string;
                if (this.lastIndex > -1) {
                    string = TextInputDialog.this.fieldList.getModel().getElementAt(this.lastIndex).toString();
                    TextInputDialog.this.marked.setStyleForTag(string, "used", TextInputDialog.this.doc);
                }
                string = TextInputDialog.this.fieldList.getModel().getElementAt(n).toString();
                TextInputDialog.this.marked.setStyleForTag(string, "marked", TextInputDialog.this.doc);
                this.lastIndex = n;
            }
        }
    }

    class MenuHeaderAction
    extends BasicAction {
        public MenuHeaderAction() {
            super("Edit");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class ClearAction
    extends BasicAction {
        public ClearAction() {
            super("Clear", "Clear_inputarea", GUIGlobals.getIconUrl("new"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextInputDialog.this.textPane.setText("");
        }
    }

    class LoadAction
    extends BasicAction {
        public LoadAction() {
            super("Open", "Open_file", GUIGlobals.getIconUrl("open"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = null;
                string = Globals.getNewFile(TextInputDialog.this._frame, null, null, ".txt", 0, false);
                if (string != null) {
                    File file = new File(string);
                    TextInputDialog.this.doc.remove(0, TextInputDialog.this.doc.getLength());
                    EditorKit editorKit = TextInputDialog.this.textPane.getEditorKit();
                    if (editorKit != null) {
                        editorKit.read(new FileInputStream(file), (Document)TextInputDialog.this.doc, 0);
                        TextInputDialog.this.doc.setLogicalStyle(0, TextInputDialog.this.doc.getStyle("regular"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PasteAction
    extends BasicAction {
        public PasteAction() {
            super("Paste", "Paste from clipboard", GUIGlobals.getIconUrl("paste"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ClipBoardManager.clipBoard.getClipboardContents();
            if (string != null) {
                int n = TextInputDialog.this.textPane.getSelectionStart();
                int n2 = TextInputDialog.this.textPane.getSelectionEnd();
                if (n2 - n > 0) {
                    TextInputDialog.this.textPane.replaceSelection("");
                }
                int n3 = TextInputDialog.this.textPane.getCaretPosition();
                try {
                    TextInputDialog.this.doc.insertString(n3, string, TextInputDialog.this.doc.getStyle("regular"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

