/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

public class QuotedStringTokenizer {
    private final String m_content;
    private final int m_contentLength;
    private final String m_delimiters;
    private final char m_quoteChar;
    private int m_index = 0;

    public QuotedStringTokenizer(String string, String string2, char c) {
        this.m_content = string;
        this.m_delimiters = string2;
        this.m_quoteChar = c;
        this.m_contentLength = this.m_content.length();
        while (this.isDelimiter(this.m_content.charAt(this.m_index)) && this.m_index < this.m_contentLength) {
            ++this.m_index;
        }
    }

    public String nextToken() {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.m_index < this.m_contentLength) {
            char c = this.m_content.charAt(this.m_index);
            if (c == this.m_quoteChar) {
                ++this.m_index;
                if (this.m_index < this.m_contentLength) {
                    stringBuffer.append(this.m_content.charAt(this.m_index));
                }
            } else if (this.isDelimiter(c)) {
                do {
                    ++this.m_index;
                } while (this.m_index < this.m_contentLength && this.isDelimiter(this.m_content.charAt(this.m_index)));
                return stringBuffer.toString();
            }
            stringBuffer.append(c);
            ++this.m_index;
        }
        return stringBuffer.toString();
    }

    private boolean isDelimiter(char c) {
        return this.m_delimiters.indexOf(c) >= 0;
    }

    public boolean hasMoreTokens() {
        return this.m_index < this.m_contentLength;
    }
}

