/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;
import net.sf.jabref.Globals;
import net.sf.jabref.util.CaseChanger;

public class CaseChangeMenu
extends JMenu
implements ActionListener {
    static CaseChanger cc = new CaseChanger();
    JMenuItem[] changeCaseItems;
    private JTextComponent parent;

    public CaseChangeMenu(JTextComponent jTextComponent) {
        super(Globals.lang("Change case"));
        this.parent = jTextComponent;
        int n = cc.getNumModes();
        this.changeCaseItems = new JMenuItem[n];
        for (int i = 0; i < n; ++i) {
            this.changeCaseItems[i] = new JMenuItem(Globals.lang(cc.getModeName(i)));
            this.changeCaseItems[i].addActionListener(this);
            this.add(this.changeCaseItems[i]);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = cc.getNumModes();
        for (int i = 0; i < n; ++i) {
            if (object != this.changeCaseItems[i]) continue;
            this.caseChange(i);
            break;
        }
    }

    private void caseChange(int n) {
        this.parent.setText(cc.changeCase(this.parent.getText(), n));
    }
}

