/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;

public class UndoableInsertString
extends AbstractUndoableEdit {
    private BibtexDatabase base;
    private BasePanel panel;
    private BibtexString string;

    public UndoableInsertString(BasePanel basePanel, BibtexDatabase bibtexDatabase, BibtexString bibtexString) {
        this.base = bibtexDatabase;
        this.panel = basePanel;
        this.string = bibtexString;
    }

    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("insert string ");
    }

    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("insert string ");
    }

    public void undo() {
        super.undo();
        this.base.removeString(this.string.getId());
        this.panel.updateStringDialog();
    }

    public void redo() {
        super.redo();
        try {
            this.base.addString(this.string);
        }
        catch (KeyCollisionException keyCollisionException) {
            keyCollisionException.printStackTrace();
        }
        this.panel.updateStringDialog();
    }
}

