/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.mods;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.mods.MODSEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MODSDatabase {
    protected Set entries = new HashSet();

    public MODSDatabase() {
    }

    public MODSDatabase(BibtexDatabase bibtexDatabase) {
        this();
        Collection collection = bibtexDatabase.getEntries();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
            MODSEntry mODSEntry = new MODSEntry(bibtexEntry);
            this.entries.add(mODSEntry);
        }
    }

    public Document getDOMrepresentation() {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = document.createElement("modsCollection");
            element.setAttribute("xmlns", "http://www.loc.gov/mods/v3");
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttribute("xsi:schemaLocation", "http://www.loc.gov/mods/v3 http://www.loc.gov/standards/mods/v3/mods-3-0.xsd");
            Iterator iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                MODSEntry mODSEntry = (MODSEntry)iterator.next();
                Element element2 = mODSEntry.getDOMrepresentation(document);
                element.appendChild(element2);
            }
            document.appendChild(element);
        }
        catch (Exception exception) {
            System.out.println("Exception caught..." + exception);
            exception.printStackTrace();
        }
        return document;
    }
}

