/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.journals.JournalAbbreviations;
import net.sf.jabref.net.URLDownload;

public class ManageJournalsPanel
extends JPanel {
    JabRefFrame frame;
    JTextField personalFile = new JTextField();
    AbbreviationsTableModel tableModel = new AbbreviationsTableModel();
    JTable userTable;
    JPanel userPanel = new JPanel();
    JPanel journalEditPanel;
    JPanel externalFilesPanel = new JPanel();
    JPanel addExtPan = new JPanel();
    JTextField nameTf = new JTextField();
    JTextField newNameTf = new JTextField();
    JTextField abbrTf = new JTextField();
    List externals = new ArrayList();
    JDialog dialog;
    JRadioButton newFile = new JRadioButton(Globals.lang("New file"));
    JRadioButton oldFile = new JRadioButton(Globals.lang("Existing file"));
    JButton add = new JButton(GUIGlobals.getImage("add"));
    JButton remove = new JButton(GUIGlobals.getImage("remove"));
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JButton help = new JButton(Globals.lang("Help"));
    JButton browseOld = new JButton(Globals.lang("Browse"));
    JButton browseNew = new JButton(Globals.lang("Browse"));
    JButton addExt = new JButton(GUIGlobals.getImage("add"));

    public ManageJournalsPanel(final JabRefFrame jabRefFrame) {
        this.frame = jabRefFrame;
        this.personalFile.setEditable(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.newFile);
        buttonGroup.add(this.oldFile);
        this.addExtPan.setLayout(new BorderLayout());
        this.addExtPan.add((Component)this.addExt, "East");
        this.addExtPan.setToolTipText(Globals.lang("Add"));
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:200dlu:grow, 4dlu, fill:pref", "pref, 20dlu, 20dlu, fill:200dlu, 4dlu, pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.addSeparator(Globals.lang("Personal journal list"), cellConstraints.xyw(2, 1, 6));
        defaultFormBuilder.add((Component)this.newFile, cellConstraints.xy(3, 2));
        defaultFormBuilder.add((Component)this.newNameTf, cellConstraints.xy(5, 2));
        defaultFormBuilder.add((Component)this.browseNew, cellConstraints.xy(7, 2));
        defaultFormBuilder.add((Component)this.oldFile, cellConstraints.xy(3, 3));
        defaultFormBuilder.add((Component)this.personalFile, cellConstraints.xy(5, 3));
        defaultFormBuilder.add((Component)this.browseOld, cellConstraints.xy(7, 3));
        this.userPanel.setLayout(new BorderLayout());
        defaultFormBuilder.add((Component)this.userPanel, cellConstraints.xyw(2, 4, 4));
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addGridded(this.add);
        buttonStackBuilder.addGridded(this.remove);
        buttonStackBuilder.addGlue();
        defaultFormBuilder.add((Component)buttonStackBuilder.getPanel(), cellConstraints.xy(7, 4));
        defaultFormBuilder.addSeparator(Globals.lang("External files"), cellConstraints.xyw(2, 6, 6));
        this.externalFilesPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)defaultFormBuilder.getPanel(), "North");
        this.add((Component)this.externalFilesPanel, "Center");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded(this.ok);
        buttonBarBuilder.addGridded(this.cancel);
        buttonBarBuilder.addUnrelatedGap();
        buttonBarBuilder.addGridded(this.help);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.dialog = new JDialog(jabRefFrame, Globals.lang("Journal abbreviations"), false);
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        FormLayout formLayout2 = new FormLayout("right:pref, 4dlu, fill:180dlu", "");
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(formLayout2);
        defaultFormBuilder2.append(Globals.lang("Journal name"));
        defaultFormBuilder2.append(this.nameTf);
        defaultFormBuilder2.nextLine();
        defaultFormBuilder2.append(Globals.lang("ISO abbreviation"));
        defaultFormBuilder2.append(this.abbrTf);
        this.journalEditPanel = defaultFormBuilder2.getPanel();
        this.browseNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                File file = null;
                if (!ManageJournalsPanel.this.newNameTf.getText().equals("")) {
                    file = new File(ManageJournalsPanel.this.newNameTf.getText());
                }
                if ((string = Globals.getNewFile(jabRefFrame, file, null, 1, false)) != null) {
                    if (file == null || ManageJournalsPanel.this.tableModel.getRowCount() > 0) {
                        // empty if block
                    }
                    ManageJournalsPanel.this.newNameTf.setText(string);
                    ManageJournalsPanel.this.newFile.setSelected(true);
                }
            }
        });
        this.browseOld.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                File file = null;
                if (!ManageJournalsPanel.this.personalFile.getText().equals("")) {
                    file = new File(ManageJournalsPanel.this.personalFile.getText());
                }
                if ((string = Globals.getNewFile(jabRefFrame, file, null, 0, false)) != null) {
                    if (file == null || ManageJournalsPanel.this.tableModel.getRowCount() > 0) {
                        // empty if block
                    }
                    ManageJournalsPanel.this.personalFile.setText(string);
                    ManageJournalsPanel.this.oldFile.setSelected(true);
                    ManageJournalsPanel.this.oldFile.setEnabled(true);
                    ManageJournalsPanel.this.setupUserTable();
                }
            }
        });
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ManageJournalsPanel.this.readyToClose()) {
                    ManageJournalsPanel.this.storeSettings();
                    ManageJournalsPanel.this.dialog.dispose();
                }
            }
        });
        this.help.addActionListener(new HelpAction(Globals.helpDiag, GUIGlobals.journalAbbrHelp));
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageJournalsPanel.this.dialog.dispose();
            }
        });
        this.add.addActionListener(this.tableModel);
        this.remove.addActionListener(this.tableModel);
        this.addExt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageJournalsPanel.this.externals.add(new ExternalFileEntry());
                ManageJournalsPanel.this.buildExternalsPanel();
            }
        });
        int n = this.getPreferredSize().width;
        this.dialog.setSize(n + 10, 700);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setValues() {
        this.personalFile.setText(Globals.prefs.get("personalJournalList"));
        if (this.personalFile.getText().length() == 0) {
            this.newFile.setSelected(true);
            this.oldFile.setEnabled(false);
        } else {
            this.oldFile.setSelected(true);
            this.oldFile.setEnabled(true);
        }
        this.setupUserTable();
        this.setupExternals();
        this.buildExternalsPanel();
    }

    private void buildExternalsPanel() {
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("fill:pref:grow", ""));
        Object object = this.externals.iterator();
        while (object.hasNext()) {
            ExternalFileEntry externalFileEntry = (ExternalFileEntry)object.next();
            defaultFormBuilder.append(externalFileEntry.getPanel());
            defaultFormBuilder.nextLine();
        }
        defaultFormBuilder.append(Box.createVerticalGlue());
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.addExtPan);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Box.createVerticalGlue());
        object = new JScrollPane(defaultFormBuilder.getPanel());
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.externalFilesPanel.setMinimumSize(new Dimension(400, 400));
        this.externalFilesPanel.setPreferredSize(new Dimension(400, 400));
        this.externalFilesPanel.removeAll();
        this.externalFilesPanel.add((Component)object, "Center");
        this.externalFilesPanel.revalidate();
        this.externalFilesPanel.repaint();
    }

    private void setupExternals() {
        String[] stringArray = Globals.prefs.getStringArray("externalJournalLists");
        if (stringArray == null || stringArray.length == 0) {
            ExternalFileEntry externalFileEntry = new ExternalFileEntry();
            this.externals.add(externalFileEntry);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                ExternalFileEntry externalFileEntry = new ExternalFileEntry(stringArray[i]);
                this.externals.add(externalFileEntry);
            }
        }
    }

    public void setupUserTable() {
        JournalAbbreviations journalAbbreviations = new JournalAbbreviations();
        String string = this.personalFile.getText();
        if (!string.equals("") && new File(string).exists()) {
            try {
                journalAbbreviations.readJournalList(new File(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        this.tableModel.setJournals(journalAbbreviations.getJournals());
        this.userTable = new JTable(this.tableModel);
        this.userTable.addMouseListener(this.tableModel.getMouseListener());
        this.userPanel.add((Component)new JScrollPane(this.userTable), "Center");
    }

    public boolean readyToClose() {
        if (this.newFile.isSelected()) {
            if (this.newNameTf.getText().length() > 0) {
                File file = new File(this.newNameTf.getText());
                return !file.exists() || JOptionPane.showConfirmDialog(this, "'" + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Store journal abbreviations"), 2) == 0;
            }
            if (this.tableModel.getRowCount() > 0) {
                JOptionPane.showMessageDialog(this, Globals.lang("You must choose a file name to store journal abbreviations"), Globals.lang("Store journal abbreviations"), 0);
                return false;
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSettings() {
        Object object;
        String[] stringArray;
        Object object2;
        File file = null;
        if (this.newFile.isSelected()) {
            if (this.newNameTf.getText().length() > 0) {
                file = new File(this.newNameTf.getText());
            }
        } else {
            file = new File(this.personalFile.getText());
        }
        if (file != null) {
            object2 = null;
            try {
                object2 = new FileWriter(file, false);
                stringArray = this.tableModel.getJournals().iterator();
                while (stringArray.hasNext()) {
                    object = (JournalEntry)stringArray.next();
                    ((Writer)object2).write(((JournalEntry)object).name);
                    ((Writer)object2).write(" = ");
                    ((Writer)object2).write(((JournalEntry)object).abbreviation);
                    ((Writer)object2).write(Globals.NEWLINE);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (object2 != null) {
                    try {
                        ((OutputStreamWriter)object2).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            stringArray = file.getPath();
            if (stringArray.equals("")) {
                stringArray = null;
            }
            Globals.prefs.put("personalJournalList", (String)stringArray);
        }
        object2 = new ArrayList();
        stringArray = this.externals.iterator();
        while (stringArray.hasNext()) {
            object = (ExternalFileEntry)stringArray.next();
            if (((ExternalFileEntry)object).getValue().equals("")) continue;
            ((ArrayList)object2).add(((ExternalFileEntry)object).getValue());
        }
        if (((ArrayList)object2).size() == 0) {
            Globals.prefs.put("externalJournalLists", "");
        } else {
            stringArray = ((ArrayList)object2).toArray(new String[((ArrayList)object2).size()]);
            Globals.prefs.putStringArray("externalJournalLists", stringArray);
        }
        Globals.initializeJournalNames();
    }

    class JournalEntry
    implements Comparable {
        String name;
        String abbreviation;

        public JournalEntry(String string, String string2) {
            this.name = string;
            this.abbreviation = string2;
        }

        public int compareTo(Object object) {
            JournalEntry journalEntry = (JournalEntry)object;
            return this.name.compareTo(journalEntry.name);
        }
    }

    class ExternalFileEntry {
        private JPanel pan;
        private JTextField tf;
        private JButton browse = new JButton(Globals.lang("Browse"));
        private JButton view = new JButton(Globals.lang("Preview"));
        private JButton clear = new JButton(GUIGlobals.getImage("delete"));
        private JButton download = new JButton(Globals.lang("Download"));

        public ExternalFileEntry() {
            this.tf = new JTextField();
            this.setupPanel();
        }

        public ExternalFileEntry(String string) {
            this.tf = new JTextField(string);
            this.setupPanel();
        }

        private void setupPanel() {
            this.tf.setEditable(false);
            BrowseAction browseAction = new BrowseAction(this.tf, false);
            this.browse.addActionListener(browseAction);
            DownloadAction downloadAction = new DownloadAction(this.tf);
            this.download.addActionListener(downloadAction);
            DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("fill:pref:grow, 4dlu, fill:pref, 4dlu, fill:pref, 4dlu, fill:pref, 4dlu, fill:pref", ""));
            defaultFormBuilder.append(this.tf);
            defaultFormBuilder.append(this.browse);
            defaultFormBuilder.append(this.download);
            defaultFormBuilder.append(this.view);
            defaultFormBuilder.append(this.clear);
            this.pan = defaultFormBuilder.getPanel();
            this.view.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JournalAbbreviations journalAbbreviations = new JournalAbbreviations(new File(ExternalFileEntry.this.tf.getText()));
                        JTable jTable = new JTable(journalAbbreviations.getTableModel());
                        JScrollPane jScrollPane = new JScrollPane(jTable);
                        JOptionPane.showMessageDialog(null, jScrollPane, Globals.lang("Journal list preview"), 1);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        JOptionPane.showMessageDialog(null, Globals.lang("File '%0' not found", ExternalFileEntry.this.tf.getText()), Globals.lang("Error"), 0);
                    }
                }
            });
            this.clear.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((ExternalFileEntry)ExternalFileEntry.this).ManageJournalsPanel.this.externals.remove(ExternalFileEntry.this);
                    ManageJournalsPanel.this.buildExternalsPanel();
                }
            });
            this.clear.setToolTipText(Globals.lang("Remove"));
        }

        public JPanel getPanel() {
            return this.pan;
        }

        public String getValue() {
            return this.tf.getText();
        }
    }

    class AbbreviationsTableModel
    extends AbstractTableModel
    implements ActionListener {
        String[] names = new String[]{Globals.lang("Journal name"), Globals.lang("Abbreviation")};
        ArrayList journals = null;

        public void setJournals(Map map) {
            this.journals = new ArrayList();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                this.journals.add(new JournalEntry(string, string2));
            }
            this.fireTableDataChanged();
        }

        public ArrayList getJournals() {
            return this.journals;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.journals.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ((JournalEntry)this.journals.get((int)n)).name;
            }
            return ((JournalEntry)this.journals.get((int)n)).abbreviation;
        }

        public void setValueAt(Object object, int n, int n2) {
            JournalEntry journalEntry = (JournalEntry)this.journals.get(n);
            if (n2 == 0) {
                journalEntry.name = (String)object;
            } else {
                journalEntry.abbreviation = (String)object;
            }
        }

        public String getColumnName(int n) {
            return this.names[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public MouseListener getMouseListener() {
            return new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        JTable jTable = (JTable)mouseEvent.getSource();
                        int n = jTable.rowAtPoint(mouseEvent.getPoint());
                        ((AbbreviationsTableModel)AbbreviationsTableModel.this).ManageJournalsPanel.this.nameTf.setText((String)AbbreviationsTableModel.this.getValueAt(n, 0));
                        ((AbbreviationsTableModel)AbbreviationsTableModel.this).ManageJournalsPanel.this.abbrTf.setText((String)AbbreviationsTableModel.this.getValueAt(n, 1));
                        if (JOptionPane.showConfirmDialog(((AbbreviationsTableModel)AbbreviationsTableModel.this).ManageJournalsPanel.this.dialog, ((AbbreviationsTableModel)AbbreviationsTableModel.this).ManageJournalsPanel.this.journalEditPanel, Globals.lang("Edit journal"), 2) == 0) {
                            AbbreviationsTableModel.this.setValueAt(((AbbreviationsTableModel)AbbreviationsTableModel.this).ManageJournalsPanel.this.nameTf.getText(), n, 0);
                            AbbreviationsTableModel.this.setValueAt(((AbbreviationsTableModel)AbbreviationsTableModel.this).ManageJournalsPanel.this.abbrTf.getText(), n, 1);
                            Collections.sort(AbbreviationsTableModel.this.journals);
                            AbbreviationsTableModel.this.fireTableDataChanged();
                        }
                    }
                }
            };
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray;
            if (actionEvent.getSource() == ManageJournalsPanel.this.add) {
                ManageJournalsPanel.this.nameTf.setText("");
                ManageJournalsPanel.this.abbrTf.setText("");
                if (JOptionPane.showConfirmDialog(ManageJournalsPanel.this.dialog, ManageJournalsPanel.this.journalEditPanel, Globals.lang("Edit journal"), 2) == 0) {
                    this.journals.add(new JournalEntry(ManageJournalsPanel.this.nameTf.getText(), ManageJournalsPanel.this.abbrTf.getText()));
                    Collections.sort(this.journals);
                    this.fireTableDataChanged();
                }
            } else if (actionEvent.getSource() == ManageJournalsPanel.this.remove && (nArray = ManageJournalsPanel.this.userTable.getSelectedRows()).length > 0) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.journals.remove(nArray[i]);
                }
                this.fireTableDataChanged();
            }
        }
    }

    class BrowseAction
    extends AbstractAction {
        JTextField comp;
        boolean dir;

        public BrowseAction(JTextField jTextField, boolean bl) {
            super(Globals.lang("Browse"));
            this.dir = bl;
            this.comp = jTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            string = this.dir ? Globals.getNewDir(ManageJournalsPanel.this.frame, new File(this.comp.getText()), "_non__", 0, false) : Globals.getNewFile(ManageJournalsPanel.this.frame, new File(this.comp.getText()), "_non__", 0, false);
            if (string != null) {
                File file = new File(string);
                this.comp.setText(file.getPath());
            }
        }
    }

    class DownloadAction
    extends AbstractAction {
        JTextField comp;

        public DownloadAction(JTextField jTextField) {
            super(Globals.lang("Download"));
            this.comp = jTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            string = JOptionPane.showInputDialog(Globals.lang("Choose the URL to download. The default value points to a list provided by the JabRef developers."), (Object)"http://jabref.sf.net/journals/journal_abbreviations_general.txt");
            if (string == null) {
                return;
            }
            try {
                URL uRL = new URL(string);
                String string2 = Globals.getNewFile(ManageJournalsPanel.this.frame, new File(System.getProperty("user.home")), null, 1, false);
                if (string2 == null) {
                    return;
                }
                File file = new File(string2);
                URLDownload uRLDownload = new URLDownload(this.comp, uRL, file);
                uRLDownload.download();
                this.comp.setText(file.getPath());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

