/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class SilverPlatterImporter
extends ImportFormat {
    public String getFormatName() {
        return "SilverPlatter";
    }

    public String getCLIId() {
        return "silverplatter";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("Record.*INSPEC.*");
        while ((string = bufferedReader.readLine()) != null) {
            if (pattern.matcher(string).find()) {
                return false;
            }
            if (string.length() < 5 || !string.substring(0, 5).equals("TI:  ")) continue;
            return true;
        }
        return false;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() < 2) {
                stringBuffer.append("__::__").append(string);
                continue;
            }
            stringBuffer.append("__NEWFIELD__").append(string);
        }
        bufferedReader.close();
        String[] stringArray = stringBuffer.toString().split("__::__");
        String string2 = "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            Object v;
            String string3;
            if (stringArray[i].trim().length() < 6) continue;
            hashMap.clear();
            String[] stringArray2 = stringArray[i].split("__NEWFIELD__");
            for (int j = 0; j < stringArray2.length; ++j) {
                String string4;
                String string5;
                if (stringArray2[j].length() < 6) continue;
                string3 = stringArray2[j];
                String string6 = string3.substring(0, 2);
                String string7 = string3.substring(5);
                if (string6.equals("TI")) {
                    hashMap.put("title", string7);
                    continue;
                }
                if (string6.equals("AU")) {
                    if (string7.trim().endsWith("(ed)")) {
                        String string8 = string7.trim();
                        string8 = string8.substring(0, string8.length() - 4);
                        hashMap.put("editor", AuthorList.fixAuthor_lastNameFirst(string8.replaceAll(",-", ", ").replaceAll(";", " and ")));
                        continue;
                    }
                    hashMap.put("author", AuthorList.fixAuthor_lastNameFirst(string7.replaceAll(",-", ", ").replaceAll(";", " and ")));
                    continue;
                }
                if (string6.equals("AB")) {
                    hashMap.put("abstract", string7);
                    continue;
                }
                if (string6.equals("DE")) {
                    String string9 = string7.replaceAll("-;", ",").toLowerCase();
                    hashMap.put("keywords", string9.substring(0, string9.length() - 1));
                    continue;
                }
                if (string6.equals("SO")) {
                    int n = string7.indexOf(".");
                    if (n < 0) continue;
                    string5 = string7.substring(0, n);
                    hashMap.put("journal", string5.replaceAll("-", " "));
                    string7 = string7.substring(n);
                    n = string7.indexOf(";");
                    if (n < 5) continue;
                    string4 = string7.substring(n - 5, n).trim();
                    hashMap.put("year", string4);
                    string7 = string7.substring(n);
                    n = string7.indexOf(":");
                    if (n < 0) continue;
                    String string10 = string7.substring(n + 1).trim();
                    hashMap.put("pages", string10);
                    hashMap.put("volume", string7.substring(1, n));
                    continue;
                }
                if (string6.equals("PB")) {
                    int n = string7.indexOf(":");
                    if (n < 0) continue;
                    string5 = string7.substring(0, n);
                    hashMap.put("publisher", string5.replaceAll("-", " ").trim());
                    string7 = string7.substring(n);
                    n = string7.indexOf(", ");
                    if (n + 2 >= string7.length()) continue;
                    string4 = string7.substring(n + 2).trim();
                    hashMap.put("year", string4);
                    continue;
                }
                if (!string6.equals("DT")) continue;
                if ((string7 = string7.trim()).equals("Monograph")) {
                    string2 = "book";
                    continue;
                }
                if (string7.toLowerCase().indexOf("journal") >= 0) {
                    string2 = "article";
                    continue;
                }
                if (string7.equals("Contribution") || string7.equals("Chapter")) {
                    string2 = "incollection";
                    bl = true;
                    continue;
                }
                string2 = string7.replaceAll(" ", "");
            }
            if (bl && (v = hashMap.get("title")) != null) {
                string3 = ((String)v).trim();
                int n = string3.indexOf("\" in ");
                int n2 = string3.lastIndexOf(" ");
                if (n > 1) {
                    hashMap.put("title", string3.substring(1, n));
                }
                if (n2 > n) {
                    hashMap.put("pages", string3.substring(n2).replaceAll("-", "--"));
                }
            }
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string2));
            bibtexEntry.setField(hashMap);
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }
}

