/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class ScifinderImporter
extends ImportFormat {
    public String getFormatName() {
        return "Scifinder";
    }

    public String getCLIId() {
        return "scifinder";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        return true;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
        }
        String[] stringArray = stringBuffer.toString().split("START_RECORD");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("FIELD ");
            String string2 = "";
            hashMap.clear();
            for (int j = 0; j < stringArray2.length; ++j) {
                String[] stringArray3;
                if (stringArray2[j].indexOf(":") < 0 || (stringArray3 = new String[]{stringArray2[j].substring(0, stringArray2[j].indexOf(":")), stringArray2[j].substring(stringArray2[j].indexOf(":") + 1).trim()}).length <= 1) continue;
                if (stringArray3[0].equals("Author")) {
                    hashMap.put("author", AuthorList.fixAuthor_lastNameFirst(stringArray3[1].replaceAll(";", " and ")));
                    continue;
                }
                if (stringArray3[0].equals("Title")) {
                    hashMap.put("title", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Journal Title")) {
                    hashMap.put("journal", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Volume")) {
                    hashMap.put("volume", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Page")) {
                    hashMap.put("pages", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Publication Year")) {
                    hashMap.put("year", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Abstract")) {
                    hashMap.put("abstract", stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equals("Supplementary Terms")) {
                    hashMap.put("keywords", stringArray3[1]);
                    continue;
                }
                if (!stringArray3[0].equals("Document Type")) continue;
                string2 = stringArray3[1].startsWith("Journal") || stringArray3[1].startsWith("Review") ? "article" : (stringArray3[1].equals("Dissertation") ? "phdthesis" : stringArray3[1]);
            }
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string2));
            bibtexEntry.setField(hashMap);
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }
}

