/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class IsiImporter
extends ImportFormat {
    public String getFormatName() {
        return "ISI";
    }

    public String getCLIId() {
        return "isi";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("PY \\d{4}");
        while ((string = bufferedReader.readLine()) != null) {
            if (!pattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        Object object;
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() < 3) continue;
            if (string.substring(0, 3).equals("PT ")) {
                stringBuffer.append("::").append(string);
                continue;
            }
            object = string.substring(0, 3).trim();
            if (((String)object).length() == 2) {
                stringBuffer.append(" ## ");
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append("EOLEOL");
            stringBuffer.append(string.substring(2, string.length()));
        }
        object = stringBuffer.toString().split("::");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < ((String[])object).length; ++i) {
            Object object2;
            Object object3;
            String[] stringArray = object[i].split(" ## ");
            if (stringArray.length == 0) {
                stringArray = ((String)object[i]).split("\n");
            }
            Object object4 = "";
            String string2 = "";
            Object object5 = "";
            hashMap.clear();
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].length() <= 2) continue;
                stringArray[j] = stringArray[j].replaceAll(" - ", "");
                object3 = stringArray[j].substring(0, 2);
                object2 = stringArray[j].substring(2);
                object2 = ((String)object2).trim();
                if (((String)object3).equals("PT")) {
                    string2 = ((String)object2).replaceAll("Journal", "article").replaceAll("J", "article");
                    object4 = "article";
                    continue;
                }
                if (((String)object3).equals("TY")) {
                    if (!"CONF".equals(object2)) continue;
                    object4 = "inproceedings";
                    continue;
                }
                if (((String)object3).equals("JO")) {
                    hashMap.put("booktitle", object2);
                    continue;
                }
                if (((String)object3).equals("AU")) {
                    String string3 = this.isiAuthorConvert(AuthorList.fixAuthor_lastNameFirst(((String)object2).replaceAll("EOLEOL", " and ")));
                    if (hashMap.get("author") != null) {
                        string3 = (String)hashMap.get("author") + " and " + string3;
                    }
                    hashMap.put("author", string3);
                    continue;
                }
                if (((String)object3).equals("TI")) {
                    hashMap.put("title", ((String)object2).replaceAll("EOLEOL", " "));
                    continue;
                }
                if (((String)object3).equals("SO")) {
                    hashMap.put("journal", ((String)object2).replaceAll("EOLEOL", " "));
                    continue;
                }
                if (((String)object3).equals("ID")) {
                    hashMap.put("keywords", ((String)object2).replaceAll("EOLEOL", " "));
                    continue;
                }
                if (((String)object3).equals("AB")) {
                    hashMap.put("abstract", ((String)object2).replaceAll("EOLEOL", " "));
                    continue;
                }
                if (((String)object3).equals("BP") || ((String)object3).equals("BR") || ((String)object3).equals("SP")) {
                    object5 = object2;
                    continue;
                }
                if (((String)object3).equals("EP")) {
                    int n = ((String)object2).indexOf(32);
                    if (n != -1) {
                        object2 = ((String)object2).substring(0, n);
                    }
                    object5 = (String)object5 + "--" + (String)object2;
                    continue;
                }
                if (((String)object3).equals("AR")) {
                    object5 = object2;
                    continue;
                }
                if (((String)object3).equals("IS")) {
                    hashMap.put("number", object2);
                    continue;
                }
                if (((String)object3).equals("PY")) {
                    hashMap.put("year", object2);
                    continue;
                }
                if (((String)object3).equals("VL")) {
                    hashMap.put("volume", object2);
                    continue;
                }
                if (((String)object3).equals("PD")) {
                    String[] stringArray2 = ((String)object2).split(" ");
                    for (int k = 0; k < stringArray2.length; ++k) {
                        if (!Globals.MONTH_STRINGS.containsKey(stringArray2[k].toLowerCase())) continue;
                        hashMap.put("month", "#" + stringArray2[k].toLowerCase() + "#");
                    }
                    continue;
                }
                if (((String)object3).equals("DT")) {
                    object4 = object2;
                    if (((String)object4).equals("Review")) {
                        object4 = "article";
                        continue;
                    }
                    if (!((String)object4).equals("Article") && !string2.equals("Journal")) {
                        object4 = "misc";
                        continue;
                    }
                    object4 = "article";
                    continue;
                }
                if (!((String)object3).equals("CR")) continue;
                hashMap.put("CitedReferences", ((String)object2).replaceAll("EOLEOL", " ; ").trim());
            }
            if (!"".equals(object5)) {
                hashMap.put("pages", object5);
            }
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType((String)object4));
            object3 = new ArrayList();
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                Object k = object2.next();
                String string4 = (String)hashMap.get(k);
                if (string4 != null && string4.trim().length() != 0) continue;
                ((ArrayList)object3).add(k);
            }
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                hashMap.remove(object2.next());
            }
            bibtexEntry.setField(hashMap);
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }

    private String isiAuthorConvert(String string) {
        String[] stringArray = string.split(" and ");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(", ");
            if (n > 0) {
                stringBuffer.append(stringArray[i].substring(0, n));
                stringBuffer.append(", ");
                for (int j = n + 2; j < stringArray[i].length(); ++j) {
                    stringBuffer.append(stringArray[i].charAt(j));
                    stringBuffer.append(".");
                    if (j >= stringArray[i].length() - 1) continue;
                    stringBuffer.append(" ");
                }
            } else {
                stringBuffer.append(stringArray[i]);
            }
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(" and ");
        }
        return stringBuffer.toString();
    }
}

