/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class InspecImporter
extends ImportFormat {
    public String getFormatName() {
        return "INSPEC";
    }

    public String getCLIId() {
        return "inspec";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("Record.*INSPEC.*");
        while ((string = bufferedReader.readLine()) != null) {
            if (!pattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() < 2) continue;
            if (string.indexOf("Record") == 0) {
                stringBuffer.append("__::__").append(string);
                continue;
            }
            stringBuffer.append("__NEWFIELD__").append(string);
        }
        bufferedReader.close();
        String[] stringArray = stringBuffer.toString().split("__::__");
        String string2 = "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf("Record") != 0) continue;
            hashMap.clear();
            String[] stringArray2 = stringArray[i].split("__NEWFIELD__");
            for (int j = 0; j < stringArray2.length; ++j) {
                String string3 = stringArray2[j];
                String string4 = string3.substring(0, 2);
                String string5 = string3.substring(5);
                if (string4.equals("TI")) {
                    hashMap.put("title", string5);
                    continue;
                }
                if (string4.equals("PY")) {
                    hashMap.put("year", string5);
                    continue;
                }
                if (string4.equals("AU")) {
                    hashMap.put("author", AuthorList.fixAuthor_lastNameFirst(string5.replaceAll(",-", ", ").replaceAll(";", " and ")));
                    continue;
                }
                if (string4.equals("AB")) {
                    hashMap.put("abstract", string5);
                    continue;
                }
                if (string4.equals("ID")) {
                    hashMap.put("keywords", string5);
                    continue;
                }
                if (string4.equals("SO")) {
                    int n = string5.indexOf(".");
                    if (n < 0) continue;
                    String string6 = string5.substring(0, n);
                    hashMap.put("journal", string6.replaceAll("-", " "));
                    string5 = string5.substring(n);
                    n = string5.indexOf(";");
                    if (n < 5) continue;
                    String string7 = string5.substring(n - 5, n);
                    hashMap.put("year", string7);
                    string5 = string5.substring(n);
                    n = string5.indexOf(":");
                    if (n < 0) continue;
                    String string8 = string5.substring(n + 1).trim();
                    hashMap.put("pages", string8);
                    hashMap.put("volume", string5.substring(1, n));
                    continue;
                }
                if (!string4.equals("RT")) continue;
                string2 = (string5 = string5.trim()).equals("Journal-Paper") ? "article" : (string5.equals("Conference-Paper") || string5.equals("Conference-Paper; Journal-Paper") ? "inproceedings" : string5.replaceAll(" ", ""));
            }
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string2));
            bibtexEntry.setField(hashMap);
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }
}

