/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.BibtexString;
import net.sf.jabref.DuplicateResolverDialog;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableRemoveEntry;

public class ImportMenuItem
extends JMenuItem
implements ActionListener {
    JabRefFrame frame;
    boolean openInNew;
    MyWorker worker = null;
    ImportFormat importer;

    public ImportMenuItem(JabRefFrame jabRefFrame, boolean bl) {
        this(jabRefFrame, bl, null);
    }

    public ImportMenuItem(JabRefFrame jabRefFrame, boolean bl, ImportFormat importFormat) {
        super(importFormat != null ? importFormat.getFormatName() : Globals.lang("Autodetect format"));
        this.importer = importFormat;
        this.frame = jabRefFrame;
        this.openInNew = bl;
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.worker = new MyWorker();
        this.worker.init();
        this.worker.getWorker().run();
        this.worker.getCallBack().update();
    }

    public void automatedImport(String[] stringArray) {
        MyWorker myWorker = new MyWorker();
        myWorker.fileOk = true;
        myWorker.filenames = stringArray;
        myWorker.getWorker().run();
        myWorker.getCallBack().update();
    }

    public static ParserResult mergeImportResults(List list) {
        BibtexDatabase bibtexDatabase = new BibtexDatabase();
        Object object = null;
        boolean bl = false;
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            Object object3;
            Iterator iterator;
            Object object4;
            Object[] objectArray = (Object[])object2.next();
            if (objectArray[1] instanceof List) {
                object4 = (List)objectArray[1];
                bl |= object4.size() > 0;
                Util.setAutomaticFields((List)object4);
                iterator = object4.iterator();
                while (iterator.hasNext()) {
                    object3 = (BibtexEntry)iterator.next();
                    try {
                        ((BibtexEntry)object3).setId(Util.createNeutralId());
                        bibtexDatabase.insertEntry((BibtexEntry)object3);
                    }
                    catch (KeyCollisionException keyCollisionException) {
                        keyCollisionException.printStackTrace();
                    }
                }
                continue;
            }
            if (!(objectArray[1] instanceof ParserResult)) continue;
            object4 = (ParserResult)objectArray[1];
            boolean bl2 = bl = bl || ((ParserResult)object4).getDatabase().getEntryCount() > 0 || ((ParserResult)object4).getDatabase().getStringCount() > 0;
            if (object == null) {
                object = object4;
            }
            iterator = ((ParserResult)object4).getDatabase().getEntries().iterator();
            while (iterator.hasNext()) {
                object3 = (BibtexEntry)iterator.next();
                try {
                    bibtexDatabase.insertEntry((BibtexEntry)object3);
                }
                catch (KeyCollisionException keyCollisionException) {
                    keyCollisionException.printStackTrace();
                }
            }
            iterator = ((ParserResult)object4).getDatabase().getStringKeySet().iterator();
            while (iterator.hasNext()) {
                object3 = (BibtexString)((ParserResult)object4).getDatabase().getString(iterator.next()).clone();
                try {
                    bibtexDatabase.addString((BibtexString)object3);
                }
                catch (KeyCollisionException keyCollisionException) {}
            }
        }
        if (!bl) {
            return null;
        }
        if (list.size() == 1 && object != null) {
            return object;
        }
        object2 = new ParserResult(bibtexDatabase, new HashMap(), new HashMap());
        return object2;
    }

    class MyWorker
    extends AbstractWorker
    implements ImportInspectionDialog.CallBack {
        String[] filenames = null;
        String[] formatName = null;
        ParserResult bibtexResult = null;
        boolean fileOk = false;

        MyWorker() {
        }

        public void init() {
            this.filenames = Globals.getMultipleFiles(ImportMenuItem.this.frame, new File(Globals.prefs.get("workingDirectory")), ImportMenuItem.this.importer != null ? ImportMenuItem.this.importer.getExtensions() : null, true);
            if (this.filenames != null && this.filenames.length > 0) {
                ImportMenuItem.this.frame.block();
                ImportMenuItem.this.frame.output(Globals.lang("Starting import"));
                this.fileOk = true;
                Globals.prefs.put("workingDirectory", this.filenames[0]);
            }
        }

        public void run() {
            if (!this.fileOk) {
                return;
            }
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            for (int i = 0; i < this.filenames.length; ++i) {
                String string = this.filenames[i];
                if (ImportMenuItem.this.importer != null) {
                    try {
                        arrayList.add(new Object[]{ImportMenuItem.this.importer.getFormatName(), Globals.importFormatReader.importFromFile(ImportMenuItem.this.importer, string)});
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                arrayList.add(Globals.importFormatReader.importUnknownFormat(string));
            }
            this.bibtexResult = ImportMenuItem.mergeImportResults(arrayList);
        }

        public void update() {
            if (!this.fileOk) {
                return;
            }
            if (this.bibtexResult != null) {
                if (!ImportMenuItem.this.openInNew) {
                    BasePanel basePanel = (BasePanel)ImportMenuItem.this.frame.getTabbedPane().getSelectedComponent();
                    BibtexDatabase bibtexDatabase = basePanel.database();
                    if (Globals.prefs.getBoolean("useImportInspectionDialog") && (Globals.prefs.getBoolean("useImportInspectionDialogForSingle") || this.bibtexResult.getDatabase().getEntryCount() > 1)) {
                        ImportInspectionDialog importInspectionDialog = new ImportInspectionDialog(ImportMenuItem.this.frame, basePanel, BibtexFields.DEFAULT_INSPECTION_FIELDS, Globals.lang("Import"), ImportMenuItem.this.openInNew);
                        importInspectionDialog.addEntries(this.bibtexResult.getDatabase().getEntries());
                        importInspectionDialog.addCallBack(this);
                        importInspectionDialog.entryListComplete();
                        Util.placeDialog(importInspectionDialog, ImportMenuItem.this.frame);
                        importInspectionDialog.setVisible(true);
                        importInspectionDialog.toFront();
                    } else {
                        NamedCompound namedCompound = new NamedCompound(Globals.lang("Import entries"));
                        Iterator iterator = this.bibtexResult.getDatabase().getEntries().iterator();
                        while (iterator.hasNext()) {
                            BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
                            try {
                                boolean bl = true;
                                BibtexEntry bibtexEntry2 = Util.containsDuplicate(bibtexDatabase, bibtexEntry);
                                if (bibtexEntry2 != null) {
                                    int n = DuplicateResolverDialog.resolveDuplicateInImport(ImportMenuItem.this.frame, bibtexEntry2, bibtexEntry);
                                    if (n == 2) {
                                        bl = false;
                                    }
                                    if (n == 1) {
                                        bibtexDatabase.removeEntry(bibtexEntry2.getId());
                                        namedCompound.addEdit(new UndoableRemoveEntry(bibtexDatabase, bibtexEntry2, basePanel));
                                    }
                                }
                                if (!bl) continue;
                                bibtexDatabase.insertEntry(bibtexEntry);
                                namedCompound.addEdit(new UndoableInsertEntry(bibtexDatabase, bibtexEntry, basePanel));
                            }
                            catch (KeyCollisionException keyCollisionException) {
                                keyCollisionException.printStackTrace();
                            }
                        }
                        namedCompound.end();
                        basePanel.undoManager.addEdit(namedCompound);
                    }
                } else {
                    ImportMenuItem.this.frame.addTab(this.bibtexResult.getDatabase(), this.bibtexResult.getFile(), this.bibtexResult.getMetaData(), Globals.prefs.get("defaultEncoding"), true);
                    this.done(this.bibtexResult.getDatabase().getEntryCount());
                }
            } else if (ImportMenuItem.this.importer == null) {
                ImportMenuItem.this.frame.output(Globals.lang("Could not find a suitable import format."));
            } else {
                JOptionPane.showMessageDialog(ImportMenuItem.this.frame, Globals.lang("No entries found. Please make sure you are using the correct import filter."), Globals.lang("Import failed"), 0);
            }
            ImportMenuItem.this.frame.unblock();
        }

        public void done(int n) {
            BasePanel basePanel = (BasePanel)ImportMenuItem.this.frame.getTabbedPane().getSelectedComponent();
            BibtexDatabase bibtexDatabase = basePanel.database();
            if (ImportMenuItem.this.worker != null && ImportMenuItem.this.worker.bibtexResult != null) {
                ImportMenuItem.this.frame.output(Globals.lang("Imported entries") + ": " + n);
            }
        }

        public void cancelled() {
            ImportMenuItem.this.frame.output(Globals.lang("Import cancelled."));
        }

        public void stopFetching() {
        }
    }
}

