/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.imports.BiblioscapeImporter;
import net.sf.jabref.imports.BibteXMLImporter;
import net.sf.jabref.imports.BiomailImporter;
import net.sf.jabref.imports.CsaImporter;
import net.sf.jabref.imports.CustomImportList;
import net.sf.jabref.imports.EndnoteImporter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.InspecImporter;
import net.sf.jabref.imports.IsiImporter;
import net.sf.jabref.imports.JstorImporter;
import net.sf.jabref.imports.MedlineImporter;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.OvidImporter;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.RepecNepImporter;
import net.sf.jabref.imports.RisImporter;
import net.sf.jabref.imports.ScifinderImporter;
import net.sf.jabref.imports.SilverPlatterImporter;
import net.sf.jabref.imports.SixpackImporter;

public class ImportFormatReader {
    public static String BIBTEX_FORMAT = "BibTeX";
    private static final String SPACE_MARKER = "__SPC__";
    private static final Pattern bracketsPattern = Pattern.compile("\\{.*\\}");
    private static final Pattern spaceMarkerPattern = Pattern.compile("__SPC__");
    private SortedSet formats = new TreeSet();

    public void resetImportFormats() {
        this.formats.clear();
        this.formats.add(new CsaImporter());
        this.formats.add(new IsiImporter());
        this.formats.add(new EndnoteImporter());
        this.formats.add(new MedlineImporter());
        this.formats.add(new BibteXMLImporter());
        this.formats.add(new BiblioscapeImporter());
        this.formats.add(new SixpackImporter());
        this.formats.add(new InspecImporter());
        this.formats.add(new ScifinderImporter());
        this.formats.add(new OvidImporter());
        this.formats.add(new RisImporter());
        this.formats.add(new JstorImporter());
        this.formats.add(new SilverPlatterImporter());
        this.formats.add(new BiomailImporter());
        this.formats.add(new RepecNepImporter());
        Iterator iterator = Globals.prefs.customImports.iterator();
        while (iterator.hasNext()) {
            CustomImportList.Importer importer = (CustomImportList.Importer)iterator.next();
            try {
                ImportFormat importFormat = importer.getInstance();
                this.formats.add(importFormat);
            }
            catch (Exception exception) {
                System.err.println("Could not instantiate " + importer.getName() + " importer, will ignore it. Please check if the class is still available.");
                exception.printStackTrace();
            }
        }
    }

    public ImportFormat getByCliId(String string) {
        ImportFormat importFormat = null;
        Iterator iterator = this.formats.iterator();
        while (iterator.hasNext() && importFormat == null) {
            ImportFormat importFormat2 = (ImportFormat)iterator.next();
            if (!importFormat2.getCLIId().equals(string)) continue;
            importFormat = importFormat2;
        }
        return importFormat;
    }

    public List importFromStream(String string, InputStream inputStream) throws IOException {
        ImportFormat importFormat = this.getByCliId(string);
        if (importFormat == null) {
            throw new IllegalArgumentException("Unknown import format: " + string);
        }
        List list = importFormat.importEntries(inputStream);
        if (list != null) {
            ImportFormatReader.purgeEmptyEntries(list);
        }
        return list;
    }

    public List importFromFile(String string, String string2) throws IOException {
        ImportFormat importFormat = this.getByCliId(string);
        if (importFormat == null) {
            throw new IllegalArgumentException("Unknown import format: " + string);
        }
        return this.importFromFile(importFormat, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List importFromFile(ImportFormat importFormat, String string) throws IOException {
        List list = null;
        InputStream inputStream = null;
        try {
            File file = new File(string);
            inputStream = new FileInputStream(file);
            if (!importFormat.isRecognizedFormat(inputStream)) {
                throw new IOException(Globals.lang("Wrong file format"));
            }
            inputStream = new FileInputStream(file);
            list = importFormat.importEntries(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return list;
    }

    public static BibtexDatabase createDatabase(List list) {
        ImportFormatReader.purgeEmptyEntries(list);
        BibtexDatabase bibtexDatabase = new BibtexDatabase();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
            try {
                bibtexEntry.setId(Util.createNeutralId());
                bibtexDatabase.insertEntry(bibtexEntry);
            }
            catch (KeyCollisionException keyCollisionException) {
                System.err.println("KeyCollisionException [ addBibEntries(...) ]");
            }
        }
        return bibtexDatabase;
    }

    public SortedSet getCustomImportFormats() {
        TreeSet<ImportFormat> treeSet = new TreeSet<ImportFormat>();
        Iterator iterator = this.formats.iterator();
        while (iterator.hasNext()) {
            ImportFormat importFormat = (ImportFormat)iterator.next();
            if (!importFormat.getIsCustomImporter()) continue;
            treeSet.add(importFormat);
        }
        return treeSet;
    }

    public SortedSet getBuiltInInputFormats() {
        TreeSet<ImportFormat> treeSet = new TreeSet<ImportFormat>();
        Iterator iterator = this.formats.iterator();
        while (iterator.hasNext()) {
            ImportFormat importFormat = (ImportFormat)iterator.next();
            if (importFormat.getIsCustomImporter()) continue;
            treeSet.add(importFormat);
        }
        return treeSet;
    }

    public SortedSet getImportFormats() {
        return this.formats;
    }

    public String getImportFormatList() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.formats.iterator();
        while (object.hasNext()) {
            ImportFormat importFormat = (ImportFormat)object.next();
            int n = Math.max(0, 14 - importFormat.getFormatName().length());
            stringBuffer.append("  ");
            stringBuffer.append(importFormat.getFormatName());
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(" : ");
            stringBuffer.append(importFormat.getCLIId());
            stringBuffer.append("\n");
        }
        object = stringBuffer.toString();
        return object;
    }

    public static String expandAuthorInitials(String string) {
        String[] stringArray = string.split(" and ");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String[] stringArray2;
            if (stringArray[i].indexOf(", ") >= 0) {
                stringArray2 = stringArray[i].split(", ");
                if (stringArray2.length > 0) {
                    stringBuffer.append(stringArray2[0]);
                    if (stringArray2.length > 1) {
                        stringBuffer.append(", ");
                    }
                }
                for (n = 1; n < stringArray2.length; ++n) {
                    stringBuffer.append(ImportFormatReader.expandAll(stringArray2[n]));
                }
            } else {
                stringArray2 = stringArray[i].split(" ");
                if (stringArray2.length > 0) {
                    stringBuffer.append(ImportFormatReader.expandAll(stringArray2[0]));
                }
                for (n = 1; n < stringArray2.length; ++n) {
                    stringBuffer.append(" ");
                    stringBuffer.append(stringArray2[n]);
                }
            }
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(" and ");
        }
        return stringBuffer.toString().trim();
    }

    public static String expandAll(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.length() == 1 && Character.isLetter(string.charAt(0)) && Character.isUpperCase(string.charAt(0))) {
            return string + ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = string.charAt(0);
        char c2 = '\u0000';
        for (int i = 1; i < string.length(); ++i) {
            c2 = string.charAt(i);
            if (Character.isLetter(c) && Character.isUpperCase(c) && Character.isLetter(c2) && Character.isUpperCase(c2)) {
                stringBuffer.append(c);
                stringBuffer.append(". ");
            } else {
                stringBuffer.append(c);
            }
            c = c2;
        }
        if (Character.isLetter(c) && Character.isUpperCase(c) && Character.isLetter(c2) && Character.isUpperCase(c2)) {
            stringBuffer.append(c);
            stringBuffer.append(". ");
        } else {
            stringBuffer.append(c);
        }
        return stringBuffer.toString().trim();
    }

    static File checkAndCreateFile(String string) {
        File file = new File(string);
        if (!(file.exists() || file.canRead() || file.isFile())) {
            System.err.println("Error " + string + " is not a valid file and|or is not readable.");
            Globals.logger("Error " + string + " is not a valid file and|or is not readable.");
            return null;
        }
        return file;
    }

    public static void setIfNecessary(BibtexEntry bibtexEntry, String string, String string2) {
        if (!string2.equals("")) {
            bibtexEntry.setField(string, string2);
        }
    }

    public static Reader getReader(File file, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), string);
        return inputStreamReader;
    }

    public static Reader getReaderDefaultEncoding(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Globals.prefs.get("defaultEncoding"));
        return inputStreamReader;
    }

    public static BibtexDatabase import_File(String string, String string2) throws IOException {
        BibtexDatabase bibtexDatabase = null;
        List list = null;
        File file = new File(string2);
        if (!file.exists()) {
            throw new IOException(Globals.lang("File not found") + ": " + string2);
        }
        try {
            list = Globals.importFormatReader.importFromFile(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(Globals.lang("Could not resolve import format") + " '" + string + "'");
        }
        if (list == null) {
            throw new IOException(Globals.lang("Import failed"));
        }
        ImportFormatReader.purgeEmptyEntries(list);
        bibtexDatabase = new BibtexDatabase();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
            try {
                bibtexEntry.setId(Util.createNeutralId());
                bibtexDatabase.insertEntry(bibtexEntry);
            }
            catch (KeyCollisionException keyCollisionException) {
                System.err.println("KeyCollisionException [ addBibEntries(...) ]");
            }
        }
        return bibtexDatabase;
    }

    public static void purgeEmptyEntries(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
            Object[] objectArray = bibtexEntry.getAllFields();
            if (objectArray.length != 0) continue;
            iterator.remove();
        }
    }

    public Object[] importUnknownFormat(String string) {
        Object object = null;
        String string2 = null;
        int n = 0;
        Object object2 = this.getImportFormats().iterator();
        while (object2.hasNext()) {
            ImportFormat importFormat = (ImportFormat)object2.next();
            try {
                int n2;
                List list = this.importFromFile(importFormat, string);
                if (list != null) {
                    ImportFormatReader.purgeEmptyEntries(list);
                }
                if ((n2 = list != null ? list.size() : 0) <= n) continue;
                n = n2;
                string2 = importFormat.getFormatName();
                object = list;
            }
            catch (IOException iOException) {}
        }
        if (object == null) {
            try {
                object2 = OpenDatabaseAction.loadDatabase(new File(string), Globals.prefs.get("defaultEncoding"));
                if (((ParserResult)object2).getDatabase().getEntryCount() > 0 || ((ParserResult)object2).getDatabase().getStringCount() > 0) {
                    object = object2;
                    ((ParserResult)object2).setFile(new File(string));
                    string2 = BIBTEX_FORMAT;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new Object[]{string2, object};
    }
}

