/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.HTMLConverter;

public class IEEEXploreFetcher
implements Runnable,
EntryFetcher {
    ImportInspectionDialog dialog = null;
    JabRefFrame frame = null;
    HTMLConverter htmlConverter = new HTMLConverter();
    private String terms;
    String startUrl = "http://ieeexplore.ieee.org";
    String searchUrlPart = "/search/freesearchresult.jsp?queryText=";
    String endUrl = "+%3Cin%3E+metadata&ResultCount=25&ResultStart=";
    private int perPage = 25;
    private int hits = 0;
    private int unparseable = 0;
    private int parsed = 0;
    private boolean shouldContinue = false;
    private JCheckBox fetchAstracts = new JCheckBox(Globals.lang("Include abstracts"), false);
    private boolean fetchingAbstracts = false;
    private static final int MAX_ABSTRACT_FETCH = 5;
    Pattern hitsPattern = Pattern.compile(".*Your search matched <strong>(\\d+)</strong>.*");
    Pattern maxHitsPattern = Pattern.compile(".*A maximum of <strong>(\\d+)</strong>.*");
    Pattern entryPattern1 = Pattern.compile(".*<strong>(.+)</strong><br>\\s+(.+)<br>\\s+<A href='(.+)'>(.+)</A><br>\\s+Volume (.+),&nbsp;\\s*(.+)? (\\d\\d\\d\\d)\\s+Page\\(s\\):.*");
    Pattern entryPattern2 = Pattern.compile(".*<strong>(.+)</strong><br>\\s+(.+)<br>\\s+<A href='(.+)'>(.+)</A><br>\\s+Volume (.+),&nbsp;\\s+Issue (\\d+),&nbsp;\\s*(.+)? (\\d\\d\\d\\d)\\s+Page\\(s\\):.*");
    Pattern entryPattern3 = Pattern.compile(".*<strong>(.+)</strong><br>\\s+(.+)<br>\\s+<A href='(.+)'>(.+)</A><br>\\s+Volume (.+),&nbsp;\\s+Issue (\\d+),&nbsp;\\s+Part (\\d+),&nbsp;\\s*(.+)? (\\d\\d\\d\\d)\\s+Page\\(s\\):.*");
    Pattern entryPattern4 = Pattern.compile(".*<strong>(.+)</strong><br>\\s+(.+)<br>\\s+<A href='(.+)'>(.+)</A><br>\\s*(.+)? (\\d\\d\\d\\d)\\s+Page\\(s\\):.*");
    Pattern abstractLinkPattern = Pattern.compile("<a href=\"(.+)\" class=\"bodyCopySpaced\">Abstract</a>");
    int piv = 0;

    public JPanel getOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.fetchAstracts, "Center");
        return jPanel;
    }

    public void processQuery(String string, ImportInspectionDialog importInspectionDialog, JabRefFrame jabRefFrame) {
        this.dialog = importInspectionDialog;
        this.frame = jabRefFrame;
        this.terms = string;
        this.piv = 0;
        new Thread(this).start();
    }

    public String getTitle() {
        return Globals.menuTitle("Search IEEEXplore");
    }

    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    public String getHelpPage() {
        return "IEEEXploreHelp.html";
    }

    public String getKeyName() {
        return "Search IEEXplore";
    }

    public void cancelled() {
        this.shouldContinue = false;
    }

    public void done(int n) {
    }

    public void stopFetching() {
        this.shouldContinue = false;
    }

    public void run() {
        this.frame.block();
        this.shouldContinue = true;
        this.parsed = 0;
        this.unparseable = 0;
        String string = this.makeUrl(0);
        try {
            URL uRL = new URL(string);
            String string2 = this.getResults(uRL);
            this.hits = this.getNumberOfHits(string2, "Your search matched", this.hitsPattern);
            this.frame.unblock();
            if (this.hits == 0) {
                this.dialog.dispose();
                JOptionPane.showMessageDialog(this.frame, Globals.lang("No entries found for the search string '%0'", this.terms), Globals.lang("Search IEEEXplore"), 1);
                return;
            }
            this.fetchingAbstracts = this.fetchAstracts.isSelected();
            if (this.fetchingAbstracts && this.hits > 5) {
                this.fetchingAbstracts = false;
                JOptionPane.showMessageDialog(this.frame, Globals.lang("%0 entries found. To reduce server load, abstracts will only be downloaded for searches returning %1 hits or less.", new String[]{String.valueOf(this.hits), String.valueOf(5)}), Globals.lang("Search IEEEXplore"), 1);
            }
            this.dialog.setVisible(true);
            int n = this.getNumberOfHits(string2, "A maximum of", this.maxHitsPattern);
            if (this.hits > n) {
                this.hits = n;
            }
            this.parse(this.dialog, string2, 0, 1);
            for (int i = this.perPage; this.shouldContinue && i < this.hits; i += this.perPage) {
                string = this.makeUrl(i);
                string2 = this.getResults(new URL(string));
                if (!this.shouldContinue) break;
                this.parse(this.dialog, string2, 0, 1 + i);
            }
            this.dialog.entryListComplete();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String makeUrl(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.startUrl).append(this.searchUrlPart);
        stringBuffer.append(this.terms.replaceAll(" ", "+"));
        stringBuffer.append(this.endUrl);
        stringBuffer.append(String.valueOf(n));
        return stringBuffer.toString();
    }

    private void parse(ImportInspectionDialog importInspectionDialog, String string, int n, int n2) {
        BibtexEntry bibtexEntry;
        this.piv = n;
        int n3 = n2;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        while ((bibtexEntry = this.parseNextEntry(string, this.piv, n3)) != null && this.shouldContinue) {
            if (bibtexEntry.getField("title") != null) {
                arrayList.add(bibtexEntry);
                importInspectionDialog.addEntries(arrayList);
                importInspectionDialog.setProgress(this.parsed + this.unparseable, this.hits);
                arrayList.clear();
                ++this.parsed;
            }
            ++n3;
        }
    }

    private BibtexEntry parseNextEntry(String string, int n, int n2) {
        String string2 = "<div align=\"left\"><strong>" + n2 + ".</strong></div>";
        int n3 = string.indexOf(string2, n);
        int n4 = string.indexOf("</table>", n3 + 1);
        if (n4 < 0) {
            n4 = string.length();
        }
        if (n3 >= 0) {
            Matcher matcher;
            String string3;
            String string4;
            BibtexEntryType bibtexEntryType;
            this.piv = n3 + 1;
            String string5 = string.substring(n3, n4);
            if (string5.indexOf("IEEE JNL") >= 0) {
                bibtexEntryType = BibtexEntryType.getType("article");
                string4 = "journal";
            } else {
                bibtexEntryType = BibtexEntryType.getType("inproceedings");
                string4 = "booktitle";
            }
            n3 = 0;
            BibtexEntry bibtexEntry = new BibtexEntry(Util.createNeutralId(), bibtexEntryType);
            Matcher matcher2 = this.entryPattern1.matcher(string5);
            Matcher matcher3 = this.entryPattern2.matcher(string5);
            Matcher matcher4 = this.entryPattern3.matcher(string5);
            Matcher matcher5 = this.entryPattern4.matcher(string5);
            String string6 = "";
            if (matcher2.find()) {
                Matcher matcher6 = matcher2;
                bibtexEntry.setField("title", this.convertHTMLChars(matcher6.group(1)));
                string3 = this.convertHTMLChars(matcher6.group(2));
                if (string3.charAt(string3.length() - 1) == ';') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                bibtexEntry.setField("author", string3.replaceAll("; ", " and "));
                string3 = matcher6.group(4);
                bibtexEntry.setField(string4, this.convertHTMLChars(string3));
                bibtexEntry.setField("volume", this.convertHTMLChars(matcher6.group(5)));
                bibtexEntry.setField("month", this.convertHTMLChars(matcher6.group(6)));
                bibtexEntry.setField("year", matcher6.group(7));
            } else if (matcher3.find()) {
                Matcher matcher7 = matcher3;
                bibtexEntry.setField("title", this.convertHTMLChars(matcher7.group(1)));
                string3 = this.convertHTMLChars(matcher7.group(2));
                if (string3.charAt(string3.length() - 1) == ';') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                bibtexEntry.setField("author", string3.replaceAll("; ", " and "));
                string3 = matcher7.group(4);
                bibtexEntry.setField(string4, this.convertHTMLChars(string3));
                bibtexEntry.setField("volume", this.convertHTMLChars(matcher7.group(5)));
                bibtexEntry.setField("number", this.convertHTMLChars(matcher7.group(6)));
                bibtexEntry.setField("month", this.convertHTMLChars(matcher7.group(7)));
                bibtexEntry.setField("year", matcher7.group(8));
            } else if (matcher4.find()) {
                Matcher matcher8 = matcher4;
                bibtexEntry.setField("title", this.convertHTMLChars(matcher8.group(1)));
                string3 = this.convertHTMLChars(matcher8.group(2));
                if (string3.charAt(string3.length() - 1) == ';') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                bibtexEntry.setField("author", string3.replaceAll("; ", " and "));
                string3 = matcher8.group(4);
                bibtexEntry.setField(string4, this.convertHTMLChars(string3));
                bibtexEntry.setField("volume", this.convertHTMLChars(matcher8.group(5)));
                bibtexEntry.setField("number", this.convertHTMLChars(matcher8.group(6)));
                bibtexEntry.setField("month", this.convertHTMLChars(matcher8.group(8)));
                bibtexEntry.setField("year", matcher8.group(9));
            } else if (matcher5.find()) {
                Matcher matcher9 = matcher5;
                bibtexEntry.setField("title", this.convertHTMLChars(matcher9.group(1)));
                string3 = this.convertHTMLChars(matcher9.group(2));
                if (string3.charAt(string3.length() - 1) == ';') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                bibtexEntry.setField("author", string3.replaceAll("; ", " and "));
                string3 = matcher9.group(4);
                bibtexEntry.setField(string4, this.convertHTMLChars(string3));
                bibtexEntry.setField("month", this.convertHTMLChars(matcher9.group(5)));
                bibtexEntry.setField("year", matcher9.group(6));
            } else {
                System.err.println("---no structure match---");
                System.err.println(string5);
                ++this.unparseable;
            }
            int n5 = string5.indexOf("Page(s):");
            if (n5 >= 0) {
                int n6;
                string6 = string5.substring(n5 + 8);
                if ((n5 = string6.indexOf("<br>")) >= 0) {
                    string3 = string6.substring(0, n5);
                    bibtexEntry.setField("pages", string3.replaceAll("\\s+", "").replaceAll("-", "--"));
                }
                if ((n5 = string6.indexOf("Digital Object Identifier ", n5)) >= 0 && (n6 = string6.indexOf("<br>", n5)) >= 0) {
                    bibtexEntry.setField("doi", string6.substring(n5 + 26, n6).trim());
                }
            }
            if (this.fetchingAbstracts && (matcher = this.abstractLinkPattern.matcher(string5)).find()) {
                StringBuffer stringBuffer = new StringBuffer(this.startUrl).append(matcher.group(1));
                try {
                    String string7 = this.fetchAbstract(stringBuffer.toString());
                    if (string7 != null && string7.length() > 0 && !string7.equalsIgnoreCase("not available")) {
                        bibtexEntry.setField("abstract", this.convertHTMLChars(string7));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return bibtexEntry;
        }
        return null;
    }

    private String convertHTMLChars(String string) {
        return this.htmlConverter.format(string);
    }

    private int getNumberOfHits(String string, String string2, Pattern pattern) throws IOException {
        int n = string.indexOf(string2);
        if (n < 0) {
            throw new IOException(Globals.lang("Could not parse number of hits"));
        }
        String string3 = string.substring(n, Math.min(n + 42, string.length()));
        Matcher matcher = pattern.matcher(string3);
        if (!matcher.find()) {
            return 0;
        }
        if (matcher.groupCount() >= 1) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(Globals.lang("Could not parse number of hits"));
            }
        }
        throw new IOException(Globals.lang("Could not parse number of hits"));
    }

    public String getResults(URL uRL) throws IOException {
        int n;
        InputStream inputStream = uRL.openStream();
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[256];
        while ((n = inputStream.read(byArray)) != -1) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append((char)byArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public String getResultsFromFile(File file) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[256];
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append((char)byArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public String fetchAbstract(String string) throws IOException {
        URL uRL = new URL(string);
        String string2 = this.getResults(uRL);
        String string3 = "Abstract</span><br>";
        int n = string2.indexOf(string3);
        int n2 = string2.indexOf("</td>", n + 1);
        if (n >= 0 && n2 > n) {
            return new String(string2.substring(n + string3.length(), n2).trim());
        }
        return null;
    }
}

