/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.Util;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.imports.AuthorDialog;
import net.sf.jabref.imports.BooleanAssign;
import net.sf.jabref.imports.CiteSeerFetcher;
import net.sf.jabref.undo.NamedCompound;

public class CiteSeerFetcherPanel
extends SidePaneComponent
implements ActionListener {
    String idList;
    JTextField tf = new JTextField();
    JPanel pan = new JPanel();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    CiteSeerFetcher citeSeerFetcher;
    AuthorDialog authorDialog;
    JFrame jFrame;
    JButton go = new JButton(Globals.lang("Fetch"));
    JButton helpBut = new JButton(GUIGlobals.getImage("helpSmall"));
    HelpAction help;
    CiteSeerFetcherPanel ths = this;

    public CiteSeerFetcherPanel(SidePaneManager sidePaneManager, CiteSeerFetcher citeSeerFetcher) {
        super(sidePaneManager, GUIGlobals.getIconUrl("citeseer"), Globals.lang("Fetch CiteSeer"));
        this.help = new HelpAction(Globals.helpDiag, GUIGlobals.citeSeerHelp, "Help");
        this.citeSeerFetcher = citeSeerFetcher;
        this.helpBut.addActionListener(this.help);
        this.helpBut.setMargin(new Insets(0, 0, 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.insets = new Insets(0, 0, 2, 0);
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.weighty = 1.0;
        this.con.insets = new Insets(0, 0, 0, 0);
        this.con.fill = 1;
        this.gbl.setConstraints(this.tf, this.con);
        jPanel.add(this.tf);
        this.con.weighty = 0.0;
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.go, this.con);
        jPanel.add(this.go);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.helpBut, this.con);
        jPanel.add(this.helpBut);
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)jPanel, "Center");
        this.go.addActionListener(this);
        this.tf.addActionListener(this);
    }

    public JTextField getTextField() {
        return this.tf;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.citeSeerFetcher.activateImportFetcher()) {
            new Thread(){
                BibtexEntry entry;

                public void run() {
                    ImportInspectionDialog importInspectionDialog = null;
                    if (Globals.prefs.getBoolean("useImportInspectionDialog")) {
                        importInspectionDialog = new ImportInspectionDialog(CiteSeerFetcherPanel.this.panel.frame(), CiteSeerFetcherPanel.this.panel, BibtexFields.DEFAULT_INSPECTION_FIELDS, Globals.lang("Fetch CiteSeer"), false);
                        importInspectionDialog.addCallBack(new Update());
                        Util.placeDialog(importInspectionDialog, CiteSeerFetcherPanel.this.panel.frame());
                        importInspectionDialog.setVisible(true);
                        importInspectionDialog.setProgress(0, 1);
                    }
                    NamedCompound namedCompound = new NamedCompound(Globals.lang("CiteSeer import entries"));
                    NamedCompound namedCompound2 = new NamedCompound(Globals.lang("Ok"));
                    BooleanAssign booleanAssign = new BooleanAssign(true);
                    BooleanAssign booleanAssign2 = new BooleanAssign(false);
                    BooleanAssign booleanAssign3 = new BooleanAssign(false);
                    Hashtable hashtable = new Hashtable();
                    String string = CiteSeerFetcherPanel.this.tf.getText().replaceAll(",", ";");
                    String[] stringArray = string.split(";");
                    BibtexEntry[] bibtexEntryArray = new BibtexEntry[stringArray.length];
                    CiteSeerFetcherPanel.this.citeSeerFetcher.activateImportFetcher();
                    for (int i = 0; i < bibtexEntryArray.length; ++i) {
                        bibtexEntryArray[i] = new BibtexEntry(Util.createNeutralId(), BibtexEntryType.getType("article"));
                        bibtexEntryArray[i].setField("citeseerurl", stringArray[i].trim());
                        boolean bl = CiteSeerFetcherPanel.this.citeSeerFetcher.importCiteSeerEntry(bibtexEntryArray[i], namedCompound2, booleanAssign, booleanAssign2, booleanAssign3, hashtable);
                        if (importInspectionDialog == null) continue;
                        importInspectionDialog.addEntry(bibtexEntryArray[i]);
                        importInspectionDialog.setProgress(i + 1, bibtexEntryArray.length);
                    }
                    CiteSeerFetcherPanel.this.citeSeerFetcher.deactivateImportFetcher();
                    if (importInspectionDialog != null) {
                        importInspectionDialog.entryListComplete();
                    } else {
                        CiteSeerFetcherPanel.this.panel.frame().addBibEntries(Arrays.asList(bibtexEntryArray), null, false);
                        new Update().done(bibtexEntryArray.length);
                    }
                }

                class Update
                implements ImportInspectionDialog.CallBack {
                    Update() {
                    }

                    public void done(int n) {
                        if (n > 0) {
                            CiteSeerFetcherPanel.this.panel.output(Globals.lang("Completed import from CiteSeer."));
                        } else {
                            CiteSeerFetcherPanel.this.panel.output(Globals.lang("No entries imported."));
                        }
                    }

                    public void cancelled() {
                        CiteSeerFetcherPanel.this.panel.output(Globals.lang("%0 import cancelled.", "CiteSeer"));
                    }

                    public void stopFetching() {
                    }
                }
            }.start();
        } else {
            JOptionPane.showMessageDialog(this.panel.frame(), Globals.lang("A CiteSeer import operation is currently in progress.") + "  " + Globals.lang("Please wait until it has finished."), Globals.lang("CiteSeer Import Error"), 2);
        }
    }
}

