/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class BiomailImporter
extends ImportFormat {
    public String getFormatName() {
        return "Biomail";
    }

    public String getCLIId() {
        return "biomail";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("BioMail");
        while ((string = bufferedReader.readLine()) != null) {
            if (!pattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        Object object;
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() < 3) continue;
            if (string.substring(0, 6).equals("PMID- ")) {
                stringBuffer.append("::").append(string);
                continue;
            }
            object = string.substring(0, 6);
            if (((String)object).indexOf(" ") > 0) {
                stringBuffer.append(" ## ");
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append("EOLEOL");
            stringBuffer.append(string.trim());
        }
        object = stringBuffer.toString().split("::");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < ((String[])object).length; ++i) {
            String[] stringArray = object[i].split(" ## ");
            if (stringArray.length == 0) {
                stringArray = ((String)object[i]).split("\n");
            }
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            hashMap.clear();
            for (int j = 0; j < stringArray.length; ++j) {
                String[] stringArray2;
                System.out.println(">>>" + stringArray[j] + "<<<");
                if (stringArray[j].length() <= 2) continue;
                String string7 = stringArray[j].substring(0, 6);
                String string8 = stringArray[j].substring(6);
                string8 = string8.trim();
                if (string7.equals("PT  - ")) {
                    string3 = string8.replaceAll("JOURNAL ARTICLE", "article").replaceAll("Journal Article", "article");
                    string2 = "article";
                    continue;
                }
                if (string7.equals("TY  - ")) {
                    if (!"CONF".equals(string8)) continue;
                    string2 = "inproceedings";
                    continue;
                }
                if (string7.equals("JO  - ")) {
                    hashMap.put("booktitle", string8);
                    continue;
                }
                if (string7.equals("FAU - ")) {
                    stringArray2 = string8.replaceAll("EOLEOL", " and ");
                    if (!"".equals(string6)) {
                        string6 = string6 + " and " + (String)stringArray2;
                        continue;
                    }
                    string6 = stringArray2;
                    continue;
                }
                if (string7.equals("AU  - ")) {
                    stringArray2 = string8.replaceAll("EOLEOL", " and ").replaceAll(" ", ", ");
                    if (!"".equals(string5)) {
                        string5 = string5 + " and " + (String)stringArray2;
                        continue;
                    }
                    string5 = stringArray2;
                    continue;
                }
                if (string7.equals("TI  - ")) {
                    hashMap.put("title", string8.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (string7.equals("TA  - ")) {
                    hashMap.put("journal", string8.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (string7.equals("AB  - ")) {
                    hashMap.put("abstract", string8.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (string7.equals("PG  - ")) {
                    string4 = string8.replaceAll("-", "--");
                    continue;
                }
                if (string7.equals("IP  - ")) {
                    hashMap.put("number", string8);
                    continue;
                }
                if (string7.equals("DP  - ")) {
                    stringArray2 = string8.split(" ");
                    hashMap.put("year", stringArray2[0]);
                    continue;
                }
                if (string7.equals("VI  - ")) {
                    hashMap.put("volume", string8);
                    continue;
                }
                if (!string7.equals("AID - ") || !"[doi]".equals((stringArray2 = string8.split(" "))[1])) continue;
                hashMap.put("doi", stringArray2[0]);
                hashMap.put("url", "http://dx.doi.org/" + stringArray2[0]);
            }
            if (!"".equals(string4)) {
                hashMap.put("pages", string4);
            }
            if (!"".equals(string6)) {
                hashMap.put("author", string6);
            } else if (!"".equals(string5)) {
                hashMap.put("author", string5);
            }
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string2));
            bibtexEntry.setField(hashMap);
            if (hashMap.get("author") == null && hashMap.get("title") == null) continue;
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }
}

