/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexString;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.UnknownEntryType;
import net.sf.jabref.Util;
import net.sf.jabref.imports.FieldContentParser;
import net.sf.jabref.imports.ParserResult;

public class BibtexParser {
    private PushbackReader _in;
    private BibtexDatabase _db;
    private HashMap _meta;
    private HashMap entryTypes;
    private boolean _eof = false;
    private int line = 1;
    private FieldContentParser fieldContentParser = new FieldContentParser();

    public BibtexParser(Reader reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        this._in = new PushbackReader(reader);
    }

    public static boolean isRecognizedFormat(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        Pattern pattern = Pattern.compile("@[a-zA-Z]*\\s*\\{");
        while ((string = bufferedReader.readLine()) != null) {
            if (pattern.matcher(string).find()) {
                return true;
            }
            if (!string.startsWith("This file was created with JabRef")) continue;
            return true;
        }
        return false;
    }

    private void skipWhitespace() throws IOException {
        int n;
        do {
            if ((n = this.read()) != -1 && n != 65535) continue;
            this._eof = true;
            return;
        } while (Character.isWhitespace((char)n));
        this.unread(n);
    }

    private String skipAndRecordWhitespace(int n) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (n != 32) {
            stringBuffer.append((char)n);
        }
        while (true) {
            if ((n2 = this.read()) == -1 || n2 == 65535) {
                this._eof = true;
                return stringBuffer.toString();
            }
            if (!Character.isWhitespace((char)n2)) break;
            if (n2 == 32) continue;
            stringBuffer.append((char)n2);
        }
        this.unread(n2);
        return stringBuffer.toString();
    }

    public ParserResult parse() throws IOException {
        this._db = new BibtexDatabase();
        this._meta = new HashMap();
        this.entryTypes = new HashMap();
        ParserResult parserResult = new ParserResult(this._db, this._meta, this.entryTypes);
        this.skipWhitespace();
        try {
            boolean bl;
            while (!this._eof && (bl = this.consumeUncritically('@'))) {
                Object object;
                boolean bl2;
                this.skipWhitespace();
                String string = this.parseTextToken();
                BibtexEntryType bibtexEntryType = BibtexEntryType.getType(string);
                boolean bl3 = bl2 = bibtexEntryType != null;
                if (!bl2) {
                    if (string.toLowerCase().equals("preamble")) {
                        this._db.setPreamble(this.parsePreamble());
                    } else if (string.toLowerCase().equals("string")) {
                        object = this.parseString();
                        try {
                            this._db.addString((BibtexString)object);
                        }
                        catch (KeyCollisionException keyCollisionException) {
                            parserResult.addWarning(Globals.lang("Duplicate string name") + ": " + ((BibtexString)object).getName());
                        }
                    } else if (string.toLowerCase().equals("comment")) {
                        Object object2;
                        int n;
                        object = this.parseBracketedTextExactly();
                        String string2 = ((StringBuffer)object).toString().replaceAll("[\\x0d\\x0a]", "");
                        if ((string2.substring(0, Math.min(string2.length(), GUIGlobals.META_FLAG.length())).equals(GUIGlobals.META_FLAG) || string2.substring(0, Math.min(string2.length(), GUIGlobals.META_FLAG_OLD.length())).equals(GUIGlobals.META_FLAG_OLD)) && (n = ((String)(object2 = string2.substring(0, GUIGlobals.META_FLAG.length()).equals(GUIGlobals.META_FLAG) ? string2.substring(GUIGlobals.META_FLAG.length()) : string2.substring(GUIGlobals.META_FLAG_OLD.length()))).indexOf(58)) > 0) {
                            this._meta.put(((String)object2).substring(0, n), ((String)object2).substring(n + 1));
                        }
                        if (string2.substring(0, Math.min(string2.length(), GUIGlobals.ENTRYTYPE_FLAG.length())).equals(GUIGlobals.ENTRYTYPE_FLAG)) {
                            object2 = CustomEntryType.parseEntryType(string2);
                            this.entryTypes.put(((CustomEntryType)object2).getName().toLowerCase(), object2);
                        }
                    } else {
                        bibtexEntryType = new UnknownEntryType(string.toLowerCase());
                        bl2 = true;
                    }
                }
                if (bl2) {
                    object = this.parseEntry(bibtexEntryType);
                    boolean bl4 = this._db.insertEntry((BibtexEntry)object);
                    if (bl4) {
                        parserResult.addWarning(Globals.lang("duplicate BibTeX key") + ": " + ((BibtexEntry)object).getCiteKey() + " (" + Globals.lang("grouping may not work for this entry") + ")");
                    } else if (((BibtexEntry)object).getCiteKey() == null || ((BibtexEntry)object).getCiteKey().equals("")) {
                        parserResult.addWarning(Globals.lang("empty BibTeX key") + ": " + ((BibtexEntry)object).getAuthorTitleYear(40) + " (" + Globals.lang("grouping may not work for this entry") + ")");
                    }
                }
                this.skipWhitespace();
            }
            this.checkEntryTypes(parserResult);
            return parserResult;
        }
        catch (KeyCollisionException keyCollisionException) {
            throw new IOException("Duplicate ID in bibtex file: " + keyCollisionException.toString());
        }
    }

    private int peek() throws IOException {
        int n = this.read();
        this.unread(n);
        return n;
    }

    private int read() throws IOException {
        int n = this._in.read();
        if (n == 10) {
            ++this.line;
        }
        return n;
    }

    private void unread(int n) throws IOException {
        if (n == 10) {
            --this.line;
        }
        this._in.unread(n);
    }

    public BibtexString parseString() throws IOException {
        this.skipWhitespace();
        this.consume('{', '(');
        this.skipWhitespace();
        String string = this.parseTextToken();
        this.skipWhitespace();
        this.consume('=');
        String string2 = this.parseFieldContent();
        this.consume('}', ')');
        String string3 = Util.createNeutralId();
        return new BibtexString(string3, string, string2);
    }

    public String parsePreamble() throws IOException {
        return this.parseBracketedText().toString();
    }

    public BibtexEntry parseEntry(BibtexEntryType bibtexEntryType) throws IOException {
        int n;
        String string = Util.createNeutralId();
        BibtexEntry bibtexEntry = new BibtexEntry(string, bibtexEntryType);
        this.skipWhitespace();
        this.consume('{', '(');
        this.skipWhitespace();
        String string2 = null;
        boolean bl = true;
        while (bl) {
            bl = false;
            try {
                if (string2 != null) {
                    string2 = string2 + this.parseKey();
                    continue;
                }
                string2 = this.parseKey();
            }
            catch (NoLabelException noLabelException) {
                char c = (char)this.peek();
                if (Character.isWhitespace(c) || c == '{' || c == '\"') {
                    String string3 = noLabelException.getMessage().trim().toLowerCase();
                    String string4 = this.parseFieldContent();
                    bibtexEntry.setField(string3, string4);
                    continue;
                }
                string2 = string2 != null ? string2 + noLabelException.getMessage() + "=" : noLabelException.getMessage() + "=";
                bl = true;
            }
        }
        if (string2 != null && string2.equals("")) {
            string2 = null;
        }
        if (bibtexEntry != null) {
            bibtexEntry.setField("bibtexkey", string2);
        }
        this.skipWhitespace();
        while ((n = this.peek()) != 125 && n != 41) {
            if (n == 44) {
                this.consume(',');
            }
            this.skipWhitespace();
            n = this.peek();
            if (n == 125 || n == 41) break;
            this.parseField(bibtexEntry);
        }
        this.consume('}', ')');
        return bibtexEntry;
    }

    private void parseField(BibtexEntry bibtexEntry) throws IOException {
        String string = this.parseTextToken().toLowerCase();
        this.skipWhitespace();
        this.consume('=');
        String string2 = this.parseFieldContent();
        if (Globals.prefs.putBracesAroundCapitals(string)) {
            string2 = Util.removeBracesAroundCapitals(string2);
        }
        if (string2.length() > 0) {
            if (bibtexEntry.getField(string) == null) {
                bibtexEntry.setField(string, string2);
            } else if (string.equals("author") || string.equals("editor")) {
                bibtexEntry.setField(string, bibtexEntry.getField(string) + " and " + string2);
            }
        }
    }

    private String parseFieldContent() throws IOException {
        int n;
        this.skipWhitespace();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 46;
        while ((n = this.peek()) != 44 && n != 125 && n != 41) {
            CharSequence charSequence;
            if (this._eof) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (n == 34) {
                charSequence = this.parseQuotedFieldExactly();
                stringBuffer.append(this.fieldContentParser.format((StringBuffer)charSequence));
            } else if (n == 123) {
                charSequence = this.parseBracketedTextExactly();
                stringBuffer.append(this.fieldContentParser.format((StringBuffer)charSequence));
            } else if (Character.isDigit((char)n)) {
                charSequence = this.parseTextToken();
                int n3 = Integer.parseInt((String)charSequence);
                stringBuffer.append(new Integer(n3).toString());
            } else if (n == 35) {
                this.consume('#');
            } else {
                charSequence = this.parseTextToken();
                if (((String)charSequence).length() == 0) {
                    throw new IOException("Error in line " + this.line + " or above: " + "Empty text token.\nThis could be caused " + "by a missing comma between two fields.");
                }
                stringBuffer.append("#").append((String)charSequence).append("#");
            }
            this.skipWhitespace();
        }
        if (Globals.prefs.getBoolean("autoDoubleBraces")) {
            while (stringBuffer.length() > 1 && stringBuffer.charAt(0) == '{' && stringBuffer.charAt(stringBuffer.length() - 1) == '}') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer.deleteCharAt(0);
            }
            while (this.hasNegativeBraceCount(stringBuffer.toString())) {
                stringBuffer.insert(0, '{');
                stringBuffer.append('}');
            }
        }
        return stringBuffer.toString();
    }

    private boolean hasNegativeBraceCount(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '{') {
                ++n;
            } else if (string.charAt(i) == '}') {
                --n;
            }
            if (n >= 0) continue;
            return true;
        }
        return false;
    }

    private String parseTextToken() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(20);
        while (true) {
            if ((n = this.read()) == -1) {
                this._eof = true;
                return stringBuffer.toString();
            }
            if (!Character.isLetterOrDigit((char)n) && n != 58 && n != 45 && n != 95 && n != 42 && n != 43 && n != 46 && n != 47 && n != 39) break;
            stringBuffer.append((char)n);
        }
        this.unread(n);
        return stringBuffer.toString();
    }

    private String parseKey() throws IOException, NoLabelException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(20);
        while (true) {
            if ((n = this.read()) == -1) {
                this._eof = true;
                return stringBuffer.toString();
            }
            if (Character.isWhitespace((char)n) || !Character.isLetterOrDigit((char)n) && (n == 35 || n == 123 || n == 125 || n == 65533 || n == 126 || n == 65533 || n == 44 || n == 61)) break;
            stringBuffer.append((char)n);
        }
        if (Character.isWhitespace((char)n)) {
            return stringBuffer.toString();
        }
        if (n == 44) {
            this.unread(n);
            return stringBuffer.toString();
        }
        if (n == 61) {
            return stringBuffer.toString();
        }
        throw new IOException("Error in line " + this.line + ":" + "Character '" + (char)n + "' is not " + "allowed in bibtex keys.");
    }

    private StringBuffer parseBracketedText() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.consume('{');
        int n = 0;
        while (this.peek() != 125 || n != 0) {
            int n2 = this.read();
            if (n2 == -1 || n2 == 65535) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (n2 == 123) {
                ++n;
            } else if (n2 == 125) {
                --n;
            }
            if (Character.isWhitespace((char)n2)) {
                String string = this.skipAndRecordWhitespace(n2);
                if (!string.equals("") && !string.equals("\n\t")) {
                    string = string.replaceAll("\t", "");
                    stringBuffer.append(string);
                    continue;
                }
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append((char)n2);
        }
        this.consume('}');
        return stringBuffer;
    }

    private StringBuffer parseBracketedTextExactly() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.consume('{');
        int n = 0;
        while (this.peek() != 125 || n != 0) {
            int n2 = this.read();
            if (n2 == -1 || n2 == 65535) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (n2 == 123) {
                ++n;
            } else if (n2 == 125) {
                --n;
            }
            stringBuffer.append((char)n2);
        }
        this.consume('}');
        return stringBuffer;
    }

    private StringBuffer parseQuotedFieldExactly() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.consume('\"');
        int n = 0;
        while (this.peek() != 34 || n != 0) {
            int n2 = this.read();
            if (n2 == -1 || n2 == 65535) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (n2 == 123) {
                ++n;
            } else if (n2 == 125) {
                --n;
            }
            stringBuffer.append((char)n2);
        }
        this.consume('\"');
        return stringBuffer;
    }

    private void consume(char c) throws IOException {
        int n = this.read();
        if (n != c) {
            throw new RuntimeException("Error in line " + this.line + ": Expected " + c + " but received " + (char)n);
        }
    }

    private boolean consumeUncritically(char c) throws IOException {
        int n;
        while ((n = this.read()) != c && n != -1 && n != 65535) {
        }
        if (n == -1 || n == 65535) {
            this._eof = true;
        }
        return n == c;
    }

    private void consume(char c, char c2) throws IOException {
        int n = this.read();
        if (n != c && n != c2) {
            throw new RuntimeException("Error in line " + this.line + ": Expected " + c + " or " + c2 + " but received " + n);
        }
    }

    public void checkEntryTypes(ParserResult parserResult) {
        Iterator iterator = this._db.getKeySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            BibtexEntry bibtexEntry = this._db.getEntryById((String)e);
            if (!(bibtexEntry.getType() instanceof UnknownEntryType)) continue;
            Object v = this.entryTypes.get(bibtexEntry.getType().getName().toLowerCase());
            if (v != null) {
                BibtexEntryType bibtexEntryType = (BibtexEntryType)v;
                bibtexEntry.setType(bibtexEntryType);
                continue;
            }
            parserResult.addWarning(Globals.lang("unknown entry type") + ": " + bibtexEntry.getType().getName() + ". " + Globals.lang("Type set to 'other'") + ".");
            bibtexEntry.setType(BibtexEntryType.OTHER);
        }
    }

    private class NoLabelException
    extends Exception {
        public NoLabelException(String string) {
            super(string);
        }
    }
}

