/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jabref.imports.BibTeXMLHandler;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BibteXMLImporter
extends ImportFormat {
    public String getFormatName() {
        return "BibTeXML";
    }

    public String getCLIId() {
        return "bibtexml";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("<bibtex:file .*");
        while ((string = bufferedReader.readLine()) != null) {
            if (!pattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        ArrayList arrayList = new ArrayList();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            BibTeXMLHandler bibTeXMLHandler = new BibTeXMLHandler();
            sAXParser.parse(inputStream, (DefaultHandler)bibTeXMLHandler);
            arrayList = bibTeXMLHandler.getItems();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }
}

