/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.sf.jabref.BaseAction;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MergeDialog;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableInsertString;

public class AppendDatabaseAction
extends BaseAction {
    private JabRefFrame frame;
    private BasePanel panel;
    private List filesToOpen = new ArrayList();

    public AppendDatabaseAction(JabRefFrame jabRefFrame, BasePanel basePanel) {
        this.frame = jabRefFrame;
        this.panel = basePanel;
    }

    public void action() {
        this.filesToOpen.clear();
        final MergeDialog mergeDialog = new MergeDialog(this.frame, Globals.lang("Append database"), true);
        Util.placeDialog(mergeDialog, this.panel);
        mergeDialog.setVisible(true);
        if (mergeDialog.isOkPressed()) {
            String[] stringArray = Globals.getMultipleFiles(this.frame, new File(Globals.prefs.get("workingDirectory")), null, false);
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.filesToOpen.add(new File(stringArray[i]));
            }
            new Thread(){

                public void run() {
                    AppendDatabaseAction.this.openIt(mergeDialog.importEntries(), mergeDialog.importStrings(), mergeDialog.importGroups(), mergeDialog.importSelectorWords());
                }
            }.start();
        }
    }

    void openIt(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.filesToOpen.size() == 0) {
            return;
        }
        Iterator iterator = this.filesToOpen.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            try {
                Globals.prefs.put("workingDirectory", file.getPath());
                String string = Globals.prefs.get("defaultEncoding");
                ParserResult parserResult = OpenDatabaseAction.loadDatabase(file, string);
                AppendDatabaseAction.mergeFromBibtex(this.frame, this.panel, parserResult, bl, bl2, bl3, bl4);
                this.panel.output(Globals.lang("Imported from database") + " '" + file.getPath() + "'");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                JOptionPane.showMessageDialog(this.panel, throwable.getMessage(), "Open database", 0);
            }
        }
    }

    public static void mergeFromBibtex(JabRefFrame jabRefFrame, BasePanel basePanel, ParserResult parserResult, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws KeyCollisionException {
        Object object;
        Object object2;
        BibtexDatabase bibtexDatabase = parserResult.getDatabase();
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        ArrayList<BibtexEntry> arrayList2 = new ArrayList<BibtexEntry>();
        BibtexDatabase bibtexDatabase2 = basePanel.database();
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Append database"));
        MetaData metaData = new MetaData(parserResult.getMetaData(), parserResult.getDatabase());
        if (bl) {
            object2 = bibtexDatabase.getKeySet().iterator();
            while (object2.hasNext()) {
                BibtexEntry bibtexEntry = bibtexDatabase.getEntryById((String)object2.next());
                BibtexEntry bibtexEntry2 = (BibtexEntry)bibtexEntry.clone();
                bibtexEntry2.setId(Util.createNeutralId());
                bibtexDatabase2.insertEntry(bibtexEntry2);
                arrayList.add(bibtexEntry2);
                arrayList2.add(bibtexEntry);
                namedCompound.addEdit(new UndoableInsertEntry(bibtexDatabase2, bibtexEntry2, basePanel));
            }
        }
        if (bl2) {
            boolean bl5 = false;
            object = bibtexDatabase.getStringKeySet().iterator();
            while (object.hasNext()) {
                object2 = (BibtexString)bibtexDatabase.getString(object.next()).clone();
                if (bibtexDatabase2.hasStringLabel(((BibtexString)object2).getName())) continue;
                bibtexDatabase2.addString((BibtexString)object2);
                namedCompound.addEdit(new UndoableInsertString(basePanel, bibtexDatabase2, (BibtexString)object2));
            }
        }
        if (bl3 && (object2 = metaData.getGroups()) != null) {
            if (((GroupTreeNode)object2).getGroup() instanceof AllEntriesGroup) {
                ExplicitGroup explicitGroup = new ExplicitGroup("Imported", 0);
                ((GroupTreeNode)object2).setGroup(explicitGroup);
                for (int i = 0; i < arrayList.size(); ++i) {
                    explicitGroup.addEntry((BibtexEntry)arrayList.get(i));
                }
            }
            jabRefFrame.groupSelector.addGroups((GroupTreeNode)object2, namedCompound);
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)object2).preorderEnumeration();
            while (enumeration.hasMoreElements()) {
                GroupTreeNode groupTreeNode = (GroupTreeNode)enumeration.nextElement();
                if (!(groupTreeNode.getGroup() instanceof ExplicitGroup)) continue;
                object = (ExplicitGroup)groupTreeNode.getGroup();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    BibtexEntry bibtexEntry = (BibtexEntry)arrayList2.get(i);
                    if (!((ExplicitGroup)object).contains(bibtexEntry)) continue;
                    ((ExplicitGroup)object).removeEntry(bibtexEntry);
                    ((ExplicitGroup)object).addEntry((BibtexEntry)arrayList.get(i));
                }
            }
            jabRefFrame.groupSelector.revalidateGroups();
        }
        if (bl4) {
            object2 = metaData.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                if (!string.startsWith("selector_")) continue;
                basePanel.metaData().putData(string, metaData.getData(string));
            }
        }
        namedCompound.end();
        basePanel.undoManager.addEdit(namedCompound);
        basePanel.markBaseChanged();
    }
}

