/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.PreviewPrefsTab;
import net.sf.jabref.RightClickMenu;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFileMenuItem;
import net.sf.jabref.gui.MainTable;

public class MainTableSelectionListener
implements ListEventListener,
MouseListener {
    PreviewPanel[] previewPanel = null;
    int activePreview = 1;
    PreviewPanel preview;
    MainTable table;
    BasePanel panel;
    EventList tableRows;
    private boolean previewActive = Globals.prefs.getBoolean("previewEnabled");
    private boolean workingOnPreview = false;

    public MainTableSelectionListener(BasePanel basePanel, MainTable mainTable) {
        this.table = mainTable;
        this.panel = basePanel;
        this.tableRows = mainTable.getTableRows();
        this.instantiatePreviews();
        this.preview = this.previewPanel[this.activePreview];
    }

    private void instantiatePreviews() {
        this.previewPanel = new PreviewPanel[]{new PreviewPanel(this.panel.database(), this.panel.metaData(), Globals.prefs.get("preview0")), new PreviewPanel(this.panel.database(), this.panel.metaData(), Globals.prefs.get("preview1"))};
        BibtexEntry bibtexEntry = PreviewPrefsTab.getTestEntry();
        this.previewPanel[0].setEntry(bibtexEntry);
        this.previewPanel[1].setEntry(bibtexEntry);
    }

    public void updatePreviews() {
        try {
            this.previewPanel[0].readLayout(Globals.prefs.get("preview0"));
            this.previewPanel[1].readLayout(Globals.prefs.get("preview1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void listChanged(ListEvent listEvent) {
        EventList eventList = listEvent.getSourceList();
        Object var3_3 = null;
        while (listEvent.next()) {
            if (listEvent.getType() != 2) continue;
            if (var3_3 != null) {
                return;
            }
            if (listEvent.getIndex() >= eventList.size()) continue;
            var3_3 = eventList.get(listEvent.getIndex());
        }
        if (var3_3 != null) {
            BibtexEntry bibtexEntry = var3_3;
            int n = this.panel.getMode();
            if (n == 3 || n == 2) {
                EntryEditor entryEditor = this.panel.getCurrentEditor();
                EntryEditor entryEditor2 = this.panel.getEntryEditor(bibtexEntry);
                if (entryEditor2 != entryEditor || n != 2) {
                    this.panel.showEntryEditor(entryEditor2);
                }
            } else if (this.previewActive) {
                this.updatePreview(bibtexEntry, false);
            }
        }
    }

    private void updatePreview(final BibtexEntry bibtexEntry, final boolean bl) {
        if (this.workingOnPreview) {
            return;
        }
        final int n = this.panel.getMode();
        this.workingOnPreview = true;
        final Runnable runnable = new Runnable(){

            public void run() {
                if (bl || n == 0) {
                    MainTableSelectionListener.this.panel.showPreview(MainTableSelectionListener.this.preview);
                    MainTableSelectionListener.this.panel.adjustSplitter();
                }
                MainTableSelectionListener.this.workingOnPreview = false;
            }
        };
        Runnable runnable2 = new Runnable(){

            public void run() {
                MainTableSelectionListener.this.preview.setEntry(bibtexEntry);
                SwingUtilities.invokeLater(runnable);
            }
        };
        new Thread(runnable2).start();
    }

    public void editSignalled() {
        if (this.table.getSelected().size() == 1) {
            this.editSignalled((BibtexEntry)this.table.getSelected().get(0));
        }
    }

    public void editSignalled(BibtexEntry bibtexEntry) {
        int n = this.panel.getMode();
        EntryEditor entryEditor = this.panel.getEntryEditor(bibtexEntry);
        if (n != 2) {
            this.panel.showEntryEditor(entryEditor);
            this.panel.adjustSplitter();
        }
        new FocusRequester(entryEditor);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = this.table.columnAtPoint(mouseEvent.getPoint());
        int n2 = this.table.rowAtPoint(mouseEvent.getPoint());
        if (mouseEvent.isPopupTrigger()) {
            this.processPopupTrigger(mouseEvent, n2);
            return;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        String[] stringArray;
        int n = this.table.columnAtPoint(mouseEvent.getPoint());
        int n2 = this.table.rowAtPoint(mouseEvent.getPoint());
        if (mouseEvent.getClickCount() == 2) {
            stringArray = (BibtexEntry)this.tableRows.get(n2);
            this.editSignalled((BibtexEntry)stringArray);
        }
        stringArray = this.table.getIconTypeForColumn(n);
        if (mouseEvent.isPopupTrigger()) {
            if (stringArray == null) {
                this.processPopupTrigger(mouseEvent, n2);
            } else {
                this.showIconRightClickMenu(mouseEvent, n2, stringArray);
            }
            return;
        }
        if (stringArray != null) {
            Object object = this.table.getValueAt(n2, n);
            if (object == null) {
                return;
            }
            final BibtexEntry bibtexEntry = (BibtexEntry)this.tableRows.get(n2);
            int n3 = -1;
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (bibtexEntry.getField(stringArray[i]) == null) continue;
                n3 = i;
            }
            if (n3 == -1) {
                return;
            }
            final String string = stringArray[n3];
            new Thread(){

                public void run() {
                    MainTableSelectionListener.this.panel.output(Globals.lang("External viewer called") + ".");
                    Object object = bibtexEntry.getField(string);
                    if (stringArray == null) {
                        Globals.logger("Error: no link to " + string + ".");
                        return;
                    }
                    try {
                        Util.openExternalViewer(MainTableSelectionListener.this.panel.metaData(), (String)object, string);
                    }
                    catch (IOException iOException) {
                        MainTableSelectionListener.this.panel.output(Globals.lang("Error") + ": " + iOException.getMessage());
                    }
                }
            }.start();
        }
    }

    protected void processPopupTrigger(MouseEvent mouseEvent, int n) {
        int n2 = this.table.getSelectedRow();
        if (n2 == -1 || !this.table.isRowSelected(this.table.rowAtPoint(mouseEvent.getPoint()))) {
            this.table.setRowSelectionInterval(n, n);
        }
        RightClickMenu rightClickMenu = new RightClickMenu(this.panel, this.panel.metaData());
        rightClickMenu.show(this.table, mouseEvent.getX(), mouseEvent.getY());
    }

    private void showIconRightClickMenu(MouseEvent mouseEvent, int n, String[] stringArray) {
        BibtexEntry bibtexEntry = (BibtexEntry)this.tableRows.get(n);
        JPopupMenu jPopupMenu = new JPopupMenu();
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = bibtexEntry.getField(stringArray[i]);
            if (object == null) continue;
            jPopupMenu.add(new ExternalFileMenuItem((String)object, (String)object, GUIGlobals.getTableIcon(stringArray[i]).getIcon(), this.panel.metaData()));
            ++n2;
        }
        if (n2 == 0) {
            this.processPopupTrigger(mouseEvent, n);
            return;
        }
        jPopupMenu.show(this.table, mouseEvent.getX(), mouseEvent.getY());
    }

    public void entryEditorClosing(EntryEditor entryEditor) {
        this.preview.setEntry(entryEditor.getEntry());
        if (this.previewActive) {
            this.panel.showPreview(this.preview);
        } else {
            this.panel.hideBottomComponent();
        }
        this.panel.adjustSplitter();
        new FocusRequester(this.table);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setPreviewActive(boolean bl) {
        this.previewActive = bl;
        if (!this.previewActive) {
            this.panel.hideBottomComponent();
        } else if (this.table.getSelected().size() > 0) {
            this.updatePreview((BibtexEntry)this.table.getSelected().get(0), false);
        }
    }

    public void switchPreview() {
        this.activePreview = this.activePreview < this.previewPanel.length - 1 ? ++this.activePreview : 0;
        if (this.previewActive) {
            this.preview = this.previewPanel[this.activePreview];
            if (this.table.getSelected().size() > 0) {
                this.updatePreview((BibtexEntry)this.table.getSelected().get(0), true);
            }
        }
    }
}

