/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchRuleSet;
import net.sf.jabref.Util;

public class MainTableFormat
implements TableFormat {
    public static final String[] PDF = new String[]{"pdf", "ps"};
    public static final String[] URL_ = new String[]{"url", "doi"};
    public static final String[] CITESEER = new String[]{"citeseerurl"};
    BasePanel panel;
    String[] columns;
    public int padleft = -1;
    private HashMap iconCols = new HashMap();
    int[] nameCols = null;
    boolean namesAsIs;
    boolean abbr_names;
    boolean namesNatbib;
    boolean namesFf;
    boolean namesLf;
    boolean namesLastOnly;
    boolean showShort;

    public MainTableFormat(BasePanel basePanel) {
        this.panel = basePanel;
    }

    public int getColumnCount() {
        return this.padleft + this.columns.length;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return GUIGlobals.NUMBER_COL;
        }
        if (this.getIconTypeForColumn(n) != null) {
            return "";
        }
        String string = BibtexFields.getFieldDisplayName(this.columns[n - this.padleft]);
        if (string != null) {
            return string;
        }
        return Util.nCase(this.columns[n - this.padleft]);
    }

    public String[] getIconTypeForColumn(int n) {
        Object v = this.iconCols.get(new Integer(n));
        if (v != null) {
            return (String[])v;
        }
        return null;
    }

    public int getColumnIndex(String string) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].equalsIgnoreCase(string)) continue;
            return i + this.padleft;
        }
        return -1;
    }

    public Object getColumnValue(Object object, int n) {
        Object object2;
        BibtexEntry bibtexEntry = (BibtexEntry)object;
        String[] stringArray = this.getIconTypeForColumn(n);
        if (n == 0) {
            object2 = "#";
        } else if (stringArray != null) {
            int n2 = -1;
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (!this.hasField(bibtexEntry, stringArray[i])) continue;
                n2 = i;
            }
            if (n2 < 0) {
                return null;
            }
            object2 = GUIGlobals.getTableIcon(stringArray[n2]);
        } else if (this.columns[n - this.padleft].equals(GUIGlobals.TYPE_HEADER)) {
            object2 = bibtexEntry.getType().getName();
        } else {
            object2 = bibtexEntry.getField(this.columns[n - this.padleft]);
            for (int i = 0; i < this.nameCols.length; ++i) {
                if (n - this.padleft != this.nameCols[i]) continue;
                if (object2 == null) {
                    return null;
                }
                if (this.namesAsIs) {
                    return object2;
                }
                if (this.namesNatbib) {
                    object2 = AuthorList.fixAuthor_Natbib((String)object2);
                } else if (this.namesLastOnly) {
                    object2 = AuthorList.fixAuthor_lastNameOnlyCommas((String)object2);
                } else if (this.namesFf) {
                    object2 = AuthorList.fixAuthor_firstNameFirstCommas((String)object2, this.abbr_names);
                } else if (this.namesLf) {
                    object2 = AuthorList.fixAuthor_lastNameFirstCommas((String)object2, this.abbr_names);
                }
                return object2;
            }
        }
        return object2;
    }

    public boolean hasField(BibtexEntry bibtexEntry, String string) {
        return bibtexEntry != null && bibtexEntry.getField(string) != null;
    }

    public void updateTableFormat() {
        int n;
        this.columns = Globals.prefs.getStringArray("columnNames");
        this.showShort = Globals.prefs.getBoolean("showShort");
        this.namesNatbib = Globals.prefs.getBoolean("namesNatbib");
        this.namesLastOnly = Globals.prefs.getBoolean("namesLastOnly");
        this.namesAsIs = Globals.prefs.getBoolean("namesAsIs");
        this.abbr_names = Globals.prefs.getBoolean("abbrAuthorNames");
        this.namesFf = Globals.prefs.getBoolean("namesFf");
        this.namesLf = !this.namesAsIs && !this.namesFf && !this.namesNatbib && !this.namesLastOnly;
        this.iconCols.clear();
        int n2 = 1;
        if (Globals.prefs.getBoolean("pdfColumn")) {
            this.iconCols.put(new Integer(n2++), PDF);
        }
        if (Globals.prefs.getBoolean("urlColumn")) {
            this.iconCols.put(new Integer(n2++), URL_);
        }
        if (Globals.prefs.getBoolean("citeseerColumn")) {
            this.iconCols.put(new Integer(n2++), CITESEER);
        }
        this.padleft = 1 + this.iconCols.size();
        Vector<Integer> vector = new Vector<Integer>(2, 1);
        for (n = 0; n < this.columns.length; ++n) {
            if (!this.columns[n].equals("author") && !this.columns[n].equals("editor")) continue;
            vector.add(new Integer(n));
        }
        this.nameCols = new int[vector.size()];
        for (n = 0; n < this.nameCols.length; ++n) {
            this.nameCols[n] = (Integer)vector.elementAt(n);
        }
    }

    public boolean isIconColumn(int n) {
        return this.getIconTypeForColumn(n) != null;
    }

    static class SearchMatcher
    implements Matcher {
        private String field = "__search";
        private SearchRuleSet ruleSet;
        private Hashtable searchOptions;

        public SearchMatcher(SearchRuleSet searchRuleSet, Hashtable hashtable) {
            this.ruleSet = searchRuleSet;
            this.searchOptions = hashtable;
        }

        public boolean matches(Object object) {
            BibtexEntry bibtexEntry = (BibtexEntry)object;
            int n = this.ruleSet.applyRule(this.searchOptions, bibtexEntry);
            return n > 0;
        }
    }

    static class NoSearchMatcher
    implements Matcher {
        NoSearchMatcher() {
        }

        public boolean matches(Object object) {
            return true;
        }
    }
}

