/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.gui.EntryTypeList;
import net.sf.jabref.gui.FieldSetComponent;

public class EntryCustomizationDialog2
extends JDialog
implements ListSelectionListener,
ActionListener {
    protected JabRefFrame frame;
    protected GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints con = new GridBagConstraints();
    protected FieldSetComponent reqComp;
    protected FieldSetComponent optComp;
    protected EntryTypeList typeComp;
    protected JButton ok;
    protected JButton cancel;
    protected JButton apply;
    protected JButton helpButton;
    protected JButton delete;
    protected JButton importTypes;
    protected JButton exportTypes;
    protected final List preset = Arrays.asList(BibtexFields.getAllFieldNames());
    protected String lastSelected = null;
    protected Map reqLists = new HashMap();
    protected Map optLists = new HashMap();
    protected Set defaulted = new HashSet();
    protected Set changed = new HashSet();

    public EntryCustomizationDialog2(JabRefFrame jabRefFrame) {
        super(jabRefFrame, Globals.lang("Customize entry types"), false);
        this.frame = jabRefFrame;
        this.initGui();
    }

    protected final void initGui() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel3.setLayout(new GridLayout(1, 2));
        ArrayList arrayList = new ArrayList();
        Object object = BibtexEntryType.ALL_TYPES.keySet().iterator();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        this.typeComp = new EntryTypeList(arrayList);
        this.typeComp.addListSelectionListener(this);
        this.typeComp.addAdditionActionListener(this);
        this.typeComp.addDefaultActionListener(new DefaultListener());
        this.typeComp.setListSelectionMode(0);
        this.reqComp = new FieldSetComponent(Globals.lang("Required fields"), new ArrayList(), this.preset, true, true);
        this.reqComp.setEnabled(false);
        this.reqComp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        object = new DataListener();
        this.reqComp.addListDataListener((ListDataListener)object);
        this.optComp = new FieldSetComponent(Globals.lang("Optional fields"), new ArrayList(), this.preset, true, true);
        this.optComp.setEnabled(false);
        this.optComp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.optComp.addListDataListener((ListDataListener)object);
        jPanel3.add(this.reqComp);
        jPanel3.add(this.optComp);
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.ok = new JButton("OK");
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.apply = new JButton(Globals.lang("Apply"));
        this.ok.addActionListener(this);
        this.apply.addActionListener(this);
        this.cancel.addActionListener(this);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(jPanel2);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded(this.ok);
        buttonBarBuilder.addGridded(this.apply);
        buttonBarBuilder.addGridded(this.cancel);
        buttonBarBuilder.addGlue();
        jPanel.add((Component)this.typeComp, "West");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.pack();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.lastSelected != null) {
            this.reqLists.put(this.lastSelected, this.reqComp.getFields());
            this.optLists.put(this.lastSelected, this.optComp.getFields());
        }
        if ((string = this.typeComp.getFirstSelected()) == null) {
            return;
        }
        Object v = this.reqLists.get(string);
        if (v == null) {
            BibtexEntryType bibtexEntryType = BibtexEntryType.getType(string);
            if (bibtexEntryType != null) {
                String[] stringArray = bibtexEntryType.getRequiredFields();
                String[] stringArray2 = bibtexEntryType.getOptionalFields();
                List<String> list = stringArray != null ? Arrays.asList(stringArray) : new ArrayList<String>();
                List<String> list2 = stringArray2 != null ? Arrays.asList(stringArray2) : new ArrayList<String>();
                this.reqComp.setFields(list);
                this.reqComp.setEnabled(true);
                this.optComp.setFields(list2);
                this.optComp.setEnabled(true);
            } else {
                this.reqComp.setFields(new ArrayList());
                this.reqComp.setEnabled(true);
                this.optComp.setFields(new ArrayList());
                this.optComp.setEnabled(true);
                new FocusRequester(this.reqComp);
            }
        } else {
            this.reqComp.setFields((List)v);
            this.optComp.setFields((List)this.optLists.get(string));
        }
        this.lastSelected = string;
        this.typeComp.enable(string, this.changed.contains(this.lastSelected) && !this.defaulted.contains(this.lastSelected));
    }

    protected void applyChanges() {
        List list;
        Object object;
        this.valueChanged(new ListSelectionEvent(new JList(), 0, 0, false));
        List list2 = this.typeComp.getFields();
        boolean bl = false;
        Object object2 = this.reqLists.keySet().iterator();
        while (object2.hasNext()) {
            Object object3;
            Object object4;
            object = (String)object2.next();
            if (!list2.contains(object)) continue;
            list = (List)this.reqLists.get(object);
            List list3 = (List)this.optLists.get(object);
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            String[] stringArray2 = new String[list3.size()];
            list3.toArray(stringArray2);
            boolean bl2 = true;
            if (this.defaulted.contains(object)) {
                object4 = Util.nCase(object);
                BibtexEntryType.removeType((String)object4);
                this.updateTypesForEntries((String)object4);
                bl = true;
                continue;
            }
            object4 = BibtexEntryType.getType(object);
            if (object4 != null) {
                object3 = ((BibtexEntryType)object4).getRequiredFields();
                String[] stringArray3 = ((BibtexEntryType)object4).getOptionalFields();
                if (this.equalArrays((String[])object3, stringArray) && this.equalArrays(stringArray3, stringArray2)) {
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            object3 = new CustomEntryType(Util.nCase(object), stringArray, stringArray2);
            BibtexEntryType.ALL_TYPES.put(((String)object).toLowerCase(), object3);
            this.updateTypesForEntries(((CustomEntryType)object3).getName());
            bl = true;
        }
        object2 = new HashSet();
        object = BibtexEntryType.ALL_TYPES.keySet().iterator();
        while (object.hasNext()) {
            list = object.next();
            if (list2.contains(list)) continue;
            object2.add(list);
        }
        if (object2.size() > 0) {
            object = object2.iterator();
            while (object.hasNext()) {
                this.typeDeletion((String)object.next());
            }
        }
        this.updateTables();
    }

    protected void typeDeletion(String string) {
        BibtexEntryType bibtexEntryType = BibtexEntryType.getType(string);
        if (bibtexEntryType instanceof CustomEntryType) {
            int n;
            if (BibtexEntryType.getStandardType(string) == null && (n = JOptionPane.showConfirmDialog(this.frame, Globals.lang("All entries of this type will be declared typeless. Continue?"), Globals.lang("Delete custom format") + " '" + Util.nCase(string) + "'", 0, 2)) != 0) {
                return;
            }
            BibtexEntryType.removeType(string);
            this.updateTypesForEntries(Util.nCase(string));
            this.changed.remove(string);
            this.reqLists.remove(string);
            this.optLists.remove(string);
        }
    }

    protected boolean equalArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray == null && stringArray2 == null) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            this.applyChanges();
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.cancel) {
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.apply) {
            this.applyChanges();
        } else if (actionEvent.getSource() == this.typeComp) {
            this.typeComp.selectField(actionEvent.getActionCommand());
        }
    }

    private void updateTypesForEntries(String string) {
        if (this.frame.getTabbedPane().getTabCount() == 0) {
            return;
        }
        for (int i = 0; i < this.frame.getTabbedPane().getTabCount(); ++i) {
            BasePanel basePanel = (BasePanel)this.frame.getTabbedPane().getComponentAt(i);
            boolean bl = false;
            basePanel.entryEditors.remove(string);
            BibtexDatabase bibtexDatabase = basePanel.database();
            Iterator iterator = bibtexDatabase.getKeySet().iterator();
            while (iterator.hasNext()) {
                bl |= !bibtexDatabase.getEntryById((String)iterator.next()).updateType();
            }
        }
    }

    private void updateTables() {
        if (this.frame.getTabbedPane().getTabCount() == 0) {
            return;
        }
        for (int i = 0; i < this.frame.getTabbedPane().getTabCount(); ++i) {
            BasePanel basePanel = (BasePanel)this.frame.getTabbedPane().getComponentAt(i);
        }
    }

    class DataListener
    implements ListDataListener {
        DataListener() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.record();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.record();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.record();
        }

        private void record() {
            if (EntryCustomizationDialog2.this.lastSelected == null) {
                return;
            }
            EntryCustomizationDialog2.this.defaulted.remove(EntryCustomizationDialog2.this.lastSelected);
            EntryCustomizationDialog2.this.changed.add(EntryCustomizationDialog2.this.lastSelected);
            EntryCustomizationDialog2.this.typeComp.enable(EntryCustomizationDialog2.this.lastSelected, true);
        }
    }

    class DefaultListener
    implements ActionListener {
        DefaultListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EntryCustomizationDialog2.this.lastSelected == null) {
                return;
            }
            EntryCustomizationDialog2.this.defaulted.add(EntryCustomizationDialog2.this.lastSelected);
            BibtexEntryType bibtexEntryType = BibtexEntryType.getStandardType(EntryCustomizationDialog2.this.lastSelected);
            if (bibtexEntryType != null) {
                String[] stringArray = bibtexEntryType.getRequiredFields();
                String[] stringArray2 = bibtexEntryType.getOptionalFields();
                List<String> list = stringArray != null ? Arrays.asList(stringArray) : new ArrayList<String>();
                List<String> list2 = stringArray2 != null ? Arrays.asList(stringArray2) : new ArrayList<String>();
                EntryCustomizationDialog2.this.reqComp.setFields(list);
                EntryCustomizationDialog2.this.reqComp.setEnabled(true);
                EntryCustomizationDialog2.this.optComp.setFields(list2);
            }
        }
    }
}

