/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;

public class DatabasePropertiesDialog
extends JDialog {
    MetaData metaData;
    BasePanel panel = null;
    JComboBox encoding;
    JButton ok;
    JButton cancel;
    JTextField pdfDir = new JTextField(40);
    JTextField psDir = new JTextField(40);

    public DatabasePropertiesDialog(JFrame jFrame) {
        super(jFrame, Globals.lang("Database properties"), false);
        this.encoding = new JComboBox<String>(Globals.ENCODINGS);
        this.ok = new JButton(Globals.lang("Ok"));
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.init(jFrame);
    }

    public void setPanel(BasePanel basePanel) {
        this.panel = basePanel;
        this.metaData = basePanel.metaData();
    }

    public final void init(JFrame jFrame) {
        JButton jButton = new JButton(Globals.lang("Browse"));
        JButton jButton2 = new JButton(Globals.lang("Browse"));
        jButton.addActionListener(new BrowseAction(jFrame, this.pdfDir, true));
        jButton2.addActionListener(new BrowseAction(jFrame, this.psDir, true));
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, left:pref, 4dlu, fill:pref", ""));
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        defaultFormBuilder.append(Globals.lang("Database encoding"));
        defaultFormBuilder.append(this.encoding);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Override default file directories"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("PDF directory"));
        defaultFormBuilder.append(this.pdfDir);
        defaultFormBuilder.append(jButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("PS directory"));
        defaultFormBuilder.append(this.psDir);
        defaultFormBuilder.append(jButton2);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded(this.ok);
        buttonBarBuilder.addGridded(this.cancel);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)defaultFormBuilder.getPanel(), "Center");
        this.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.pack();
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabasePropertiesDialog.this.storeSettings();
                DatabasePropertiesDialog.this.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabasePropertiesDialog.this.dispose();
            }
        });
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setValues();
        }
        super.setVisible(bl);
    }

    public void setValues() {
        this.encoding.setSelectedItem(this.panel.getEncoding());
        Vector vector = this.metaData.getData("pdfDirectory");
        if (vector == null) {
            this.pdfDir.setText("");
        } else if (vector.size() >= 1) {
            this.pdfDir.setText(((String)vector.get(0)).trim());
        }
        Vector vector2 = this.metaData.getData("psDirectory");
        if (vector2 == null) {
            this.psDir.setText("");
        } else if (vector2.size() >= 1) {
            this.psDir.setText(((String)vector2.get(0)).trim());
        }
    }

    public void storeSettings() {
        this.panel.setEncoding((String)this.encoding.getSelectedItem());
        Vector<String> vector = new Vector<String>(1);
        String string = this.pdfDir.getText().trim();
        if (string.length() > 0) {
            vector.add(string);
            this.metaData.putData("pdfDirectory", vector);
        } else {
            this.metaData.remove("pdfDirectory");
        }
        vector = new Vector(1);
        string = this.psDir.getText().trim();
        if (string.length() > 0) {
            vector.add(string);
            this.metaData.putData("psDirectory", vector);
        } else {
            this.metaData.remove("psDirectory");
        }
    }
}

