/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import net.sf.jabref.Globals;

public class ColorSetupPanel
extends JPanel {
    private static final int ICON_WIDTH = 30;
    private static final int ICON_HEIGHT = 20;
    private ArrayList buttons = new ArrayList();

    public ColorSetupPanel() {
        FormLayout formLayout = new FormLayout("30dlu, 4dlu, fill:pref, 4dlu, fill:pref, 8dlu, 30dlu, 4dlu, fill:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        this.buttons.add(new ColorButton("tableText", Globals.lang("Table text color")));
        this.buttons.add(new ColorButton("tableBackground", Globals.lang("Table background color")));
        this.buttons.add(new ColorButton("tableReqFieldBackground", Globals.lang("Background color for required fields")));
        this.buttons.add(new ColorButton("tableOptFieldBackground", Globals.lang("Background color for optional fields")));
        this.buttons.add(new ColorButton("markedEntryBackground", Globals.lang("Background color for marked entries")));
        this.buttons.add(new ColorButton("incompleteEntryBackground", Globals.lang("Color for marking incomplete entries")));
        this.buttons.add(new ColorButton("gridColor", Globals.lang("Table grid color")));
        Iterator iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            ColorButton colorButton = (ColorButton)iterator.next();
            defaultFormBuilder.append(colorButton);
            defaultFormBuilder.append(colorButton.getDefaultButton());
            defaultFormBuilder.append(colorButton.getName());
            colorButton.addActionListener(new ColorButtonListener(colorButton));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)defaultFormBuilder.getPanel(), "Center");
        this.setValues();
    }

    public void setValues() {
        Iterator iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            ColorButton colorButton = (ColorButton)iterator.next();
            colorButton.setColor(Globals.prefs.getColor(colorButton.getKey()));
        }
    }

    public void storeSettings() {
        Iterator iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            ColorButton colorButton = (ColorButton)iterator.next();
            Globals.prefs.putColor(colorButton.getKey(), colorButton.getColor());
        }
    }

    class ColorButton
    extends JButton
    implements Icon {
        private Color color = Color.white;
        private String key;
        private String name;

        public ColorButton(String string, String string2) {
            this.setIcon(this);
            this.key = string;
            this.name = string2;
            this.setBorder(BorderFactory.createRaisedBevelBorder());
        }

        public JButton getDefaultButton() {
            JButton jButton = new JButton(Globals.lang("Default"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorButton.this.setColor(Globals.prefs.getDefaultColor(ColorButton.this.key));
                    ColorButton.this.repaint();
                }
            });
            return jButton;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(this.color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public int getIconWidth() {
            return 30;
        }

        public int getIconHeight() {
            return 20;
        }
    }

    class ColorButtonListener
    implements ActionListener {
        private ColorButton button;

        public ColorButtonListener(ColorButton colorButton) {
            this.button = colorButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(null, this.button.getName(), this.button.getColor());
            if (color != null) {
                this.button.setColor(color);
            }
        }
    }
}

