/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFilePanel;

public class AttachFileDialog
extends JDialog {
    AttachFileDialog ths = this;
    FieldEditor editor;
    String fieldName;
    JPanel main;
    JButton browse = new JButton(Globals.lang("Browse"));
    JButton download = new JButton(Globals.lang("Download"));
    JButton auto = new JButton(Globals.lang("Auto"));
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    BibtexEntry entry;
    MetaData metaData;
    private boolean cancelled = true;

    public AttachFileDialog(Frame frame, MetaData metaData, BibtexEntry bibtexEntry, String string) {
        super(frame, true);
        this.metaData = metaData;
        this.entry = bibtexEntry;
        this.fieldName = string;
        this.editor = new FieldTextField(string, (String)bibtexEntry.getField(string), false);
        this.initGui();
    }

    public AttachFileDialog(Dialog dialog, MetaData metaData, BibtexEntry bibtexEntry, String string) {
        super(dialog, true);
        this.metaData = metaData;
        this.entry = bibtexEntry;
        this.fieldName = string;
        this.editor = new FieldTextField(string, (String)bibtexEntry.getField(string), false);
        this.initGui();
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public String getValue() {
        return this.editor.getText();
    }

    private void initGui() {
        final ExternalFilePanel externalFilePanel = new ExternalFilePanel(this.fieldName, this.metaData, this.entry, Util.getFileFilterForField(this.fieldName));
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                externalFilePanel.browseFile(AttachFileDialog.this.fieldName, AttachFileDialog.this.editor);
            }
        });
        this.download.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                externalFilePanel.downLoadFile(AttachFileDialog.this.fieldName, AttachFileDialog.this.editor, AttachFileDialog.this.ths);
            }
        });
        this.auto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                externalFilePanel.autoSetFile(AttachFileDialog.this.fieldName, AttachFileDialog.this.editor);
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttachFileDialog.this.cancelled = false;
                AttachFileDialog.this.dispose();
            }
        };
        this.ok.addActionListener(actionListener);
        ((JTextField)this.editor.getTextComponent()).addActionListener(actionListener);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttachFileDialog.this.cancelled = true;
                AttachFileDialog.this.dispose();
            }
        };
        this.cancel.addActionListener(abstractAction);
        this.editor.getTextComponent().getInputMap().put(Globals.prefs.getKey("Close dialog"), "close");
        this.editor.getTextComponent().getActionMap().put("close", abstractAction);
        FormLayout formLayout = new FormLayout("fill:160dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.appendSeparator(Util.nCase(this.fieldName));
        defaultFormBuilder.append(this.editor.getTextComponent());
        defaultFormBuilder.append(this.browse);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGridded(this.download);
        buttonBarBuilder.addGridded(this.auto);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(buttonBarBuilder.getPanel());
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator();
        this.main = defaultFormBuilder.getPanel();
        this.main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded(this.ok);
        buttonBarBuilder.addGridded(this.cancel);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)this.main, "Center");
        this.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.pack();
    }
}

