/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchRule;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.UndoableChangeAssignment;
import net.sf.jabref.groups.UnsupportedVersionException;
import net.sf.jabref.util.QuotedStringTokenizer;

public class ExplicitGroup
extends AbstractGroup
implements SearchRule {
    public static final String ID = "ExplicitGroup:";
    private final Set m_entries = new HashSet();

    public ExplicitGroup(String string, int n) {
        super(string, n);
    }

    public static AbstractGroup fromString(String string, BibtexDatabase bibtexDatabase, int n) throws Exception {
        if (!string.startsWith(ID)) {
            throw new Exception("Internal error: ExplicitGroup cannot be created from \"" + string + "\". " + "Please report this on www.sf.net/projects/jabref");
        }
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string.substring(ID.length()), ";", '\\');
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                ExplicitGroup explicitGroup = new ExplicitGroup(quotedStringTokenizer.nextToken(), 0);
                explicitGroup.addEntries(quotedStringTokenizer, bibtexDatabase);
                return explicitGroup;
            }
            case 3: {
                String string2 = quotedStringTokenizer.nextToken();
                int n2 = Integer.parseInt(quotedStringTokenizer.nextToken());
                ExplicitGroup explicitGroup = new ExplicitGroup(string2, n2);
                explicitGroup.addEntries(quotedStringTokenizer, bibtexDatabase);
                return explicitGroup;
            }
        }
        throw new UnsupportedVersionException("ExplicitGroup", n);
    }

    protected void addEntries(QuotedStringTokenizer quotedStringTokenizer, BibtexDatabase bibtexDatabase) {
        while (quotedStringTokenizer.hasMoreTokens()) {
            BibtexEntry[] bibtexEntryArray = bibtexDatabase.getEntriesByKey(Util.unquote(quotedStringTokenizer.nextToken(), '\\'));
            for (int i = 0; i < bibtexEntryArray.length; ++i) {
                this.m_entries.add(bibtexEntryArray[i]);
            }
        }
    }

    public SearchRule getSearchRule() {
        return this;
    }

    public boolean supportsAdd() {
        return true;
    }

    public boolean supportsRemove() {
        return true;
    }

    public AbstractUndoableEdit add(BibtexEntry[] bibtexEntryArray) {
        if (bibtexEntryArray.length == 0) {
            return null;
        }
        HashSet hashSet = new HashSet(this.m_entries);
        for (int i = 0; i < bibtexEntryArray.length; ++i) {
            this.m_entries.add(bibtexEntryArray[i]);
        }
        return new UndoableChangeAssignment(hashSet, this.m_entries);
    }

    public boolean addEntry(BibtexEntry bibtexEntry) {
        return this.m_entries.add(bibtexEntry);
    }

    public AbstractUndoableEdit remove(BibtexEntry[] bibtexEntryArray) {
        if (bibtexEntryArray.length == 0) {
            return null;
        }
        HashSet hashSet = new HashSet(this.m_entries);
        for (int i = 0; i < bibtexEntryArray.length; ++i) {
            this.m_entries.remove(bibtexEntryArray[i]);
        }
        return new UndoableChangeAssignment(hashSet, this.m_entries);
    }

    public boolean removeEntry(BibtexEntry bibtexEntry) {
        return this.m_entries.remove(bibtexEntry);
    }

    public boolean contains(BibtexEntry bibtexEntry) {
        return this.m_entries.contains(bibtexEntry);
    }

    public boolean contains(Map map, BibtexEntry bibtexEntry) {
        return this.contains(bibtexEntry);
    }

    public int applyRule(Map map, BibtexEntry bibtexEntry) {
        return this.contains(map, bibtexEntry) ? 1 : 0;
    }

    public AbstractGroup deepCopy() {
        ExplicitGroup explicitGroup = new ExplicitGroup(this.m_name, this.m_context);
        explicitGroup.m_entries.addAll(this.m_entries);
        return explicitGroup;
    }

    public boolean equals(Object object) {
        String string;
        BibtexEntry bibtexEntry;
        if (!(object instanceof ExplicitGroup)) {
            return false;
        }
        ExplicitGroup explicitGroup = (ExplicitGroup)object;
        if (this.m_entries.size() != explicitGroup.m_entries.size()) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.m_entries.iterator();
        while (iterator.hasNext()) {
            bibtexEntry = (BibtexEntry)iterator.next();
            string = bibtexEntry.getCiteKey();
            if (string == null) continue;
            hashSet.add(string);
        }
        iterator = explicitGroup.m_entries.iterator();
        while (iterator.hasNext()) {
            bibtexEntry = (BibtexEntry)iterator.next();
            string = bibtexEntry.getCiteKey();
            if (string == null || hashSet.remove(string)) continue;
            return false;
        }
        if (!hashSet.isEmpty()) {
            return false;
        }
        return explicitGroup.m_name.equals(this.m_name) && explicitGroup.getHierarchicalContext() == this.getHierarchicalContext();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ID).append(Util.quote(this.m_name, ";", '\\')).append(";").append(this.m_context).append(";");
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = this.m_entries.iterator();
        while (iterator.hasNext()) {
            String string = ((BibtexEntry)iterator.next()).getCiteKey();
            if (string == null || string.equals("")) continue;
            treeSet.add(string);
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(Util.quote((String)iterator.next(), ";", '\\')).append(";");
        }
        return stringBuffer.toString();
    }

    public void clearAssignments() {
        this.m_entries.clear();
    }

    public boolean isDynamic() {
        return false;
    }

    public String getDescription() {
        return ExplicitGroup.getDescriptionForPreview();
    }

    public static String getDescriptionForPreview() {
        return Globals.lang("This group contains entries based on manual assignment. Entries can be assigned to this group by selecting them then using either drag and drop or the context menu. Entries can be removed from this group by selecting them then using the context menu. Every entry assigned to this group must have a unique key. The key may be changed at any time as long as it remains unique.");
    }

    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<b>").append(this.getName()).append("</b> - static group");
        switch (this.getHierarchicalContext()) {
            case 2: {
                stringBuffer.append(", includes subgroups");
                break;
            }
            case 1: {
                stringBuffer.append(", refines supergroup");
                break;
            }
        }
        return stringBuffer.toString();
    }
}

