/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.groups.TransferableEntrySelection;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.imports.ImportMenuItem;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.net.URLDownload;

public class EntryTableTransferHandler
extends TransferHandler {
    protected final MainTable entryTable;
    protected JabRefFrame frame;
    protected DataFlavor urlFlavor;
    protected DataFlavor stringFlavor;
    protected static boolean DROP_ALLOWED = true;

    public EntryTableTransferHandler(MainTable mainTable, JabRefFrame jabRefFrame) {
        this.entryTable = mainTable;
        this.frame = jabRefFrame;
        this.stringFlavor = DataFlavor.stringFlavor;
        try {
            this.urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Globals.logger("Unable to configure drag and drop for main table");
            classNotFoundException.printStackTrace();
        }
    }

    public int getSourceActions(JComponent jComponent) {
        return 0x40000000;
    }

    public Transferable createTransferable(JComponent jComponent) {
        return new TransferableEntrySelection(this.entryTable.getSelectedEntries());
    }

    protected boolean handleDropTransfer(String string) throws IOException {
        if (string.startsWith("file:")) {
            if (this.handleDraggedFilenames(string)) {
                return true;
            }
        } else if (string.startsWith("http:")) {
            URL uRL = new URL(string);
            return this.handleDropTransfer(uRL);
        }
        File file = File.createTempFile("jabrefimport", "");
        file.deleteOnExit();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.close();
        ImportMenuItem importMenuItem = new ImportMenuItem(this.frame, false);
        importMenuItem.automatedImport(new String[]{file.getAbsolutePath()});
        return true;
    }

    private boolean handleDraggedFilenames(String string) {
        String[] stringArray = string.replaceAll("\r", "").split("\n");
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file;
            String string2 = stringArray[i];
            if (!string2.startsWith("file:")) continue;
            if ((string2 = string2.substring(5)).startsWith("//")) {
                string2 = string2.substring(2);
            }
            if (!(file = new File(string2)).exists()) continue;
            arrayList.add(file);
        }
        return this.handleDraggedFiles(arrayList);
    }

    private boolean handleDraggedFiles(List list) {
        final String[] stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            stringArray[n] = file.getAbsolutePath();
            ++n;
        }
        new Thread(new Runnable(){

            public void run() {
                EntryTableTransferHandler.this.loadOrImportFiles(stringArray);
            }
        }).start();
        return true;
    }

    private void loadOrImportFiles(String[] stringArray) {
        Serializable serializable;
        OpenDatabaseAction openDatabaseAction = new OpenDatabaseAction(this.frame, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = Globals.prefs.get("defaultEncoding");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].toLowerCase().endsWith(".bib")) {
                serializable = new File(stringArray[i]);
                try {
                    ParserResult parserResult = OpenDatabaseAction.loadDatabase((File)serializable, string);
                    if (parserResult == null || parserResult == ParserResult.INVALID_FORMAT) {
                        arrayList.add(stringArray[i]);
                        continue;
                    }
                    openDatabaseAction.addNewDatabase(parserResult, (File)serializable, false);
                }
                catch (IOException iOException) {
                    arrayList.add(stringArray[i]);
                }
                continue;
            }
            if (stringArray[i].toLowerCase().endsWith(".pdf") || stringArray[i].toLowerCase().endsWith(".ps")) continue;
            arrayList.add(stringArray[i]);
        }
        if (arrayList.size() > 0) {
            String[] stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            serializable = new ImportMenuItem(this.frame, this.entryTable == null);
            ((ImportMenuItem)serializable).automatedImport(stringArray2);
        }
    }

    protected boolean handleDropTransfer(URL uRL) throws IOException {
        File file = File.createTempFile("jabrefimport", "");
        file.deleteOnExit();
        new URLDownload(this.entryTable, uRL, file).download();
        ImportMenuItem importMenuItem = new ImportMenuItem(this.frame, this.entryTable == null);
        importMenuItem.automatedImport(new String[]{file.getAbsolutePath()});
        return true;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                return this.handleDraggedFiles(list);
            }
            if (transferable.isDataFlavorSupported(this.urlFlavor)) {
                URL uRL = (URL)transferable.getTransferData(this.urlFlavor);
                return this.handleDropTransfer(uRL);
            }
            if (transferable.isDataFlavorSupported(this.stringFlavor)) {
                String string = (String)transferable.getTransferData(this.stringFlavor);
                return this.handleDropTransfer(string);
            }
        }
        catch (IOException iOException) {
            System.err.println("failed to read dropped data: " + iOException.toString());
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            System.err.println("drop type error: " + unsupportedFlavorException.toString());
        }
        System.err.println("can't transfer input: ");
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            System.out.println("  " + dataFlavorArray[i].toString());
        }
        return false;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (!DROP_ALLOWED) {
            return false;
        }
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            DataFlavor dataFlavor = dataFlavorArray[i];
            if (!dataFlavor.match(this.urlFlavor) && !dataFlavor.match(this.stringFlavor) && !dataFlavor.match(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        super.exportAsDrag(jComponent, inputEvent, 0x40000000);
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        super.exportDone(jComponent, transferable, n);
    }

    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
        super.exportToClipboard(jComponent, clipboard, n);
    }
}

