/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.SearchRule;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.groups.KeywordGroup;
import net.sf.jabref.groups.SearchGroup;

public abstract class AbstractGroup {
    protected String m_name;
    protected int m_context = 0;
    public static final int INDEPENDENT = 0;
    public static final int REFINING = 1;
    public static final int INCLUDING = 2;
    protected static final char QUOTE_CHAR = '\\';
    protected static final String SEPARATOR = ";";

    public AbstractGroup(String string, int n) {
        this.m_name = string;
        this.setHierarchicalContext(n);
    }

    public abstract SearchRule getSearchRule();

    public static AbstractGroup fromString(String string, BibtexDatabase bibtexDatabase, int n) throws Exception {
        if (string.startsWith("KeywordGroup:")) {
            return KeywordGroup.fromString(string, bibtexDatabase, n);
        }
        if (string.startsWith("AllEntriesGroup:")) {
            return AllEntriesGroup.fromString(string, bibtexDatabase, n);
        }
        if (string.startsWith("SearchGroup:")) {
            return SearchGroup.fromString(string, bibtexDatabase, n);
        }
        if (string.startsWith("ExplicitGroup:")) {
            return ExplicitGroup.fromString(string, bibtexDatabase, n);
        }
        return null;
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String string) {
        this.m_name = string;
    }

    public abstract boolean supportsAdd();

    public abstract boolean supportsRemove();

    public abstract AbstractUndoableEdit add(BibtexEntry[] var1);

    public abstract AbstractUndoableEdit remove(BibtexEntry[] var1);

    public abstract boolean contains(Map var1, BibtexEntry var2);

    public abstract boolean contains(BibtexEntry var1);

    public boolean containsAny(BibtexEntry[] bibtexEntryArray) {
        for (int i = 0; i < bibtexEntryArray.length; ++i) {
            if (!this.contains(bibtexEntryArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(BibtexEntry[] bibtexEntryArray) {
        for (int i = 0; i < bibtexEntryArray.length; ++i) {
            if (this.contains(bibtexEntryArray[i])) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isDynamic();

    public void setHierarchicalContext(int n) {
        if (n != 0 && n != 1 && n != 2) {
            return;
        }
        this.m_context = n;
    }

    public int getHierarchicalContext() {
        return this.m_context;
    }

    public abstract String getDescription();

    public abstract AbstractGroup deepCopy();

    public abstract String getShortDescription();
}

