/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Icon;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.external.PushToApplication;

public class PushToLyx
implements PushToApplication {
    private boolean couldNotFindPipe = false;
    private boolean couldNotWrite = false;
    private String message = "";

    public void pushEntries(BibtexEntry[] bibtexEntryArray, final String string) {
        this.couldNotFindPipe = false;
        this.couldNotWrite = false;
        final File file = new File(Globals.prefs.get("lyxpipe") + ".in");
        if (!file.exists() || !file.canWrite()) {
            this.couldNotFindPipe = true;
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    FileWriter fileWriter = new FileWriter(file);
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    String string2 = "";
                    string2 = "LYXCMD:sampleclient:citation-insert:" + string;
                    bufferedWriter.write(string2 + "\n");
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    PushToLyx.this.couldNotWrite = true;
                    return;
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public String getName() {
        return Globals.lang("Insert selected citations into LyX/Kile");
    }

    public String getTooltip() {
        return Globals.lang("Push selection to LyX/Kile");
    }

    public Icon getIcon() {
        return GUIGlobals.getImage("lyx");
    }

    public String getKeyStrokeName() {
        return "Push to LyX";
    }

    public void operationCompleted(BasePanel basePanel) {
        if (this.couldNotFindPipe) {
            basePanel.output(Globals.lang("Error") + ": " + Globals.lang("verify that LyX is running and that the lyxpipe is valid") + ". [" + Globals.prefs.get("lyxpipe") + "]");
        } else if (this.couldNotWrite) {
            basePanel.output(Globals.lang("Error") + ": " + Globals.lang("unable to write to") + " " + Globals.prefs.get("lyxpipe") + ".in");
        } else {
            basePanel.output(Globals.lang("Pushed the citations for the following rows to") + " Lyx: " + this.message);
        }
    }

    public boolean requiresBibtexKeys() {
        return true;
    }
}

