/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.external.PushToApplication;

public class PushToEmacs
implements PushToApplication {
    private boolean couldNotConnect = false;
    private boolean couldNotRunClient = false;

    public String getName() {
        return Globals.menuTitle("Insert selected citations into Emacs");
    }

    public String getTooltip() {
        return Globals.lang("Push selection to Emacs");
    }

    public Icon getIcon() {
        return GUIGlobals.getImage("emacs");
    }

    public String getKeyStrokeName() {
        return "Push to Emacs";
    }

    public void pushEntries(BibtexEntry[] bibtexEntryArray, String string) {
        this.couldNotConnect = false;
        this.couldNotRunClient = false;
        StringBuffer stringBuffer = new StringBuffer("(insert\"\\\\").append(Globals.prefs.get("citeCommand")).append("{");
        try {
            stringBuffer.append(string);
            stringBuffer.append("}\")");
            String[] stringArray = new String[]{"gnuclient", "-batch", "-eval", stringBuffer.toString()};
            final Process process = Runtime.getRuntime().exec(stringArray);
            Runnable runnable = new Runnable(){

                public void run() {
                    InputStream inputStream = process.getErrorStream();
                    StringBuffer stringBuffer = new StringBuffer();
                    try {
                        int n;
                        while ((n = inputStream.read()) != -1) {
                            stringBuffer.append((char)n);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (stringBuffer.toString().trim().length() > 0) {
                        PushToEmacs.this.couldNotConnect = true;
                        return;
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
            thread.join();
        }
        catch (IOException iOException) {
            this.couldNotRunClient = true;
            return;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void operationCompleted(BasePanel basePanel) {
        if (this.couldNotConnect) {
            JOptionPane.showMessageDialog(basePanel.frame(), "<HTML>" + Globals.lang("Could not connect to a running gnuserv process. Make sure that Emacs or XEmacs is running,<BR>and that the server has been started (by running the command 'gnuserv-start').") + "</HTML>", Globals.lang("Error"), 0);
        } else if (this.couldNotRunClient) {
            JOptionPane.showMessageDialog(basePanel.frame(), Globals.lang("Could not run the 'gnuclient' program. Make sure you have the gnuserv/gnuclient programs installed."), Globals.lang("Error"), 0);
        } else {
            basePanel.output(Globals.lang("Pushed citations to Emacs"));
        }
    }

    public boolean requiresBibtexKeys() {
        return true;
    }
}

