/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.UrlDragDrop;
import net.sf.jabref.Util;
import net.sf.jabref.net.URLDownload;

public class ExternalFilePanel
extends JPanel {
    private JButton browseBut;
    private JButton download;
    private JButton auto;
    private EntryEditor entryEditor;
    private JabRefFrame frame;
    private OpenFileFilter off;
    private BibtexEntry entry = null;
    private MetaData metaData;

    public ExternalFilePanel(String string, MetaData metaData, BibtexEntry bibtexEntry, OpenFileFilter openFileFilter) {
        this(null, metaData, null, string, openFileFilter, null);
        this.entry = bibtexEntry;
    }

    public ExternalFilePanel(final JabRefFrame jabRefFrame, MetaData metaData, final EntryEditor entryEditor, final String string, OpenFileFilter openFileFilter, final FieldEditor fieldEditor) {
        this.frame = jabRefFrame;
        this.metaData = metaData;
        this.off = openFileFilter;
        this.entryEditor = entryEditor;
        this.setLayout(new GridLayout(2, 1));
        this.browseBut = new JButton(Globals.lang("Browse"));
        this.download = new JButton(Globals.lang("Download"));
        this.auto = new JButton(Globals.lang("Auto"));
        this.browseBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFilePanel.this.browseFile(string, fieldEditor);
                entryEditor.storeFieldAction.actionPerformed(new ActionEvent(fieldEditor, 0, ""));
            }
        });
        this.download.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFilePanel.this.downLoadFile(string, fieldEditor, jabRefFrame);
            }
        });
        this.auto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFilePanel.this.autoSetFile(string, fieldEditor);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        this.add(this.browseBut);
        jPanel.add(this.auto);
        jPanel.add(this.download);
        this.add(jPanel);
        if (fieldEditor != null) {
            ((JComponent)((Object)fieldEditor)).setDropTarget(new DropTarget((Component)((Object)fieldEditor), 0, new UrlDragDrop(entryEditor, jabRefFrame, fieldEditor)));
        }
    }

    public void setEntry(BibtexEntry bibtexEntry) {
        this.entry = bibtexEntry;
    }

    protected Object getKey() {
        return this.entry != null ? this.entry.getField("bibtexkey") : this.entryEditor.getEntry().getField("bibtexkey");
    }

    protected void output(String string) {
        if (this.frame != null) {
            this.frame.output(string);
        }
    }

    public void browseFile(String string, FieldEditor fieldEditor) {
        String string2;
        String string3 = this.metaData.getFileDirectory(string);
        if (string3 != null && string3.equals("")) {
            string3 = null;
        }
        String string4 = fieldEditor.getText();
        String string5 = null;
        if (string3 == null || !new File(string4).isAbsolute()) {
            string4 = string3 != null ? string3 : Globals.prefs.get(string + "_dir", "");
        }
        if ((string2 = Globals.getNewFile(this.frame, new File(string4), "." + string, 0, false)) != null) {
            File file = new File(string2);
            String string6 = file.getParent();
            if (string3 != null && string6.startsWith(string3)) {
                String string7 = string6.substring(string3.length(), string6.length()) + File.separator + file.getName();
                if (string7.startsWith(File.separator)) {
                    string7 = string7.substring(File.separator.length(), string7.length());
                }
                string5 = string7;
            } else {
                string5 = file.getPath();
            }
            fieldEditor.setText(string5);
            Globals.prefs.put(string + "_dir", file.getPath());
        }
    }

    public void downLoadFile(String string, FieldEditor fieldEditor, Component component) {
        String string2 = JOptionPane.showInputDialog(component, (Object)Globals.lang("Enter URL to download"));
        if (string2 != null) {
            class Downloader
            extends Thread {
                String res;
                BibtexEntry targetEntry = null;
                private final /* synthetic */ FieldEditor val$editor;
                private final /* synthetic */ String val$fieldName;
                private final /* synthetic */ Component val$parent;

                public Downloader(String string, FieldEditor fieldEditor, String string2, Component component) {
                    this.val$editor = fieldEditor;
                    this.val$fieldName = string2;
                    this.val$parent = component;
                    this.res = string;
                    if (ExternalFilePanel.this.entryEditor != null) {
                        this.targetEntry = ExternalFilePanel.this.entryEditor.getEntry();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String string = this.val$editor.getText();
                    this.val$editor.setEnabled(false);
                    boolean bl = true;
                    try {
                        this.val$editor.setText(Globals.lang("Downloading..."));
                        URL uRL = new URL(this.res);
                        String string2 = ExternalFilePanel.this.off.getSuffix(this.res);
                        if (string2 == null) {
                            string2 = "." + this.val$fieldName.toLowerCase();
                        }
                        String string3 = null;
                        if (ExternalFilePanel.this.getKey() != null) {
                            string3 = ExternalFilePanel.this.getKey() + string2;
                        } else {
                            string3 = JOptionPane.showInputDialog(this.val$parent, (Object)Globals.lang("BibTeX key not set. Enter a name for the downloaded file"));
                            if (string3 == null) {
                                return;
                            }
                            if (!ExternalFilePanel.this.off.accept(string3)) {
                                string3 = string3 + string2;
                            }
                        }
                        String string4 = ExternalFilePanel.this.metaData.getFileDirectory(this.val$fieldName);
                        System.out.println(string4);
                        File file = new File(new File(string4), string3);
                        URLDownload uRLDownload = new URLDownload(this.val$parent, uRL, file);
                        ExternalFilePanel.this.output(Globals.lang("Downloading..."));
                        try {
                            uRLDownload.download();
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(this.val$parent, Globals.lang("Invalid URL: " + iOException.getMessage()), Globals.lang("Download file"), 0);
                            Globals.logger("Error while downloading " + uRL.toString());
                        }
                        bl = ExternalFilePanel.this.entryEditor == null || ExternalFilePanel.this.entryEditor.getEntry() == this.targetEntry;
                        ExternalFilePanel.this.output(Globals.lang("Download completed"));
                        String string5 = file.getPath();
                        if (string5.startsWith(string4)) {
                            String string6 = string5.substring(string4.length(), string5.length());
                            if (string6.startsWith(File.separator)) {
                                string6 = string6.substring(File.separator.length(), string6.length());
                            }
                            string5 = string6;
                        }
                        string = string5;
                        if (bl) {
                            SwingUtilities.invokeLater(new Thread(){

                                public void run() {
                                    if (ExternalFilePanel.this.entryEditor != null) {
                                        ExternalFilePanel.this.entryEditor.updateField(val$editor);
                                    }
                                }
                            });
                        } else {
                            this.targetEntry.setField(this.val$fieldName, string);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        JOptionPane.showMessageDialog(this.val$parent, "Invalid URL: " + malformedURLException.getMessage(), "Download file", 0);
                    }
                    finally {
                        if (bl) {
                            System.out.println("Juuu");
                            this.val$editor.setText(string);
                            this.val$editor.setEnabled(true);
                        }
                    }
                }
            }
            new Downloader(string2, fieldEditor, string, component).start();
        }
    }

    public Thread autoSetFile(final String string, final FieldEditor fieldEditor) {
        Object object = this.getKey();
        if (object == null || Globals.prefs.get(string + "Directory") == null) {
            this.output(Globals.lang("You must set both BibTeX key and %0 directory", string.toUpperCase()) + ".");
            return null;
        }
        this.output(Globals.lang("Searching for %0 file", string.toUpperCase()) + " '" + object + "." + string + "'...");
        Thread thread = new Thread(){

            public void run() {
                String string3;
                Object object = ExternalFilePanel.this.getKey();
                String string2 = Util.findPdf((String)object, string, string3 = ExternalFilePanel.this.metaData.getFileDirectory(string), ExternalFilePanel.this.off);
                if (string2 != null) {
                    fieldEditor.setText(string2);
                    if (ExternalFilePanel.this.entryEditor != null) {
                        ExternalFilePanel.this.entryEditor.updateField(fieldEditor);
                    }
                    ExternalFilePanel.this.output(Globals.lang("%0 field set", string.toUpperCase()) + ".");
                } else {
                    ExternalFilePanel.this.output(Globals.lang("No %0 found", string.toUpperCase()) + ".");
                }
            }
        };
        thread.start();
        return thread;
    }
}

