/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Vector;
import net.sf.jabref.export.layout.Layout;
import wsi.ra.types.StringInt;

public class LayoutHelper {
    public static final int IS_LAYOUT_TEXT = 1;
    public static final int IS_SIMPLE_FIELD = 2;
    public static final int IS_FIELD_START = 3;
    public static final int IS_FIELD_END = 4;
    public static final int IS_OPTION_FIELD = 5;
    public static final int IS_GROUP_START = 6;
    public static final int IS_GROUP_END = 7;
    private static String currentGroup = null;
    private PushbackReader _in;
    private Vector parsedEntries = new Vector();
    private boolean _eof = false;
    private int line = 1;

    public LayoutHelper(Reader reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        this._in = new PushbackReader(reader);
    }

    public Layout getLayoutFromText(String string) throws Exception {
        this.parse();
        for (int i = 0; i < this.parsedEntries.size(); ++i) {
            StringInt stringInt = (StringInt)this.parsedEntries.get(i);
            if (stringInt.i != 2 && stringInt.i != 3 && stringInt.i != 4 && stringInt.i != 6 && stringInt.i != 7) continue;
            stringInt.s = stringInt.s.trim().toLowerCase();
        }
        Layout layout = new Layout(this.parsedEntries, string);
        return layout;
    }

    public static String getCurrentGroup() {
        return currentGroup;
    }

    public static void setCurrentGroup(String string) {
        currentGroup = string;
    }

    private String getBracketedField(int n) throws IOException {
        StringBuffer stringBuffer = null;
        int n2 = -1;
        boolean bl = false;
        while (!this._eof) {
            int n3 = this.read();
            if (n3 == -1) {
                this._eof = true;
                if (stringBuffer != null) {
                    this.parsedEntries.add(new StringInt(stringBuffer.toString(), n));
                }
                return null;
            }
            if (n3 == 123 || n3 == 125) {
                if (n3 == 125) {
                    if (stringBuffer != null) {
                        this.parsedEntries.add(new StringInt(stringBuffer.toString(), n));
                        return null;
                    }
                } else {
                    bl = true;
                }
            } else {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(100);
                }
                if (bl && n3 != 125) {
                    stringBuffer.append((char)n3);
                }
            }
            n2 = n3;
        }
        return null;
    }

    private String getBracketedOptionField(int n) throws IOException {
        StringBuffer stringBuffer = null;
        int n2 = -1;
        boolean bl = false;
        String string = null;
        while (!this._eof) {
            int n3 = this.read();
            if (n3 == -1) {
                this._eof = true;
                if (stringBuffer != null) {
                    String string2 = string != null ? stringBuffer.toString() + "\n" + string : stringBuffer.toString();
                    this.parsedEntries.add(new StringInt(string2, 5));
                }
                return null;
            }
            if (n3 == 123 || n3 == 125 || n3 == 93 || n3 == 91) {
                if (n3 == 125 || n3 == 93) {
                    if (n3 == 93 && stringBuffer != null) {
                        string = stringBuffer.toString();
                        stringBuffer = null;
                        bl = false;
                    } else if (n3 == 125) {
                        String string3 = stringBuffer == null ? " " : stringBuffer.toString();
                        String string4 = string != null ? string3 + "\n" + string : string3;
                        this.parsedEntries.add(new StringInt(string4, 5));
                        return null;
                    }
                } else {
                    bl = true;
                }
            } else {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(100);
                }
                if (bl && n3 != 125 && n3 != 93) {
                    stringBuffer.append((char)n3);
                }
            }
            n2 = n3;
        }
        return null;
    }

    private Object parse() throws IOException {
        this.skipWhitespace();
        StringBuffer stringBuffer = null;
        int n = -1;
        boolean bl = false;
        boolean bl2 = false;
        while (!this._eof) {
            int n2 = this.read();
            if (n2 == -1) {
                this._eof = true;
                this.parsedEntries.add(new StringInt(stringBuffer.toString(), 1));
                return null;
            }
            if (n2 == 92 && this.peek() != 92 && !bl2) {
                if (stringBuffer != null) {
                    this.parsedEntries.add(new StringInt(stringBuffer.toString(), 1));
                    stringBuffer = null;
                }
                this.parseField();
                bl = true;
                bl2 = false;
            } else {
                bl = false;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(100);
                }
                if (n2 != 92 || bl2) {
                    stringBuffer.append((char)n2);
                }
                bl2 = n2 == 92 && !bl2;
            }
            n = n2;
        }
        return null;
    }

    private void parseField() throws IOException {
        StringBuffer stringBuffer = null;
        while (!this._eof) {
            int n = this.read();
            if (n == -1) {
                this._eof = true;
            }
            if (!Character.isLetter((char)n)) {
                this.unread(n);
                String string = stringBuffer != null ? stringBuffer.toString() : "";
                stringBuffer = null;
                if (string.charAt(0) == 'b') {
                    if (string.equalsIgnoreCase("begin")) {
                        this.getBracketedField(3);
                        return;
                    }
                    if (string.equalsIgnoreCase("begingroup")) {
                        this.getBracketedField(6);
                        return;
                    }
                } else if (string.charAt(0) == 'f') {
                    if (string.equalsIgnoreCase("format")) {
                        if (n == 91) {
                            this.getBracketedOptionField(5);
                            return;
                        }
                        this.getBracketedField(5);
                        return;
                    }
                } else if (string.charAt(0) == 'e') {
                    if (string.equalsIgnoreCase("end")) {
                        this.getBracketedField(4);
                        return;
                    }
                    if (string.equalsIgnoreCase("endgroup")) {
                        this.getBracketedField(7);
                    }
                }
                this.parsedEntries.add(new StringInt(string, 2));
                return;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(100);
            }
            stringBuffer.append((char)n);
        }
    }

    private int peek() throws IOException {
        int n = this.read();
        this.unread(n);
        return n;
    }

    private int read() throws IOException {
        int n = this._in.read();
        if (n == 10) {
            ++this.line;
        }
        return n;
    }

    private void skipWhitespace() throws IOException {
        int n;
        do {
            if ((n = this.read()) != -1 && n != 65535) continue;
            this._eof = true;
            return;
        } while (Character.isWhitespace((char)n));
        this.unread(n);
    }

    private void unread(int n) throws IOException {
        if (n == 10) {
            --this.line;
        }
        this._in.unread(n);
    }
}

