/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.export.OOCalcDatabase;

public class OpenOfficeDocumentCreator {
    private OpenOfficeDocumentCreator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeOpenOfficeFile(File file, InputStream inputStream) throws Exception {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            ZipEntry zipEntry = new ZipEntry("content.xml");
            zipOutputStream.putNextEntry(zipEntry);
            int n = -1;
            while ((n = inputStream.read()) >= 0) {
                zipOutputStream.write(n);
            }
            zipOutputStream.closeEntry();
            OpenOfficeDocumentCreator.addResourceFile("meta.xml", "/resource/openoffice/meta.xml", zipOutputStream);
            OpenOfficeDocumentCreator.addResourceFile("mimetype", "/resource/openoffice/mimetype", zipOutputStream);
            OpenOfficeDocumentCreator.addResourceFile("META-INF/manifest.xml", "/resource/openoffice/manifest.xml", zipOutputStream);
        }
        finally {
            zipOutputStream.close();
        }
    }

    public static void exportOpenOfficeCalc(File file, BibtexDatabase bibtexDatabase) throws Exception {
        File file2 = File.createTempFile("oocalc", null);
        OpenOfficeDocumentCreator.exportOpenOfficeCalcXML(file2, bibtexDatabase);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
        OpenOfficeDocumentCreator.storeOpenOfficeFile(file, bufferedInputStream);
        file2.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportOpenOfficeCalcXML(File file, BibtexDatabase bibtexDatabase) {
        OOCalcDatabase oOCalcDatabase = new OOCalcDatabase(bibtexDatabase);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8");
            try {
                DOMSource dOMSource = new DOMSource(oOCalcDatabase.getDOMrepresentation());
                StreamResult streamResult = new StreamResult(outputStreamWriter);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(dOMSource, streamResult);
            }
            finally {
                ((Writer)outputStreamWriter).close();
            }
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    private static void addResourceFile(String string, String string2, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        OpenOfficeDocumentCreator.addFromResource(string2, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFromResource(String string, OutputStream outputStream) {
        URL uRL = OpenOfficeDocumentCreator.class.getResource(string);
        try {
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[256];
            InputStream inputStream2 = inputStream;
            synchronized (inputStream2) {
                OutputStream outputStream2 = outputStream;
                synchronized (outputStream2) {
                    int n;
                    while ((n = inputStream.read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

