/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.export.OpenDocumentRepresentation;

public class OpenDocumentSpreadsheetCreator {
    private OpenDocumentSpreadsheetCreator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeOpenDocumentSpreadsheetFile(File file, InputStream inputStream) throws Exception {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            ZipEntry zipEntry = new ZipEntry("content.xml");
            zipOutputStream.putNextEntry(zipEntry);
            int n = -1;
            while ((n = inputStream.read()) >= 0) {
                zipOutputStream.write(n);
            }
            zipOutputStream.closeEntry();
            OpenDocumentSpreadsheetCreator.addResourceFile("meta.xml", "/resource/ods/meta.xml", zipOutputStream);
            OpenDocumentSpreadsheetCreator.addResourceFile("META-INF/manifest.xml", "/resource/ods/manifest.xml", zipOutputStream);
        }
        finally {
            zipOutputStream.close();
        }
    }

    public static void exportOpenDocumentSpreadsheet(File file, BibtexDatabase bibtexDatabase) throws Exception {
        File file2 = File.createTempFile("opendocument", null);
        OpenDocumentSpreadsheetCreator.exportOpenDocumentSpreadsheetXML(file2, bibtexDatabase);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
        OpenDocumentSpreadsheetCreator.storeOpenDocumentSpreadsheetFile(file, bufferedInputStream);
        file2.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportOpenDocumentSpreadsheetXML(File file, BibtexDatabase bibtexDatabase) {
        OpenDocumentRepresentation openDocumentRepresentation = new OpenDocumentRepresentation(bibtexDatabase);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8");
            try {
                DOMSource dOMSource = new DOMSource(openDocumentRepresentation.getDOMrepresentation());
                StreamResult streamResult = new StreamResult(outputStreamWriter);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(dOMSource, streamResult);
            }
            finally {
                ((Writer)outputStreamWriter).close();
            }
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    private static void addResourceFile(String string, String string2, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        OpenDocumentSpreadsheetCreator.addFromResource(string2, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFromResource(String string, OutputStream outputStream) {
        URL uRL = OpenDocumentSpreadsheetCreator.class.getResource(string);
        try {
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[256];
            InputStream inputStream2 = inputStream;
            synchronized (inputStream2) {
                OutputStream outputStream2 = outputStream;
                synchronized (outputStream2) {
                    int n;
                    while ((n = inputStream.read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

