/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.FieldComparatorStack;
import net.sf.jabref.export.layout.format.GetOpenOfficeType;
import net.sf.jabref.export.layout.format.RemoveBrackets;
import net.sf.jabref.export.layout.format.RemoveWhitespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class OOCalcDatabase {
    protected Collection entries;

    public OOCalcDatabase() {
    }

    public OOCalcDatabase(BibtexDatabase bibtexDatabase) {
        this();
        ArrayList<FieldComparator> arrayList = new ArrayList<FieldComparator>();
        arrayList.add(new FieldComparator("author"));
        arrayList.add(new FieldComparator("year"));
        arrayList.add(new FieldComparator("bibtexkey"));
        BasicEventList basicEventList = new BasicEventList();
        basicEventList.addAll(bibtexDatabase.getEntries());
        this.entries = new SortedList(basicEventList, new FieldComparatorStack(arrayList));
    }

    public Document getDOMrepresentation() {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = document.createElement("office:document-content");
            element.setAttribute("xmlns:office", "http://openoffice.org/2000/office");
            element.setAttribute("xmlns:style", "http://openoffice.org/2000/style");
            element.setAttribute("xmlns:text", "http://openoffice.org/2000/text");
            element.setAttribute("xmlns:table", "http://openoffice.org/2000/table");
            element.setAttribute("xmlns:office:class", "spreadsheet");
            element.setAttribute("xmlns:office:version", "1.0");
            element.setAttribute("xmlns:fo", "http://www.w3.org/1999/XSL/Format");
            Element element2 = document.createElement("office:script");
            element.appendChild(element2);
            element2 = document.createElement("office:automatic-styles");
            Element element3 = document.createElement("style:style");
            element3.setAttribute("style:name", "ro1");
            element3.setAttribute("style:family", "table-row");
            Element element4 = document.createElement("style.properties");
            element4.setAttribute("style:row-height", "0.1681inch");
            element4.setAttribute("fo:break-before", "auto");
            element4.setAttribute("style:use-optimal-row-height", "true");
            element3.appendChild(element4);
            element2.appendChild(element3);
            element3 = document.createElement("style:style");
            element3.setAttribute("style:name", "ta1");
            element3.setAttribute("style:family", "table");
            element3.setAttribute("style:master-page-name", "Default");
            element4 = document.createElement("style:properties");
            element4.setAttribute("table:display", "true");
            element3.appendChild(element4);
            element2.appendChild(element3);
            element.appendChild(element2);
            Element element5 = document.createElement("office:body");
            Element element6 = document.createElement("table:table");
            element6.setAttribute("table:name", "biblio");
            element6.setAttribute("table.style-name", "ta1");
            Element element7 = document.createElement("table:table-row");
            element7.setAttribute("table.style-name", "ro1");
            this.addTableCell(document, element7, "Type");
            this.addTableCell(document, element7, "ISBN");
            this.addTableCell(document, element7, "Identifier");
            this.addTableCell(document, element7, "Author");
            this.addTableCell(document, element7, "Title");
            this.addTableCell(document, element7, "Journal");
            this.addTableCell(document, element7, "Volume");
            this.addTableCell(document, element7, "Number");
            this.addTableCell(document, element7, "Month");
            this.addTableCell(document, element7, "Pages");
            this.addTableCell(document, element7, "Year");
            this.addTableCell(document, element7, "Address");
            this.addTableCell(document, element7, "Note");
            this.addTableCell(document, element7, "URL");
            this.addTableCell(document, element7, "Booktitle");
            this.addTableCell(document, element7, "Chapter");
            this.addTableCell(document, element7, "Edition");
            this.addTableCell(document, element7, "Series");
            this.addTableCell(document, element7, "Editor");
            this.addTableCell(document, element7, "Publisher");
            this.addTableCell(document, element7, "ReportType");
            this.addTableCell(document, element7, "Howpublished");
            this.addTableCell(document, element7, "Institution");
            this.addTableCell(document, element7, "Organization");
            this.addTableCell(document, element7, "School");
            this.addTableCell(document, element7, "Annote");
            this.addTableCell(document, element7, "Custom1");
            this.addTableCell(document, element7, "Custom2");
            this.addTableCell(document, element7, "Custom3");
            this.addTableCell(document, element7, "Custom4");
            this.addTableCell(document, element7, "Custom5");
            element6.appendChild(element7);
            Iterator iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
                element7 = document.createElement("table:table-row");
                this.addTableCell(document, element7, new GetOpenOfficeType().format(bibtexEntry.getType().getName()));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "isbn"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "bibtexkey"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "author"));
                this.addTableCell(document, element7, new RemoveWhitespace().format(new RemoveBrackets().format(this.getField(bibtexEntry, "title"))));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "journal"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "volume"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "number"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "month"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "pages"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "year"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "address"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "note"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "url"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "booktitle"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "chapter"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "edition"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "series"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "editor"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "publisher"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "reporttype"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "howpublished"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "institution"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "organization"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "school"));
                this.addTableCell(document, element7, this.getField(bibtexEntry, "annote"));
                this.addTableCell(document, element7, "");
                this.addTableCell(document, element7, "");
                this.addTableCell(document, element7, "");
                this.addTableCell(document, element7, "");
                this.addTableCell(document, element7, "");
                element6.appendChild(element7);
            }
            element5.appendChild(element6);
            element.appendChild(element5);
            document.appendChild(element);
        }
        catch (Exception exception) {
            System.out.println("Exception caught..." + exception);
            exception.printStackTrace();
        }
        return document;
    }

    protected String getField(BibtexEntry bibtexEntry, String string) {
        Object object = bibtexEntry.getField(string);
        return object == null ? "" : object.toString();
    }

    protected void addTableCell(Document document, Element element, String string) {
        Element element2 = document.createElement("table:table-cell");
        Element element3 = document.createElement("text:p");
        Text text = document.createTextNode(string);
        element3.appendChild(text);
        element2.appendChild(element3);
        element.appendChild(element2);
    }
}

