/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.export.CustomExportDialog;

public class ExportCustomizationDialog
extends JDialog {
    JabRefFrame frame;
    JButton addExport = new JButton(Globals.lang("Add new"));
    JButton modify = new JButton(Globals.lang("Modify"));
    JButton remove = new JButton(Globals.lang("Remove"));
    JButton close = new JButton(Globals.lang("Close"));
    JButton help = new JButton(Globals.lang("Help"));
    JPanel buttons = new JPanel();
    JPanel main = new JPanel();
    JTable table;

    public ExportCustomizationDialog(JabRefFrame jabRefFrame) throws HeadlessException {
        super(jabRefFrame, Globals.lang("Manage custom exports"), false);
        this.frame = jabRefFrame;
        this.addExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomExportDialog customExportDialog = new CustomExportDialog(ExportCustomizationDialog.this.frame);
                customExportDialog.setVisible(true);
                if (customExportDialog.okPressed()) {
                    String[] stringArray = new String[]{customExportDialog.name(), customExportDialog.layoutFile(), customExportDialog.extension()};
                    Globals.prefs.customExports.addFormat(stringArray);
                    ExportCustomizationDialog.this.table.revalidate();
                    ExportCustomizationDialog.this.table.repaint();
                    ExportCustomizationDialog.this.frame.setUpCustomExportMenu();
                }
            }
        });
        this.modify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ExportCustomizationDialog.this.table.getSelectedRow();
                if (n == -1) {
                    return;
                }
                String[] stringArray = Globals.prefs.customExports.getElementAt(n);
                CustomExportDialog customExportDialog = new CustomExportDialog(ExportCustomizationDialog.this.frame, stringArray[0], stringArray[1], stringArray[2]);
                customExportDialog.setVisible(true);
                if (customExportDialog.okPressed()) {
                    stringArray[0] = customExportDialog.name();
                    stringArray[1] = customExportDialog.layoutFile();
                    stringArray[2] = customExportDialog.extension();
                    ExportCustomizationDialog.this.table.revalidate();
                    ExportCustomizationDialog.this.table.repaint();
                    ExportCustomizationDialog.this.frame.setUpCustomExportMenu();
                }
            }
        });
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ExportCustomizationDialog.this.table.getSelectedRow();
                if (n == -1) {
                    return;
                }
                Globals.prefs.customExports.remove(n);
                ExportCustomizationDialog.this.table.revalidate();
                ExportCustomizationDialog.this.table.repaint();
                ExportCustomizationDialog.this.frame.setUpCustomExportMenu();
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportCustomizationDialog.this.dispose();
            }
        };
        this.close.addActionListener(abstractAction);
        this.help.addActionListener(new HelpAction(this.frame.helpDiag, GUIGlobals.exportCustomizationHelp, "Help"));
        ExportTableModel exportTableModel = new ExportTableModel();
        this.table = new JTable(exportTableModel);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(50);
        tableColumnModel.getColumn(1).setPreferredWidth(200);
        tableColumnModel.getColumn(2).setPreferredWidth(30);
        JScrollPane jScrollPane = new JScrollPane(this.table, 20, 31);
        this.table.setSelectionMode(0);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 150));
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        ActionMap actionMap = this.main.getActionMap();
        InputMap inputMap = this.main.getInputMap(2);
        inputMap.put(this.frame.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        this.main.setLayout(new BorderLayout());
        this.main.add((Component)jScrollPane, "Center");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded(this.addExport);
        buttonBarBuilder.addGridded(this.modify);
        buttonBarBuilder.addGridded(this.remove);
        buttonBarBuilder.addGridded(this.close);
        buttonBarBuilder.addUnrelatedGap();
        buttonBarBuilder.addGridded(this.help);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)this.main, "Center");
        this.getContentPane().add((Component)this.buttons, "South");
        this.pack();
        Util.placeDialog(this, this.frame);
        new FocusRequester(this.table);
    }

    class ExportTableModel
    extends AbstractTableModel {
        ExportTableModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return Globals.prefs.customExports.size();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Globals.lang("Export name");
                }
                case 1: {
                    return Globals.lang("Main layout file");
                }
            }
            return Globals.lang("File extension");
        }

        public Object getValueAt(int n, int n2) {
            String[] stringArray = Globals.prefs.customExports.getElementAt(n);
            return stringArray[n2];
        }
    }
}

