/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.util.Comparator;
import java.util.TreeSet;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;

public class CustomExportList
extends TreeSet {
    private Object[] array;
    JabRefPreferences prefs;

    public CustomExportList(JabRefPreferences jabRefPreferences, Comparator comparator) {
        super(comparator);
        this.prefs = jabRefPreferences;
        this.readPrefs();
        this.sort();
    }

    private void readPrefs() {
        int n = 0;
        String[] stringArray = null;
        while ((stringArray = this.prefs.getStringArray("customExportFormat" + n)) != null) {
            super.add(stringArray);
            ++n;
        }
    }

    public String[] getElementAt(int n) {
        return (String[])this.array[n];
    }

    public void addFormat(String[] stringArray) {
        super.add(stringArray);
        this.sort();
    }

    public void remove(int n) {
        super.remove(this.array[n]);
        this.sort();
    }

    public void sort() {
        this.array = this.toArray();
    }

    public void store() {
        if (this.array.length == 0) {
            this.purge(0);
        } else {
            for (int i = 0; i < this.array.length; ++i) {
                Globals.prefs.putStringArray("customExportFormat" + i, (String[])this.array[i]);
            }
            this.purge(this.array.length);
        }
    }

    private void purge(int n) {
        String[] stringArray = null;
        int n2 = n;
        while ((stringArray = Globals.prefs.getStringArray("customExportFormat" + n2)) != null) {
            Globals.prefs.remove("customExportFormat" + n2);
            ++n2;
        }
    }
}

