/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JLabel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.collab.Change;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertString;
import net.sf.jabref.undo.UndoableStringChange;

public class StringNameChange
extends Change {
    BibtexString string;
    String mem;
    String tmp;
    String disk;
    String content;

    public StringNameChange(BibtexString bibtexString, String string, String string2, String string3, String string4) {
        this.name = Globals.lang("Renamed string") + ": '" + string2 + "'";
        this.string = bibtexString;
        this.content = string4;
        this.mem = string;
        this.tmp = string2;
        this.disk = string3;
    }

    public void makeChange(BasePanel basePanel, NamedCompound namedCompound) {
        if (basePanel.database().hasStringLabel(this.disk)) {
            Globals.logger("Cannot rename string '" + this.mem + "' to '" + this.disk + "' because the name " + "is already in use.");
        }
        if (this.string != null) {
            this.string.setName(this.disk);
            namedCompound.addEdit(new UndoableStringChange(basePanel, this.string, true, this.mem, this.disk));
        } else {
            String string = Util.createNeutralId();
            BibtexString bibtexString = new BibtexString(string, this.disk, this.content);
            try {
                basePanel.database().addString(bibtexString);
                namedCompound.addEdit(new UndoableInsertString(basePanel, basePanel.database(), bibtexString));
            }
            catch (KeyCollisionException keyCollisionException) {
                Globals.logger("Error: could not add string '" + bibtexString.getName() + "': " + keyCollisionException.getMessage());
            }
        }
    }

    JComponent description() {
        return new JLabel(this.disk + " : " + this.content);
    }
}

