/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.about;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.about.AboutPanel;
import net.sf.jabref.about.AnimationListener;

public class ExtendedInfoPanel
extends JPanel
implements AnimationListener,
ActionListener {
    private JEditorPane textPane;
    private JScrollPane scroller;
    private CardLayout cards;
    private JButton close;
    private JButton license;
    private AboutPanel about;
    private JPanel infoPanel;
    private boolean animationIsRunning = true;
    private ActionListener mainListener;

    public ExtendedInfoPanel(ActionListener actionListener) {
        this.mainListener = actionListener;
        this.about = new AboutPanel();
        this.about.addAnimationListener(this);
        this.textPane = new JEditorPane();
        this.textPane.setEditable(false);
        URL uRL = this.getClass().getResource(GUIGlobals.getLocaleHelpPath() + GUIGlobals.aboutPage);
        if (uRL == null) {
            uRL = this.getClass().getResource(GUIGlobals.helpPre + GUIGlobals.aboutPage);
        }
        if (uRL != null) {
            try {
                this.textPane.setPage(uRL);
            }
            catch (IOException iOException) {
                System.err.println("Attempted to read a bad URL: " + uRL);
            }
        } else {
            System.err.println("Couldn't find file: About.html");
        }
        this.scroller = new JScrollPane(this.textPane);
        this.scroller.setPreferredSize(this.about.getSize());
        this.infoPanel = new JPanel();
        this.cards = new CardLayout();
        this.infoPanel.setLayout(this.cards);
        this.infoPanel.add((Component)this.about, "ani");
        this.infoPanel.add((Component)this.scroller, "inf");
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new GridLayout(1, 2, 10, 20));
        jPanel.setBorder(BorderFactory.createBevelBorder(0));
        jPanel.add(Box.createGlue());
        this.close = new JButton(Globals.lang("Skip"));
        this.close.addActionListener(this);
        this.close.setActionCommand("close");
        this.close.setFocusable(false);
        this.license = new JButton(Globals.lang("License"));
        this.license.addActionListener(this);
        this.license.setActionCommand("license");
        this.license.setFocusable(false);
        jPanel.add(this.close);
        jPanel.add(Box.createGlue());
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.infoPanel, "Center");
        this.add((Component)jPanel, "South");
    }

    public void animationReady() {
        this.animationIsRunning = false;
        this.cards.show(this.infoPanel, "inf");
        this.close.setText(Globals.lang("Close"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("close")) {
            if (this.animationIsRunning) {
                this.about.skipAnimation();
            } else {
                this.setVisible(false);
                this.mainListener.actionPerformed(actionEvent);
            }
        } else if (string.equals("license")) {
            this.mainListener.actionPerformed(actionEvent);
        }
    }
}

