/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.about;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.about.AboutTextLine;
import net.sf.jabref.about.AnimationListener;
import net.sf.jabref.about.HighlightFilter;
import net.sf.jabref.about.TextBlock;

public class AboutPanel
extends JComponent {
    private Vector textBlocks;
    private String versionStr;
    private String buildStr;
    private AnimationThread thread;
    private ImageIcon image;
    public int TOP = 300;
    public int BOTTOM = 0;
    public int HEIGHT = 500;
    public int WIDTH = 500;
    private int[] borders;
    private int paintWidth;
    private Font font1;
    private Font font2;
    private Font font3;
    private AnimationListener aniListener;
    private ImageProducer iProducer;
    private HighlightFilter filter;

    AboutPanel() {
        Font font = this.loadFont("ASTROLYT.TTF");
        this.font1 = font.deriveFont(1, 14.0f);
        this.font2 = font.deriveFont(1, 20.0f);
        font = this.loadFont("AUGIE.TTF");
        this.font3 = font.deriveFont(1, 14.0f);
        this.versionStr = "Version " + Globals.VERSION;
        this.buildStr = " build " + Globals.BUILD;
        this.image = new ImageIcon(this.getClass().getResource("/images/autumn.png"));
        this.filter = new HighlightFilter(false, 5);
        this.filter.setMiddle(this.image.getIconWidth(), this.image.getIconHeight());
        this.iProducer = new FilteredImageSource(this.image.getImage().getSource(), this.filter);
        this.HEIGHT = this.image.getIconHeight();
        this.WIDTH = this.image.getIconWidth();
        FontMetrics fontMetrics = this.getFontMetrics(this.font2);
        this.TOP = 2 * fontMetrics.getHeight();
        fontMetrics = this.getFontMetrics(this.font1);
        this.BOTTOM = 2 * fontMetrics.getHeight();
        this.borders = new int[4];
        this.borders[0] = 0;
        this.borders[1] = this.WIDTH;
        this.borders[2] = this.TOP;
        this.borders[3] = this.HEIGHT - this.TOP - this.BOTTOM;
        this.paintWidth = this.borders[1] - this.borders[0];
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.textBlocks = new Vector(50);
        this.loadAboutText();
        this.setDoubleBuffered(true);
        this.thread = new AnimationThread();
    }

    public void addAnimationListener(AnimationListener animationListener) {
        this.aniListener = animationListener;
    }

    private int getMiddleX(String string, Font font) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        return this.paintWidth / 2 - (fontMetrics.stringWidth(string) + 10) / 2;
    }

    private Font loadFont(String string) {
        Font font = UIManager.getFont("Label.font");
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(GUIGlobals.fontPath + string);
            font = Font.createFont(0, inputStream);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return font;
    }

    private final void loadAboutText() {
        TextBlock textBlock = null;
        AboutTextLine aboutTextLine = null;
        int n = -3;
        FontMetrics fontMetrics = this.getFontMetrics(this.font3);
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(GUIGlobals.getLocaleHelpPath() + "credits.txt");
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream(GUIGlobals.helpPre + "credits.txt");
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 1000);
            while (bufferedReader.ready()) {
                String string = bufferedReader.readLine();
                if (string == null || (string = string.trim()).length() <= 0) continue;
                if (string.charAt(0) == '#') {
                    if (textBlock != null) {
                        this.textBlocks.add(textBlock);
                        n += 2;
                    }
                    aboutTextLine = new AboutTextLine(string.substring(1).trim());
                    aboutTextLine.setTag(2);
                    aboutTextLine.setPos(this.getMiddleX(aboutTextLine.getText(), this.font2), (double)this.borders[0] - (double)(fontMetrics.getHeight() * (n + 3)) * 1.5);
                    aboutTextLine.setDirection(0.0, 1.0);
                    aboutTextLine.setFont(this.font2);
                    textBlock = new TextBlock();
                    textBlock.setHeading(aboutTextLine);
                    textBlock.setVisible(true);
                    continue;
                }
                aboutTextLine = new AboutTextLine(string.trim());
                aboutTextLine.setPos(this.getMiddleX(string, this.font3), (double)this.borders[3] + (double)(n * fontMetrics.getHeight()) * 1.5);
                aboutTextLine.setTag(10);
                aboutTextLine.setDirection(0.0, -1.0);
                aboutTextLine.setFont(this.font3);
                textBlock.add(aboutTextLine);
                ++n;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            textBlock = new TextBlock();
            textBlock.setHeading(new AboutTextLine("failure"));
            String string = "no infos available";
            aboutTextLine = new AboutTextLine(string);
            textBlock.add(aboutTextLine);
        }
        this.textBlocks.add(textBlock);
    }

    public void paintComponent(Graphics graphics) {
        if (this.thread.mode == 0) {
            this.thread.start();
        } else if (this.thread.mode == 1) {
            this.image.paintIcon(this, graphics, 0, 0);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font1);
            int n = (this.getWidth() - fontMetrics.stringWidth(this.versionStr)) / 2;
            int n2 = this.getHeight() - fontMetrics.getHeight() - 4;
            int n3 = this.getHeight() - 5;
            graphics.setFont(this.font1);
            graphics.setColor(Color.black);
            graphics.drawString(this.versionStr, n, n2);
            graphics.drawString(this.buildStr, n, n3);
            graphics.setFont(this.font2);
            fontMetrics = graphics.getFontMetrics(this.font2);
            graphics.drawString("JabRef", (this.getWidth() - fontMetrics.stringWidth("JabRef")) / 2, fontMetrics.getHeight() + 10);
            Enumeration enumeration = this.textBlocks.elements();
            while (enumeration.hasMoreElements()) {
                TextBlock textBlock = (TextBlock)enumeration.nextElement();
                if (!textBlock.isVisible()) continue;
                AboutTextLine aboutTextLine = textBlock.getHeading();
                this.drawLine(aboutTextLine, graphics);
                Enumeration enumeration2 = textBlock.getEnumeration();
                while (enumeration2.hasMoreElements()) {
                    AboutTextLine aboutTextLine2 = (AboutTextLine)enumeration2.nextElement();
                    this.drawLine(aboutTextLine2, graphics);
                }
            }
        } else {
            this.image.paintIcon(this, graphics, 0, 0);
            if (this.filter.isReady()) {
                this.skipAnimation();
            }
        }
    }

    private void drawLine(AboutTextLine aboutTextLine, Graphics graphics) {
        int n = aboutTextLine.getPosX();
        int n2 = aboutTextLine.getPosY();
        if (n > this.borders[0] - 10 && n < this.borders[1] + 10 && n2 > this.borders[2] - 10 && n2 < this.borders[3] + 10 && aboutTextLine.getVisible()) {
            graphics.setFont(aboutTextLine.getFont());
            graphics.setColor(aboutTextLine.getColor());
            graphics.drawString(aboutTextLine.getText(), aboutTextLine.getPosX(), aboutTextLine.getPosY());
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.WIDTH, this.HEIGHT);
    }

    public void removeNotify() {
        super.removeNotify();
        this.thread.kill();
    }

    public void skipAnimation() {
        this.thread.kill();
        if (this.aniListener != null) {
            this.aniListener.animationReady();
        }
    }

    class AnimationThread
    extends Thread {
        private boolean running;
        private double help01;
        private int mode;
        public int sleepTime;
        private int zone2Counter;
        private boolean runMode;

        AnimationThread() {
            super("About box animation thread");
            this.running = true;
            this.help01 = 1.0;
            this.mode = 0;
            this.sleepTime = 50;
            this.zone2Counter = 0;
            this.runMode = true;
            this.setPriority(1);
        }

        public void kill() {
            this.running = false;
        }

        public void setEnabled(boolean bl) {
            this.runMode = bl;
        }

        public synchronized void setMode(int n) {
            this.mode = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = new Object();
            this.mode = 1;
            this.runMode = true;
            while (this.running) {
                Object object2 = object;
                synchronized (object2) {
                    try {
                        do {
                            object.wait(this.sleepTime);
                        } while (!this.runMode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.mode == 1) {
                    int n = 0;
                    Enumeration enumeration = AboutPanel.this.textBlocks.elements();
                    while (enumeration.hasMoreElements()) {
                        TextBlock textBlock = (TextBlock)enumeration.nextElement();
                        AboutTextLine aboutTextLine = textBlock.getHeading();
                        n = this.performStep(aboutTextLine);
                        Enumeration enumeration2 = textBlock.getEnumeration();
                        while (enumeration2.hasMoreElements()) {
                            AboutTextLine aboutTextLine2 = (AboutTextLine)enumeration2.nextElement();
                            n += this.performStep(aboutTextLine2);
                        }
                    }
                    if (n < 1) {
                        this.mode = 2;
                    }
                    AboutPanel.this.repaint(AboutPanel.this.borders[0] - 10, AboutPanel.this.borders[2] - 10, AboutPanel.this.borders[1] + 10, AboutPanel.this.borders[3] + 10);
                    continue;
                }
                if (this.mode != 2) continue;
                this.sleepTime = this.sleepTime < 2 ? 5 : (this.sleepTime -= this.sleepTime / 3);
                AboutPanel.this.image.setImage(AboutPanel.this.createImage(AboutPanel.this.iProducer));
                AboutPanel.this.filter.nextStep();
                AboutPanel.this.repaint(0, 0, AboutPanel.this.WIDTH, AboutPanel.this.HEIGHT);
            }
        }

        private int performStep(AboutTextLine aboutTextLine) {
            int n = 0;
            aboutTextLine.performTimeStep(1.0);
            if (aboutTextLine.getTag() == 2) {
                int n2 = (int)((double)AboutPanel.this.HEIGHT / 3.5);
                if (aboutTextLine.getPosY() > n2) {
                    aboutTextLine.setSpeed(0.0);
                    aboutTextLine.setTag(4);
                    this.zone2Counter = 0;
                } else if (aboutTextLine.getPosY() > n2 - 10) {
                    this.zone2Counter = 1;
                }
                ++n;
            } else if (aboutTextLine.getTag() == 4) {
                if (this.zone2Counter < 1) {
                    Color color = aboutTextLine.getColor();
                    int n3 = color.getRGB() + 1023;
                    aboutTextLine.setColor(new Color(n3));
                } else {
                    aboutTextLine.setVisible(false);
                    aboutTextLine.setTag(5);
                }
            } else if (aboutTextLine.getTag() == 10) {
                if (aboutTextLine.getPosY() < AboutPanel.this.HEIGHT / 3) {
                    aboutTextLine.setDirection(this.help01, 0.0);
                    aboutTextLine.setAccel(0.5);
                    aboutTextLine.setTag(11);
                    this.help01 *= -1.0;
                }
                n = 1;
            } else if (aboutTextLine.getTag() == 11) {
                if (aboutTextLine.getPosX() < -100 || aboutTextLine.getPosX() > AboutPanel.this.WIDTH + 100) {
                    aboutTextLine.setTag(12);
                    aboutTextLine.setVisible(false);
                }
                n = 1;
            }
            return n;
        }
    }
}

