/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.KeywordGroup;
import net.sf.jabref.imports.CiteSeerFetcher;
import net.sf.jabref.imports.FieldContentParser;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

public class Util {
    private static SimpleDateFormat dateFormatter = null;
    public static Color fieldsCol = new Color(180, 180, 200);
    static final int TYPE_MISMATCH = -1;
    static final int NOT_EQUAL = 0;
    static final int EQUAL = 1;
    static final int EMPTY_IN_ONE = 2;
    static final int EMPTY_IN_TWO = 3;
    static final NumberFormat idFormat = NumberFormat.getInstance();
    private static int idCounter;
    static Pattern titleCapitalPattern;
    static Pattern bracedTitleCapitalPattern;

    public static void bool(boolean bl) {
        if (bl) {
            System.out.println("true");
        } else {
            System.out.println("false");
        }
    }

    public static void pr(String string) {
        System.out.println(string);
    }

    public static void pr_(String string) {
        System.out.print(string);
    }

    public static String nCase(String string) {
        if (string.length() > 1) {
            return string.substring(0, 1).toUpperCase() + string.substring(1, string.length()).toLowerCase();
        }
        return string.toUpperCase();
    }

    public static String checkName(String string) {
        String string2 = string.substring(string.length() - 4);
        if (!string2.equalsIgnoreCase(".bib")) {
            return string + ".bib";
        }
        return string;
    }

    public static synchronized String createNeutralId() {
        return idFormat.format(idCounter++);
    }

    public static void placeDialog(Dialog dialog, Container container) {
        Dimension dimension = dialog.getSize();
        Dimension dimension2 = container.getSize();
        Point point = container.getLocation();
        dialog.setLocation(new Point(Math.max(0, point.x + (dimension2.width - dimension.width) / 2), Math.max(0, point.y + (dimension2.height - dimension.height) / 2)));
    }

    public static String parseField(String string) {
        if (string.length() == 0) {
            return "";
        }
        String string2 = "";
        int n = string.indexOf(35);
        int n2 = string.indexOf(34);
        int n3 = string.indexOf(123);
        int n4 = string.length();
        if (n == -1) {
            n = n4;
        }
        if (n2 == -1) {
            n2 = n4;
        }
        if (n3 == -1) {
            n3 = n4;
        }
        boolean bl = n2 == n4 && n3 == n4 || n < Math.min(n2, n3);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("#")) {
                bl = !bl;
                continue;
            }
            if (bl) {
                String string4 = Util.shaveString(string3);
                try {
                    Integer.parseInt(string4);
                    string2 = string2 + string4;
                }
                catch (NumberFormatException numberFormatException) {
                    string2 = string2 + "#" + Util.shaveString(string3) + "#";
                }
                continue;
            }
            string2 = string2 + Util.shaveString(string3);
        }
        return string2;
    }

    public static String shaveString(String string) {
        char c;
        if (string == null) {
            return null;
        }
        int n = 0;
        int n2 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            if (n < string.length()) {
                c = string.charAt(n);
                if (Character.isWhitespace(c)) {
                    ++n;
                    continue;
                }
                bl = true;
                continue;
            }
            bl = true;
        }
        while (!bl2) {
            if (n2 > n + 1) {
                c = string.charAt(n2 - 1);
                if (Character.isWhitespace(c)) {
                    --n2;
                    continue;
                }
                bl2 = true;
                continue;
            }
            bl2 = true;
        }
        if (n2 > n + 1) {
            c = string.charAt(n);
            char c2 = string.charAt(n2 - 1);
            if (c == '{' && c2 == '}' || c == '\"' && c2 == '\"') {
                ++n;
                --n2;
            }
        }
        string = string.substring(n, n2);
        return string;
    }

    public static String checkLegalKey(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c) || c == '#' || c == '{' || c == '\\' || c == '\"' || c == '}' || c == '~' || c == ',' || c == '^') continue;
            stringBuffer.append(c);
        }
        String string2 = Util.replaceSpecialCharacters(stringBuffer.toString());
        return string2;
    }

    public static String replaceSpecialCharacters(String string) {
        Iterator iterator = Globals.UNICODE_CHARS.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)Globals.UNICODE_CHARS.get(string2);
            string = string.replaceAll(string2, string3);
        }
        return string;
    }

    public static String _wrap2(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.replaceAll("[ \\t\\r]+", " "));
        int n2 = string.length() - n;
        int n3 = -1;
        while (n2 > 0 && (n2 = stringBuffer.lastIndexOf(" ", n2)) > 0 && n2 > 20) {
            int n4 = stringBuffer.indexOf("\n", n2);
            System.out.println(n4 + " " + n3);
            if (n4 > n2 && n3 >= 0 && n4 < n3) {
                n2 = n4 - n;
                continue;
            }
            stringBuffer.insert(n2, "\n\t");
            n3 = n2;
            n2 -= n;
        }
        return stringBuffer.toString();
    }

    public static String wrap2(String string, int n) {
        return FieldContentParser.wrap(string, n);
    }

    public static String __wrap2(String string, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(string.replaceAll("[ \\t\\r]+", " "));
        int n3 = 0;
        while (n3 < stringBuffer.length() && (n2 = stringBuffer.indexOf(" ", n3 + n)) >= 0 && n2 < stringBuffer.length()) {
            int n4 = stringBuffer.indexOf("\n", n3);
            if (n4 > n3 && n4 < n2) {
                n3 = n4 + 1;
                int n5 = n4 + 1;
                if (stringBuffer.length() <= n5 || stringBuffer.charAt(n5) == '\t') continue;
                stringBuffer.insert(n5, "\n\t");
                continue;
            }
            stringBuffer.deleteCharAt(n2);
            stringBuffer.insert(n2, "\n\t");
            n3 = n2 + 1;
        }
        return stringBuffer.toString();
    }

    public static HashSet findDeliminatedWordsInField(BibtexDatabase bibtexDatabase, String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = bibtexDatabase.getKeySet().iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = bibtexDatabase.getEntryById(iterator.next().toString());
            Object object = bibtexEntry.getField(string);
            if (object == null) continue;
            String string3 = object.toString().trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken().trim());
            }
        }
        return hashSet;
    }

    public static HashSet findAllWordsInField(BibtexDatabase bibtexDatabase, String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = bibtexDatabase.getKeySet().iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = bibtexDatabase.getEntryById(iterator.next().toString());
            Object object = bibtexEntry.getField(string);
            if (object == null) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), string2, false);
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
        }
        return hashSet;
    }

    public static String stringArrayToDelimited(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(string);
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return stringBuffer.toString();
    }

    public static String[] delimToStringArray(String string, String string2) {
        if (string == null) {
            return null;
        }
        return string.split(string2);
    }

    public static void openExternalViewer(MetaData metaData, String object, String string) throws IOException {
        block32: {
            Object object2;
            Object object3;
            Object object4;
            if (string.equals("ps") || string.equals("pdf")) {
                object4 = metaData.getFileDirectory(string);
                object3 = Util.expandFilename((String)object, (String)object4);
                if (object3 == null || !object3.exists()) {
                    throw new IOException(Globals.lang("File not found") + " (" + string + "): '" + (String)object + "'.");
                }
                object = object3.getCanonicalPath();
                object2 = object3.getName().split("\\.");
                if (((String[])object2).length >= 2) {
                    if (object2[((String[])object2).length - 1].equalsIgnoreCase("pdf")) {
                        string = "pdf";
                    } else if (object2[((String[])object2).length - 1].equalsIgnoreCase("ps") || ((String[])object2).length >= 3 && object2[((String[])object2).length - 2].equalsIgnoreCase("ps")) {
                        string = "ps";
                    }
                }
            } else if (string.equals("doi")) {
                string = "url";
                if (!((String)object).startsWith("http://")) {
                    object = "http://dx.doi.org/" + (String)object;
                }
            } else if (string.equals("citeseerurl")) {
                string = "url";
                object4 = CiteSeerFetcher.generateCanonicalURL((String)object);
                if (object4 != null) {
                    object = object4;
                }
            }
            object4 = new String[2];
            if (string.equals("url")) {
                try {
                    if (((String)object).startsWith("\\url{") && ((String)object).endsWith("}")) {
                        object = ((String)object).substring(5, ((String)object).length() - 1);
                    }
                    object = Util.sanitizeUrl((String)object);
                    if (Globals.ON_MAC) {
                        object3 = new String[]{"/usr/bin/open", "-a", Globals.prefs.get("htmlviewer"), object};
                        object2 = Runtime.getRuntime().exec((String[])object3);
                        break block32;
                    }
                    if (Globals.ON_WIN) {
                        Util.openFileOnWindows((String)object, false);
                        break block32;
                    }
                    object4[0] = Globals.prefs.get("htmlviewer");
                    object4[1] = object;
                    object3 = Runtime.getRuntime().exec((String[])object4);
                }
                catch (IOException iOException) {
                    System.err.println("An error occured on the command: " + Globals.prefs.get("htmlviewer") + " " + (String)object);
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
            } else if (string.equals("ps")) {
                try {
                    if (Globals.ON_MAC) {
                        object3 = new String[]{"/usr/bin/open", "-a", Globals.prefs.get("psviewer"), object};
                        object2 = Runtime.getRuntime().exec((String[])object3);
                        break block32;
                    }
                    if (Globals.ON_WIN) {
                        Util.openFileOnWindows((String)object, true);
                        break block32;
                    }
                    object4[0] = Globals.prefs.get("psviewer");
                    object4[1] = object;
                    object3 = Runtime.getRuntime().exec((String[])object4);
                }
                catch (IOException iOException) {
                    System.err.println("An error occured on the command: " + Globals.prefs.get("psviewer") + " " + (String)object);
                }
            } else if (string.equals("pdf")) {
                try {
                    if (Globals.ON_MAC) {
                        object3 = new String[]{"/usr/bin/open", "-a", Globals.prefs.get("pdfviewer"), object};
                        object2 = Runtime.getRuntime().exec((String[])object3);
                        break block32;
                    }
                    if (Globals.ON_WIN) {
                        Util.openFileOnWindows((String)object, true);
                        break block32;
                    }
                    object4[0] = Globals.prefs.get("pdfviewer");
                    object4[1] = object;
                    object3 = Runtime.getRuntime().exec((String[])object4);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    System.err.println("An error occured on the command: " + Globals.prefs.get("pdfviewer") + " #" + (String)object);
                    System.err.println(iOException.getMessage());
                }
            } else {
                System.err.println("Message: currently only PDF, PS and HTML files can be opened by double clicking");
            }
        }
    }

    public static void openFileOnWindows(String string, boolean bl) throws IOException {
        string = string.replaceAll("&", "\"&\"").replaceAll(" ", "\" \"");
        String string2 = "cmd.exe /c start " + string;
        Process process = Runtime.getRuntime().exec(string2);
    }

    public static void openExternalFileAnyFormat(MetaData metaData, String string) throws IOException {
        block15: {
            String[] stringArray;
            File file = new File(string);
            String string2 = file.getName();
            int n = string2.indexOf(46);
            String string3 = n >= 0 && n < string2.length() - 1 ? string2.substring(n + 1).trim().toLowerCase() : null;
            ExternalFileType externalFileType = Globals.prefs.getExternalFileType(string3);
            String string4 = metaData.getFileDirectory(string3);
            if (string4 != null && (stringArray = Util.expandFilename(string, string4)) != null) {
                file = stringArray;
            }
            if (file.exists() && externalFileType != null) {
                try {
                    if (Globals.ON_MAC) {
                        stringArray = new String[]{"/usr/bin/open", "-a", externalFileType.getOpenWith(), file.getPath()};
                        Runtime.getRuntime().exec(stringArray);
                        break block15;
                    }
                    if (Globals.ON_WIN) {
                        Util.openFileOnWindows(file.getPath(), true);
                        break block15;
                    }
                    stringArray = new String[]{externalFileType.getOpenWith(), file.getPath()};
                    Runtime.getRuntime().exec(stringArray);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    System.err.println("An error occured on the command: " + externalFileType.getOpenWith() + " #" + string);
                    System.err.println(iOException.getMessage());
                }
            } else {
                if (string.startsWith("\\url{") && string.endsWith("}")) {
                    string = string.substring(5, string.length() - 1);
                }
                if (string.startsWith("doi:")) {
                    string = "http://dx.doi.org/" + string;
                }
                try {
                    string = Util.sanitizeUrl(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
                if (Globals.ON_MAC) {
                    stringArray = new String[]{"/usr/bin/open", "-a", Globals.prefs.get("htmlviewer"), string};
                    Runtime.getRuntime().exec(stringArray);
                } else if (Globals.ON_WIN) {
                    Util.openFileOnWindows(string, false);
                } else {
                    stringArray = new String[]{Globals.prefs.get("htmlviewer"), string};
                    Runtime.getRuntime().exec(stringArray);
                }
            }
        }
    }

    private static String sanitizeUrl(String string) throws URISyntaxException {
        String string2 = "http";
        String string3 = string.indexOf("//") > 0 ? "//" + string.substring(2 + string.indexOf("//")) : "//" + string;
        URI uRI = new URI(string2, string3, null);
        return uRI.toASCIIString();
    }

    public static String findPdf(String string, String string2, String string3, OpenFileFilter openFileFilter) {
        String string4;
        if (!string3.endsWith(System.getProperty("file.separator"))) {
            string3 = string3 + System.getProperty("file.separator");
        }
        if ((string4 = Util.findInDir(string, string3, openFileFilter)) != null) {
            return string4.substring(string3.length());
        }
        return null;
    }

    public static File expandFilename(String string, String string2) {
        File file = null;
        if (string == null || string.length() == 0) {
            return null;
        }
        file = new File(string);
        if (file != null && !file.exists() && string2 != null) {
            string = string2.endsWith(System.getProperty("file.separator")) ? string2 + string : string2 + System.getProperty("file.separator") + string;
            file = new File(string);
            if (file.exists()) {
                return file;
            }
            if (Globals.ON_WIN) {
                try {
                    string = string.replaceAll("/", "\\");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.err.println("An internal Java error was caused by the entry \"" + string + "\"");
                }
            } else {
                string = string.replaceAll("\\\\", "/");
            }
            if (!(file = new File(string)).exists()) {
                file = null;
            }
        }
        return file;
    }

    private static String findInDir(String string, String string2, OpenFileFilter openFileFilter) {
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            String string3;
            File file2 = fileArray[i];
            if (file2.isFile()) {
                string3 = file2.getName();
                if (!string3.startsWith(string + ".") || !openFileFilter.accept(string3)) continue;
                return file2.getPath();
            }
            if (!file2.isDirectory() || (string3 = Util.findInDir(string, file2.getPath(), openFileFilter)) == null) continue;
            return string3;
        }
        return null;
    }

    public static boolean isDuplicate(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2, float f) {
        if (bibtexEntry.getType() != bibtexEntry2.getType()) {
            return false;
        }
        String[] stringArray = bibtexEntry.getType().getRequiredFields();
        if (stringArray == null) {
            return false;
        }
        float f2 = Util.compareFieldSet(stringArray, bibtexEntry, bibtexEntry2);
        stringArray = bibtexEntry.getType().getOptionalFields();
        if (stringArray != null) {
            float f3 = Util.compareFieldSet(stringArray, bibtexEntry, bibtexEntry2);
            return (2.0f * f2 + f3) / 3.0f >= f;
        }
        return f2 >= f;
    }

    public static BibtexEntry containsDuplicate(BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry) {
        Collection collection = bibtexDatabase.getEntries();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry2 = (BibtexEntry)iterator.next();
            if (!Util.isDuplicate(bibtexEntry, bibtexEntry2, Globals.duplicateThreshold)) continue;
            return bibtexEntry2;
        }
        return null;
    }

    private static float compareFieldSet(String[] stringArray, BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (Util.compareSingleField(stringArray[i], bibtexEntry, bibtexEntry2) != 1) continue;
            ++n;
        }
        return (float)n / (float)stringArray.length;
    }

    private static int compareSingleField(String string, BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        String string2 = (String)bibtexEntry.getField(string);
        String string3 = (String)bibtexEntry2.getField(string);
        if (string2 == null) {
            if (string3 == null) {
                return 1;
            }
            return 2;
        }
        if (string3 == null) {
            return 3;
        }
        string2 = string2.toLowerCase();
        string3 = string3.toLowerCase();
        if (string.equals("author") || string.equals("editor")) {
            String[] stringArray = AuthorList.fixAuthor_lastNameFirst(string2).split(" and ");
            String[] stringArray2 = AuthorList.fixAuthor_lastNameFirst(string3).split(" and ");
            String[] stringArray3 = stringArray[0].split(",");
            String[] stringArray4 = stringArray2[0].split(",");
            if (stringArray.length > 0 && stringArray.length == stringArray2.length && stringArray3[0].trim().equals(stringArray4[0].trim())) {
                return 1;
            }
            return 0;
        }
        if (string2.trim().equals(string3.trim())) {
            return 1;
        }
        return 0;
    }

    public static double compareEntriesStrictly(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        int n;
        HashSet<Object> hashSet = new HashSet<Object>();
        Object[] objectArray = bibtexEntry.getAllFields();
        for (n = 0; n < objectArray.length; ++n) {
            hashSet.add(objectArray[n]);
        }
        objectArray = bibtexEntry2.getAllFields();
        for (n = 0; n < objectArray.length; ++n) {
            hashSet.add(objectArray[n]);
        }
        n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = bibtexEntry.getField(string);
            Object object2 = bibtexEntry2.getField(string);
            if (object != null && object2 != null && object.equals(object2)) {
                ++n;
                continue;
            }
            if (object != null || object2 != null) continue;
            ++n;
        }
        if (n == hashSet.size()) {
            return 1.01;
        }
        return (double)n / (double)hashSet.size();
    }

    public static void setAutomaticFields(List list) {
        String string = Globals.prefs.get("defaultOwner");
        String string2 = Util.easyDateFormat();
        boolean bl = Globals.prefs.getBoolean("useOwner");
        boolean bl2 = Globals.prefs.getBoolean("useTimeStamp");
        String string3 = Globals.prefs.get("timeStampField");
        for (int i = 0; i < list.size(); ++i) {
            BibtexEntry bibtexEntry = (BibtexEntry)list.get(i);
            Util.setAutomaticFields(bibtexEntry, bl, string, bl2, string3, string2);
        }
    }

    public static void setAutomaticFields(BibtexEntry bibtexEntry) {
        String string = Globals.prefs.get("defaultOwner");
        String string2 = Util.easyDateFormat();
        boolean bl = Globals.prefs.getBoolean("useOwner");
        boolean bl2 = Globals.prefs.getBoolean("useTimeStamp");
        String string3 = Globals.prefs.get("timeStampField");
        Util.setAutomaticFields(bibtexEntry, bl, string, bl2, string3, string2);
    }

    private static void setAutomaticFields(BibtexEntry bibtexEntry, boolean bl, String string, boolean bl2, String string2, String string3) {
        if (bl) {
            bibtexEntry.setField("owner", string);
        }
        if (bl2) {
            bibtexEntry.setField(string2, string3);
        }
    }

    public static boolean copyFile(File file, File file2, boolean bl) throws IOException {
        int n;
        if (file2.exists() && !bl) {
            return false;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        while ((n = bufferedInputStream.read()) >= 0) {
            bufferedOutputStream.write(n);
        }
        bufferedOutputStream.flush();
        bufferedInputStream.close();
        bufferedOutputStream.close();
        return true;
    }

    public static void performCompatibilityUpdate() {
        String string = Globals.prefs.get("generalFields");
        if (string.indexOf("abstract") >= 0) {
            String string2 = string.equals("abstract") ? "" : (string.indexOf(";abstract;") >= 0 ? string.replaceAll(";abstract;", ";") : (string.indexOf("abstract;") == 0 ? string.replaceAll("abstract;", "") : (string.indexOf(";abstract") == string.length() - 9 ? string.replaceAll(";abstract", "") : string)));
            Globals.prefs.put("generalFields", string2);
        }
    }

    public static String getCorrectFileName(String string, String string2) {
        if (string == null) {
            return "";
        }
        String string3 = string;
        int n = string.indexOf(".", 1);
        if (n < 1) {
            string3 = string3 + "." + string2;
        }
        return string3;
    }

    public static String quoteForHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append("&#" + string.charAt(i) + ";");
        }
        return stringBuffer.toString();
    }

    public static String quote(String string, String string2, char c) {
        return Util.quote(string, string2, c, 0);
    }

    public static String quote(String string, String string2, char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            boolean bl;
            char c2 = string.charAt(i);
            boolean bl2 = bl = string2.indexOf(c2) >= 0 || c2 == c;
            if (n > 0 && (++n2 >= n || bl && n2 >= n - 1)) {
                stringBuffer.append(c);
                stringBuffer.append('\n');
                n2 = 0;
            }
            if (bl) {
                stringBuffer.append(c);
                ++n2;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String unquote(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                if (c2 != '\n') {
                    stringBuffer.append(c2);
                }
                bl = false;
                continue;
            }
            if (c2 != c) {
                stringBuffer.append(c2);
                continue;
            }
            bl = true;
        }
        return stringBuffer.toString();
    }

    public static String quoteMeta(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == '\\'; --n) {
            stringBuffer.append("\\\\");
        }
        string = string.substring(0, n + 1);
        return "\\Q" + string.replaceAll("\\\\E", "\\\\E\\\\\\\\E\\\\Q") + "\\E" + stringBuffer.toString();
    }

    public static String sortWordsAndRemoveDuplicates(String string) {
        String[] stringArray = string.split(", ");
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            treeSet.add(stringArray[i]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Object object = treeSet.iterator();
        while (object.hasNext()) {
            stringBuffer.append(object.next());
            stringBuffer.append(", ");
        }
        if (stringBuffer.length() > 2) {
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        }
        return ((String)(object = stringBuffer.toString())).length() > 2 ? object : "";
    }

    public static boolean warnAssignmentSideEffects(AbstractGroup[] abstractGroupArray, BibtexEntry[] bibtexEntryArray, BibtexDatabase bibtexDatabase, Component component) {
        int n;
        Vector<String> vector = new Vector<String>();
        block0: for (int i = 0; i < abstractGroupArray.length; ++i) {
            KeywordGroup keywordGroup;
            String string;
            if (!(abstractGroupArray[i] instanceof KeywordGroup) || (string = (keywordGroup = (KeywordGroup)abstractGroupArray[i]).getSearchField().toLowerCase()).equals("keywords")) continue;
            int n2 = BibtexFields.numberOfPublicFields();
            for (int j = 0; j < n2; ++j) {
                if (!string.equals(BibtexFields.getFieldName(j))) continue;
                vector.add(string);
                continue block0;
            }
        }
        if (vector.size() == 0) {
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer("This action will modify the following field(s)\nin at least one entry each:\n");
        for (n = 0; n < vector.size(); ++n) {
            stringBuffer.append(vector.elementAt(n)).append("\n");
        }
        stringBuffer.append("This could cause undesired changes to your entries, so it is\nrecommended that you change the grouping field in your group\ndefinition to \"keywords\" or a non-standard name.\n\nDo you still want to continue?");
        n = JOptionPane.showConfirmDialog(component, stringBuffer, Globals.lang("Warning"), 0, 2);
        return n != 1;
    }

    public static String putBracesAroundCapitals(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                ++n;
            } else if (c == '}') {
                --n;
            } else if (!bl3 && c == '#') {
                boolean bl4 = bl = !bl;
            }
            if (n == 0 && !bl2 && !bl && Character.isLetter(c) && Character.isUpperCase(c)) {
                stringBuffer.append('{');
                bl2 = true;
            }
            if (!(!bl2 || Character.isLetter(c) && Character.isUpperCase(c))) {
                stringBuffer.append('}');
                bl2 = false;
            }
            stringBuffer.append(c);
            bl3 = c == '\\' && !bl3;
        }
        if (bl2) {
            stringBuffer.append('}');
        }
        return stringBuffer.toString();
    }

    public static String removeBracesAroundCapitals(String string) {
        String string2 = string;
        while ((string = Util.removeSingleBracesAroundCapitals(string)).length() < string2.length()) {
            string2 = string;
        }
        return string;
    }

    public static String removeSingleBracesAroundCapitals(String string) {
        Matcher matcher = bracedTitleCapitalPattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group();
            matcher.appendReplacement(stringBuffer, string2.substring(1, string2.length() - 1));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static OpenFileFilter getFileFilterForField(String string) {
        String string2 = BibtexFields.getFieldExtras(string);
        String string3 = "." + string.toLowerCase();
        OpenFileFilter openFileFilter = string2.equals("browseDocZip") ? new OpenFileFilter(new String[]{string3, string3 + ".gz", string3 + ".bz2"}) : new OpenFileFilter(new String[]{string3});
        return openFileFilter;
    }

    public static void showQuickErrorDialog(JFrame jFrame, String string, Exception exception) {
        final JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        final CardLayout cardLayout = new CardLayout();
        jPanel.setLayout(cardLayout);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Sans-Serif", 0, 10));
        jTextArea.setEditable(false);
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        jTextArea.setText(stringWriter.toString());
        JLabel jLabel = new JLabel(exception.getMessage());
        JButton jButton = new JButton(Globals.lang("Details"));
        FormLayout formLayout = new FormLayout("left:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Box.createVerticalGlue());
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jButton);
        JPanel jPanel3 = defaultFormBuilder.getPanel();
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(350, 150));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.show(jPanel, "details");
            }
        });
        jPanel.add((Component)jPanel3, "simple");
        jPanel.add((Component)jPanel2, "details");
        JOptionPane.showMessageDialog(jFrame, jPanel, string, 0);
    }

    public static String wrapHTML(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = n;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n2 == n) {
                stringBuffer.append(string2);
                if ((n2 -= string2.length()) > 0) continue;
                stringBuffer.append("<br>\n");
                n2 = n;
                continue;
            }
            if (n2 < string2.length() + 1) {
                stringBuffer.append("<br>\n");
                stringBuffer.append(string2);
                if (string2.length() >= n - 1) {
                    stringBuffer.append("<br>\n");
                    n2 = n;
                    continue;
                }
                stringBuffer.append(" ");
                n2 = n - string2.length() - 1;
                continue;
            }
            stringBuffer.append(' ').append(string2);
            n2 -= string2.length() + 1;
        }
        return stringBuffer.toString();
    }

    public static String easyDateFormat() {
        return Util.easyDateFormat(new Date());
    }

    public static String easyDateFormat(Date date) {
        if (dateFormatter == null) {
            String string = Globals.prefs.get("timeStampFormat");
            dateFormatter = new SimpleDateFormat(string);
        }
        return dateFormatter.format(date);
    }

    public static void markEntry(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        String string;
        Object object = bibtexEntry.getField("__markedentry");
        if (object != null && object.toString().indexOf(Globals.prefs.WRAPPED_USERNAME) >= 0) {
            return;
        }
        if (object == null) {
            string = Globals.prefs.WRAPPED_USERNAME;
        } else {
            StringBuffer stringBuffer = new StringBuffer(object.toString());
            stringBuffer.append(Globals.prefs.WRAPPED_USERNAME);
            string = stringBuffer.toString();
        }
        namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "__markedentry", bibtexEntry.getField("__markedentry"), string));
        bibtexEntry.setField("__markedentry", string);
    }

    public static void unmarkEntry(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        Object object = bibtexEntry.getField("__markedentry");
        if (object != null) {
            int n;
            String string = object.toString();
            if (string.equals("0")) {
                Util.unmarkOldStyle(bibtexEntry, bibtexDatabase, namedCompound);
                return;
            }
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = string.indexOf(Globals.prefs.WRAPPED_USERNAME, n2)) >= 0) {
                if (n > 0) {
                    stringBuffer.append(string.substring(n2, n));
                }
                n2 = n + Globals.prefs.WRAPPED_USERNAME.length();
            }
            if (n2 < string.length() - 1) {
                stringBuffer.append(string.substring(n2));
            }
            String string2 = stringBuffer.length() > 0 ? stringBuffer.toString() : null;
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "__markedentry", bibtexEntry.getField("__markedentry"), string2));
            bibtexEntry.setField("__markedentry", string2);
        }
    }

    private static void unmarkOldStyle(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        Object object;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        Object object2 = bibtexDatabase.getEntries().iterator();
        while (object2.hasNext()) {
            object = (BibtexEntry)object2.next();
            Object object3 = ((BibtexEntry)object).getField("owner");
            if (object3 == null) continue;
            treeSet.add(object3);
        }
        treeSet.remove(Globals.prefs.get("defaultOwner"));
        object2 = new StringBuffer();
        object = treeSet.iterator();
        while (object.hasNext()) {
            ((StringBuffer)object2).append('[');
            ((StringBuffer)object2).append(object.next().toString());
            ((StringBuffer)object2).append(']');
        }
        object = ((StringBuffer)object2).toString();
        if (((String)object).length() == 0) {
            object = null;
        }
        namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, "__markedentry", bibtexEntry.getField("__markedentry"), object));
        bibtexEntry.setField("__markedentry", object);
    }

    public static boolean isMarked(BibtexEntry bibtexEntry) {
        Object object = bibtexEntry.getField("__markedentry");
        if (object == null) {
            return false;
        }
        String string = (String)object;
        return string.equals("0") || string.indexOf(Globals.prefs.WRAPPED_USERNAME) >= 0;
    }

    public static List findEncodingsForString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < Globals.ENCODINGS.length; ++i) {
            CharsetEncoder charsetEncoder = Charset.forName(Globals.ENCODINGS[i]).newEncoder();
            if (!charsetEncoder.canEncode(string)) continue;
            arrayList.add(Globals.ENCODINGS[i]);
        }
        return arrayList;
    }

    static {
        idFormat.setMinimumIntegerDigits(8);
        idFormat.setGroupingUsed(false);
        idCounter = 0;
        titleCapitalPattern = Pattern.compile("[A-Z]+");
        bracedTitleCapitalPattern = Pattern.compile("\\{[A-Z]+\\}");
    }
}

