/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableRemoveEntry;

public class StrictDuplicateSearch
extends Thread {
    BasePanel panel;

    public StrictDuplicateSearch(BasePanel basePanel) {
        this.panel = basePanel;
    }

    public void run() {
        int n;
        HashSet<BibtexEntry> hashSet = new HashSet<BibtexEntry>();
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Remove duplicates"));
        boolean bl = false;
        this.panel.output(Globals.lang("Searching for duplicates..."));
        Object[] objectArray = this.panel.database.getKeySet().toArray();
        if (objectArray == null || objectArray.length < 2) {
            return;
        }
        BibtexEntry[] bibtexEntryArray = new BibtexEntry[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            bibtexEntryArray[n] = this.panel.database.getEntryById((String)objectArray[n]);
        }
        for (n = 0; n < bibtexEntryArray.length - 1; ++n) {
            for (int i = n + 1; i < bibtexEntryArray.length; ++i) {
                if (hashSet.contains(bibtexEntryArray[n]) || hashSet.contains(bibtexEntryArray[i]) || !(Util.compareEntriesStrictly(bibtexEntryArray[n], bibtexEntryArray[i]) > 1.0) || hashSet.contains(bibtexEntryArray[n]) || hashSet.contains(bibtexEntryArray[i])) continue;
                hashSet.add(bibtexEntryArray[i]);
            }
        }
        if (hashSet.size() == 0) {
            this.panel.output(Globals.lang("No duplicates found") + ".");
            return;
        }
        n = JOptionPane.showConfirmDialog(this.panel.frame(), Globals.lang("Duplicates found") + ": " + hashSet.size() + ". " + Globals.lang("Remove all?"), Globals.lang("Remove duplicates"), 2);
        if (n == 2) {
            return;
        }
        this.panel.output(Globals.lang("Duplicates removed") + ": " + hashSet.size());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
            this.panel.database.removeEntry(bibtexEntry.getId());
            namedCompound.addEdit(new UndoableRemoveEntry(this.panel.database, bibtexEntry, this.panel));
        }
        namedCompound.end();
        this.panel.undoManager.addEdit(namedCompound);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StrictDuplicateSearch.this.panel.markBaseChanged();
            }
        });
    }
}

