/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;

public class SplashScreen
extends Window {
    private Image splashImage;
    private boolean paintCalled = false;

    public SplashScreen(Frame frame) {
        super(frame);
        URL uRL = SplashScreen.class.getResource("/images/splash-2.1.png");
        this.splashImage = Toolkit.getDefaultToolkit().createImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.splashImage, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = this.splashImage.getWidth(this);
        int n2 = this.splashImage.getHeight(this);
        this.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
    }

    public void update(Graphics graphics) {
        graphics.setColor(this.getForeground());
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        graphics.drawImage(this.splashImage, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashScreen splashScreen = this;
            synchronized (splashScreen) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame splash() {
        Frame frame = new Frame();
        SplashScreen splashScreen = new SplashScreen(frame);
        splashScreen.setVisible(true);
        splashScreen.toFront();
        if (!EventQueue.isDispatchThread()) {
            SplashScreen splashScreen2 = splashScreen;
            synchronized (splashScreen2) {
                if (!splashScreen.paintCalled) {
                    try {
                        splashScreen.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return frame;
    }
}

