/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;

public class SimpleUrlDragDrop
implements DropTargetListener {
    private static Logger logger = Logger.getLogger(SimpleUrlDragDrop.class.getName());
    private FieldEditor editor;
    private EntryEditor.StoreFieldAction storeFieldAction;

    public SimpleUrlDragDrop(FieldEditor fieldEditor, EntryEditor.StoreFieldAction storeFieldAction) {
        this.editor = fieldEditor;
        this.storeFieldAction = storeFieldAction;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        dropTargetDropEvent.acceptDrop(3);
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.WARNING, "Class not found for DnD... should not happen", classNotFoundException);
        }
        try {
            URL uRL = (URL)transferable.getTransferData(dataFlavor);
            this.editor.setText(uRL.toString());
            this.storeFieldAction.actionPerformed(new ActionEvent(this.editor, 0, ""));
            return;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            JOptionPane.showMessageDialog((Component)((Object)this.editor), Globals.lang("Operation not supported"), Globals.lang("Drag and Drop Error"), 0);
            logger.log(Level.WARNING, "Transfer exception", unsupportedFlavorException);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "!should not happen!", iOException);
        }
    }

    private static class JOptionChoice {
        private String label;
        private int id;

        public JOptionChoice(String string, int n) {
            this.label = string;
            this.id = n;
        }

        public String toString() {
            return this.label;
        }

        public int getId() {
            return this.id;
        }
    }
}

