/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.SidePane;
import net.sf.jabref.SidePaneComponent;

public class SidePaneManager
implements ChangeListener {
    JabRefFrame frame;
    BasePanel panel;
    SidePane sidep;
    JabRefPreferences prefs;
    MetaData metaData;
    LinkedHashMap components = new LinkedHashMap();
    Vector visible = new Vector();
    private int visibleComponents = 0;

    public SidePaneManager(JabRefFrame jabRefFrame) {
        this.prefs = Globals.prefs;
        this.frame = jabRefFrame;
        jabRefFrame.tabbedPane.addChangeListener(this);
        this.sidep = new SidePane();
    }

    public SidePane getPanel() {
        return this.sidep;
    }

    public void populatePanel() {
        this.updateView();
        if (this.components.size() > 0) {
            this.sidep.setVisible(true);
        } else {
            this.sidep.setVisible(false);
        }
    }

    public boolean isPanelVisible(String string) {
        Object v = this.components.get(string);
        if (v != null) {
            return this.visible.contains(v);
        }
        System.err.println("Side pane component '" + string + "' unknown.");
        return false;
    }

    public void togglePanel(String string) {
        Object v = this.components.get(string);
        if (v != null) {
            if (!this.visible.contains(v)) {
                this.visible.add(v);
                this.updateView();
                ((SidePaneComponent)v).componentOpening();
            } else {
                this.visible.remove(v);
                this.updateView();
                ((SidePaneComponent)v).componentClosing();
            }
        } else {
            System.err.println("Side pane component '" + string + "' unknown.");
        }
    }

    public synchronized void ensureVisible(String string) {
        Object v = this.components.get(string);
        if (v != null) {
            if (!this.visible.contains(v)) {
                this.visible.add(v);
                this.updateView();
                ((SidePaneComponent)v).componentOpening();
            }
        } else {
            System.err.println("Side pane component '" + string + "' unknown.");
        }
    }

    public synchronized void ensureNotVisible(String string) {
        Object v = this.components.get(string);
        if (v != null) {
            if (this.visible.contains(v)) {
                this.visible.remove(v);
                this.updateView();
                ((SidePaneComponent)v).componentOpening();
            }
        } else {
            System.err.println("Side pane component '" + string + "' unknown.");
        }
    }

    public synchronized void add(String string, SidePaneComponent sidePaneComponent) {
        this.components.put(string, sidePaneComponent);
        this.visible.add(sidePaneComponent);
        this.updateView();
        sidePaneComponent.componentOpening();
    }

    public synchronized void register(String string, SidePaneComponent sidePaneComponent) {
        this.components.put(string, sidePaneComponent);
    }

    public synchronized boolean hasComponent(String string) {
        return this.components.get("name") != null;
    }

    public synchronized void hideAway(String string) {
        Object v = this.components.get(string);
        if (v != null) {
            ((SidePaneComponent)v).componentClosing();
            if (this.visible.contains(v)) {
                this.visible.remove(v);
                this.updateView();
            }
        } else {
            System.err.println("Side pane component '" + string + "' unknown.");
        }
    }

    public synchronized void hideAway(SidePaneComponent sidePaneComponent) {
        sidePaneComponent.componentClosing();
        this.visible.remove(sidePaneComponent);
        this.updateView();
    }

    public void setActiveBasePanel(BasePanel basePanel) {
        Iterator iterator = this.components.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            ((SidePaneComponent)this.components.get(k)).setActiveBasePanel(basePanel);
        }
    }

    public void updateView() {
        Vector vector = new Vector();
        Iterator iterator = this.components.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!this.visible.contains(this.components.get(k))) continue;
            vector.add(this.components.get(k));
        }
        this.sidep.setComponents(vector);
        boolean bl = this.sidep.isVisible();
        if (this.visible.size() > 0) {
            this.sidep.setVisible(true);
            if (!bl) {
                this.frame.contentPane.setDividerLocation(this.getPanel().getPreferredSize().width);
            }
        } else {
            this.sidep.setVisible(false);
        }
    }

    public void revalidate() {
        this.sidep.revalidate();
        this.sidep.repaint();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SidePaneManager.this.setActiveBasePanel((BasePanel)SidePaneManager.this.frame.tabbedPane.getSelectedComponent());
            }
        });
    }
}

