/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.SidePaneComponent;

public class SidePaneHeader
extends JPanel
implements ActionListener {
    private JButton close = new JButton(GUIGlobals.getImage("close2"));
    private JLabel nameLabel;
    private JLabel imageIcon;
    private SidePaneComponent parent;
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints con = new GridBagConstraints();

    public SidePaneHeader(String string, URL uRL, SidePaneComponent sidePaneComponent) {
        this.addPart(string, uRL, sidePaneComponent);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        graphics2D.setPaint(new GradientPaint(insets.left, insets.top, GUIGlobals.gradientGray, n, n2, GUIGlobals.gradientBlue, false));
        graphics2D.fillRect(insets.left, insets.top, n - 1, n2);
        graphics2D.setPaint(paint);
    }

    private void addPart(String string, URL uRL, SidePaneComponent sidePaneComponent) {
        this.parent = sidePaneComponent;
        this.setLayout(this.gbl);
        this.nameLabel = new JLabel(Globals.lang(string), new ImageIcon(uRL), 2);
        this.nameLabel.setForeground(new Color(230, 230, 230));
        this.close.setBorder(null);
        this.close.setOpaque(false);
        this.close.setPreferredSize(new Dimension(15, 15));
        this.close.setMaximumSize(new Dimension(15, 15));
        this.close.setMinimumSize(new Dimension(15, 15));
        this.close.addActionListener(this);
        this.con.insets = new Insets(1, 1, 1, 1);
        this.con.gridwidth = 1;
        this.con.anchor = 17;
        this.con.fill = 0;
        this.gbl.setConstraints(this.nameLabel, this.con);
        this.add(this.nameLabel);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        this.con.fill = 2;
        this.con.weightx = 1.0;
        this.gbl.setConstraints(jPanel, this.con);
        this.add(jPanel);
        this.con.weightx = 0.0;
        this.con.fill = 0;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.close, this.con);
        this.add(this.close);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.parent.hideAway();
    }
}

