/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

class ReplaceStringDialog
extends JDialog {
    JTextField fields = new JTextField("", 30);
    JTextField from = new JTextField("", 30);
    JTextField to = new JTextField("", 30);
    JLabel fl = new JLabel(Globals.lang("Search for") + ":");
    JLabel tl = new JLabel(Globals.lang("Replace with") + ":");
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JPanel settings = new JPanel();
    JPanel main = new JPanel();
    JPanel opt = new JPanel();
    JCheckBox selOnly = new JCheckBox(Globals.lang("Limit to selected entries"), false);
    JRadioButton allFi = new JRadioButton(Globals.lang("All fields"), true);
    JRadioButton field = new JRadioButton(Globals.lang("Limit to fields") + ":", false);
    ButtonGroup bg = new ButtonGroup();
    private boolean ok_pressed = false;
    private JabRefFrame parent;
    String[] flds = null;
    String s1;
    String s2;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();

    public ReplaceStringDialog(JabRefFrame jabRefFrame) {
        super(jabRefFrame, Globals.lang("Replace string"), true);
        this.parent = jabRefFrame;
        this.bg.add(this.allFi);
        this.bg.add(this.field);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReplaceStringDialog.this.s1 = ReplaceStringDialog.this.from.getText();
                ReplaceStringDialog.this.s2 = ReplaceStringDialog.this.to.getText();
                if (ReplaceStringDialog.this.s1.equals("")) {
                    return;
                }
                ReplaceStringDialog.this.ok_pressed = true;
                ReplaceStringDialog.this.flds = Util.delimToStringArray(ReplaceStringDialog.this.fields.getText().toLowerCase(), ";");
                ReplaceStringDialog.this.dispose();
            }
        };
        this.ok.addActionListener(actionListener);
        this.to.addActionListener(actionListener);
        this.fields.addActionListener(actionListener);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReplaceStringDialog.this.dispose();
            }
        };
        this.cancel.addActionListener(abstractAction);
        ActionMap actionMap = this.settings.getActionMap();
        InputMap inputMap = this.settings.getInputMap(2);
        inputMap.put(this.parent.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        this.settings.setLayout(this.gbl);
        this.opt.setLayout(this.gbl);
        this.main.setLayout(this.gbl);
        this.settings.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Replace string")));
        this.main.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Strings")));
        this.con.gridwidth = 2;
        this.con.weightx = 0.0;
        this.con.anchor = 17;
        this.con.fill = 2;
        this.con.gridy = 0;
        this.con.gridx = 0;
        this.con.insets = new Insets(3, 5, 3, 5);
        this.gbl.setConstraints(this.selOnly, this.con);
        this.settings.add(this.selOnly);
        this.con.gridy = 1;
        this.con.insets = new Insets(13, 5, 3, 5);
        this.gbl.setConstraints(this.allFi, this.con);
        this.settings.add(this.allFi);
        this.con.gridwidth = 1;
        this.con.gridy = 2;
        this.con.gridx = 0;
        this.con.insets = new Insets(3, 5, 3, 5);
        this.gbl.setConstraints(this.field, this.con);
        this.settings.add(this.field);
        this.con.gridx = 1;
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.fields, this.con);
        this.settings.add(this.fields);
        this.con.weightx = 0.0;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fl, this.con);
        this.main.add(this.fl);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.tl, this.con);
        this.main.add(this.tl);
        this.con.weightx = 1.0;
        this.con.gridx = 1;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.from, this.con);
        this.main.add(this.from);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.to, this.con);
        this.main.add(this.to);
        this.con.gridx = -1;
        this.con.gridy = -1;
        this.con.weightx = 1.0;
        this.con.gridwidth = 1;
        this.con.anchor = 13;
        this.con.fill = 0;
        this.gbl.setConstraints(this.ok, this.con);
        this.opt.add(this.ok);
        this.con.anchor = 17;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.cancel, this.con);
        this.opt.add(this.cancel);
        this.getContentPane().add((Component)this.main, "North");
        this.getContentPane().add((Component)this.settings, "Center");
        this.getContentPane().add((Component)this.opt, "South");
        this.pack();
        Util.placeDialog(this, this.parent);
    }

    public boolean okPressed() {
        return this.ok_pressed;
    }

    public boolean allFields() {
        return this.allFi.isSelected();
    }

    public boolean selOnly() {
        return this.selOnly.isSelected();
    }

    public String[] fields() {
        return Util.delimToStringArray(this.field.getText(), ";");
    }

    public int replace(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        int n = 0;
        if (this.allFields()) {
            Object[] objectArray = bibtexEntry.getAllFields();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                if (string.equals("bibtexkey")) continue;
                n += this.replaceField(bibtexEntry, string, namedCompound);
            }
        } else {
            for (int i = 0; i < this.flds.length; ++i) {
                if (this.flds[i].equals("bibtexkey")) continue;
                n += this.replaceField(bibtexEntry, this.flds[i], namedCompound);
            }
        }
        return n;
    }

    public int replaceField(BibtexEntry bibtexEntry, String string, NamedCompound namedCompound) {
        Object object = bibtexEntry.getField(string);
        if (object == null) {
            return 0;
        }
        String string2 = object.toString();
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.s1.length();
        while ((n = string2.indexOf(this.s1, n2)) >= 0) {
            ++n3;
            stringBuffer.append(string2.substring(n2, n));
            stringBuffer.append(this.s2);
            n2 = n + n4;
        }
        stringBuffer.append(string2.substring(n2));
        String string3 = stringBuffer.toString();
        bibtexEntry.setField(string, string3);
        namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, string, string2, string3));
        return n3;
    }
}

