/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.SearchRule;
import net.sf.jabref.export.layout.format.RemoveBrackets;

public class RegExpRule
implements SearchRule {
    final boolean m_caseSensitiveSearch;
    static RemoveBrackets removeBrackets = new RemoveBrackets();

    public RegExpRule(boolean bl) {
        this.m_caseSensitiveSearch = bl;
    }

    public int applyRule(Map map, BibtexEntry bibtexEntry) throws PatternSyntaxException {
        int n = 0;
        Iterator iterator = map.values().iterator();
        String string = (String)iterator.next();
        int n2 = 0;
        if (!this.m_caseSensitiveSearch) {
            n2 = 2;
        }
        Pattern pattern = Pattern.compile(string, n2);
        Object[] objectArray = bibtexEntry.getAllFields();
        return n += this.searchFields(objectArray, bibtexEntry, pattern);
    }

    protected int searchFields(Object[] objectArray, BibtexEntry bibtexEntry, Pattern pattern) {
        int n = 0;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    Matcher matcher;
                    Object object = bibtexEntry.getField((String)objectArray[i]);
                    if (object == null || !(matcher = pattern.matcher(removeBrackets.format((String)object))).find()) continue;
                    ++n;
                    continue;
                }
                catch (Throwable throwable) {
                    System.err.println("Searching error: " + throwable);
                }
            }
        }
        return n;
    }
}

