/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.AdvancedTab;
import net.sf.jabref.AppearancePrefsTab;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.ExternalTab;
import net.sf.jabref.GeneralTab;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.PreviewPrefsTab;
import net.sf.jabref.TabLabelPattern;
import net.sf.jabref.TableColumnsTab;
import net.sf.jabref.TablePrefsTab;
import net.sf.jabref.groups.GroupsPrefsTab;
import net.sf.jabref.gui.MainTable;

public class PrefsDialog3
extends JDialog {
    private JabRefPreferences _prefs;
    JPanel upper = new JPanel();
    JPanel lower = new JPanel();
    JPanel main = new JPanel();
    JList chooser;
    JButton importPrefs = new JButton(Globals.lang("Import preferences"));
    JButton exportPrefs = new JButton(Globals.lang("Export preferences"));
    CardLayout cardLayout = new CardLayout();
    HashMap panels = new HashMap();
    JabRefFrame frame;
    PrefsDialog3 ths = this;

    public PrefsDialog3(JabRefFrame jabRefFrame, JabRefPreferences jabRefPreferences) {
        super(jabRefFrame, Globals.lang("JabRef preferences"), false);
        this._prefs = jabRefPreferences;
        this.frame = jabRefFrame;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.upper, "Center");
        this.getContentPane().add((Component)this.lower, "South");
        String string = Globals.lang("General");
        String string2 = Globals.lang("Appearance");
        String string3 = Globals.lang("Groups");
        String string4 = Globals.lang("External programs");
        String string5 = Globals.lang("Entry table");
        String string6 = Globals.lang("Entry table columns");
        String string7 = Globals.lang("Key pattern");
        String string8 = Globals.lang("Entry preview");
        String string9 = Globals.lang("Advanced");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string4);
        arrayList.add(string5);
        arrayList.add(string6);
        arrayList.add(string7);
        arrayList.add(string8);
        arrayList.add(string9);
        this.main.setLayout(this.cardLayout);
        this.main.add((Component)new GeneralTab(this.frame, this._prefs), string);
        this.main.add((Component)new AdvancedTab(this._prefs, jabRefFrame.helpDiag), string9);
        this.main.add((Component)new GroupsPrefsTab(this._prefs), string3);
        this.main.add((Component)new AppearancePrefsTab(this._prefs), string2);
        this.main.add((Component)new ExternalTab(this.frame, this._prefs), string4);
        this.main.add((Component)new TablePrefsTab(this._prefs, jabRefFrame), string5);
        this.main.add((Component)new TableColumnsTab(this._prefs, jabRefFrame), string6);
        this.main.add((Component)new TabLabelPattern(this._prefs, jabRefFrame.helpDiag), string7);
        this.main.add((Component)new PreviewPrefsTab(this._prefs, jabRefFrame.helpDiag), string8);
        this.upper.setBorder(BorderFactory.createEtchedBorder());
        this.chooser = new JList<Object>(arrayList.toArray());
        this.chooser.setBorder(BorderFactory.createEtchedBorder());
        this.chooser.setPrototypeCellValue("This should be wide enough");
        this.chooser.setSelectedIndex(0);
        this.chooser.setSelectionMode(0);
        this.chooser.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                String string = (String)PrefsDialog3.this.chooser.getSelectedValue();
                PrefsDialog3.this.cardLayout.show(PrefsDialog3.this.main, string);
            }
        });
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        jPanel.add((Component)this.chooser, "Center");
        jPanel.add((Component)this.importPrefs, "South");
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)this.exportPrefs, "South");
        this.upper.setLayout(new BorderLayout());
        this.upper.add((Component)jPanel2, "West");
        this.upper.add((Component)this.main, "Center");
        JButton jButton = new JButton(Globals.lang("Ok"));
        JButton jButton2 = new JButton(Globals.lang("Cancel"));
        jButton.addActionListener(new OkAction());
        CancelAction cancelAction = new CancelAction();
        jButton2.addActionListener(cancelAction);
        this.lower.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(this.lower);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded(jButton);
        buttonBarBuilder.addGridded(jButton2);
        buttonBarBuilder.addGlue();
        ActionMap actionMap = this.chooser.getActionMap();
        InputMap inputMap = this.chooser.getInputMap(2);
        inputMap.put(this.frame.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", cancelAction);
        this.exportPrefs.setToolTipText(Globals.lang("Export preferences to file"));
        this.importPrefs.setToolTipText(Globals.lang("Import preferences from file"));
        this.exportPrefs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Globals.getNewFile(PrefsDialog3.this.frame, new File(System.getProperty("user.home")), ".xml", 1, false);
                if (string == null) {
                    return;
                }
                File file = new File(string);
                if (!file.exists() || JOptionPane.showConfirmDialog(PrefsDialog3.this.ths, "'" + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Export preferences"), 2) == 0) {
                    try {
                        PrefsDialog3.this._prefs.exportPreferences(string);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(PrefsDialog3.this.ths, Globals.lang("Could not export preferences") + ": " + iOException.getMessage(), Globals.lang("Export preferences"), 0);
                    }
                }
            }
        });
        this.importPrefs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Globals.getNewFile(PrefsDialog3.this.frame, new File(System.getProperty("user.home")), ".xml", 0, false);
                if (string == null) {
                    return;
                }
                try {
                    PrefsDialog3.this._prefs.importPreferences(string);
                    PrefsDialog3.this.setValues();
                    BibtexEntryType.loadCustomEntryTypes(PrefsDialog3.this._prefs);
                    PrefsDialog3.this.frame.removeCachedEntryEditors();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(PrefsDialog3.this.ths, Globals.lang("Could not import preferences") + ": " + iOException.getMessage(), Globals.lang("Import preferences"), 0);
                }
            }
        });
        this.setValues();
        this.pack();
    }

    public void setValues() {
        int n = this.main.getComponentCount();
        Component[] componentArray = this.main.getComponents();
        for (int i = 0; i < n; ++i) {
            ((PrefsTab)((Object)componentArray[i])).setValues();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrefsDialog3.this.setVisible(false);
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Ok");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractWorker abstractWorker = new AbstractWorker(){
                boolean ready = true;

                public void run() {
                    int n;
                    int n2 = ((OkAction)OkAction.this).PrefsDialog3.this.main.getComponentCount();
                    Component[] componentArray = ((OkAction)OkAction.this).PrefsDialog3.this.main.getComponents();
                    for (n = 0; n < n2; ++n) {
                        if (((PrefsTab)((Object)componentArray[n])).readyToClose()) continue;
                        this.ready = false;
                        return;
                    }
                    for (n = 0; n < n2; ++n) {
                        ((PrefsTab)((Object)componentArray[n])).storeSettings();
                    }
                    Globals.prefs.flush();
                }

                public void update() {
                    if (!this.ready) {
                        return;
                    }
                    PrefsDialog3.this.setVisible(false);
                    MainTable.updateRenderers();
                    ((OkAction)OkAction.this).PrefsDialog3.this.frame.setupAllTables();
                    ((OkAction)OkAction.this).PrefsDialog3.this.frame.groupSelector.revalidateGroups();
                    ((OkAction)OkAction.this).PrefsDialog3.this.frame.output(Globals.lang("Preferences recorded."));
                }
            };
            abstractWorker.getWorker().run();
            abstractWorker.getCallBack().update();
        }
    }
}

