/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.AdvancedTab;
import net.sf.jabref.GeneralTab;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.PreviewPrefsTab;
import net.sf.jabref.TabLabelPattern;
import net.sf.jabref.TablePrefsTab;

public class PrefsDialog2
extends JDialog {
    private JabRefPreferences _prefs;
    JPanel upper = new JPanel();
    JPanel lower = new JPanel();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JTabbedPane tabbed = new JTabbedPane();
    JabRefFrame frame;

    public PrefsDialog2(JabRefFrame jabRefFrame, JabRefPreferences jabRefPreferences) {
        super(jabRefFrame, Globals.lang("JabRef preferences"), false);
        this._prefs = jabRefPreferences;
        this.frame = jabRefFrame;
        this.getContentPane().setLayout(this.gbl);
        this.con.weighty = 1.0;
        this.con.weightx = 1.0;
        this.con.fill = 1;
        this.con.gridwidth = 0;
        this.con.insets = new Insets(5, 5, 0, 5);
        this.gbl.setConstraints(this.tabbed, this.con);
        this.getContentPane().add(this.tabbed);
        this.con.weighty = 0.0;
        this.con.gridheight = 0;
        this.gbl.setConstraints(this.lower, this.con);
        this.getContentPane().add(this.lower);
        this.tabbed.addTab(Globals.lang("General"), new GeneralTab(this.frame, this._prefs));
        this.tabbed.addTab(Globals.lang("Appearance"), new TablePrefsTab(this._prefs, jabRefFrame));
        this.tabbed.addTab(Globals.lang("Key pattern"), new TabLabelPattern(this._prefs, jabRefFrame.helpDiag));
        this.tabbed.addTab(Globals.lang("Entry preview"), new PreviewPrefsTab(this._prefs, jabRefFrame.helpDiag));
        if (!Globals.ON_MAC) {
            this.tabbed.addTab(Globals.lang("Advanced"), new AdvancedTab(this._prefs, jabRefFrame.helpDiag));
        }
        JButton jButton = new JButton(Globals.lang("Ok"));
        JButton jButton2 = new JButton(Globals.lang("Cancel"));
        jButton.addActionListener(new OkAction());
        CancelAction cancelAction = new CancelAction();
        jButton2.addActionListener(cancelAction);
        this.lower.add(jButton);
        this.lower.add(jButton2);
        ActionMap actionMap = this.tabbed.getActionMap();
        InputMap inputMap = this.tabbed.getInputMap(2);
        inputMap.put(this.frame.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", cancelAction);
        this.pack();
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrefsDialog2.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Ok");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractWorker abstractWorker = new AbstractWorker(){

                public void run() {
                    int n;
                    for (n = 0; n < ((OkAction)OkAction.this).PrefsDialog2.this.tabbed.getTabCount(); ++n) {
                        if (((PrefsTab)((Object)((OkAction)OkAction.this).PrefsDialog2.this.tabbed.getComponentAt(n))).readyToClose()) continue;
                        return;
                    }
                    for (n = 0; n < ((OkAction)OkAction.this).PrefsDialog2.this.tabbed.getTabCount(); ++n) {
                        ((PrefsTab)((Object)((OkAction)OkAction.this).PrefsDialog2.this.tabbed.getComponentAt(n))).storeSettings();
                    }
                }

                public void update() {
                    PrefsDialog2.this.dispose();
                    ((OkAction)OkAction.this).PrefsDialog2.this.frame.setupAllTables();
                    ((OkAction)OkAction.this).PrefsDialog2.this.frame.output(Globals.lang("Preferences recorded."));
                }
            };
            abstractWorker.getWorker().run();
            abstractWorker.getCallBack().update();
        }
    }
}

