/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.EntryEditorTabList;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.Util;
import net.sf.jabref.export.CustomExportList;
import net.sf.jabref.export.ExportComparator;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.imports.CustomImportList;
import net.sf.jabref.labelPattern.DefaultLabelPatterns;
import net.sf.jabref.labelPattern.LabelPattern;

public class JabRefPreferences {
    public final String CUSTOM_TYPE_NAME = "customTypeName_";
    public final String CUSTOM_TYPE_REQ = "customTypeReq_";
    public final String CUSTOM_TYPE_OPT = "customTypeOpt_";
    public final String CUSTOM_TAB_NAME = "customTabName_";
    public final String CUSTOM_TAB_FIELDS = "customTabFields_";
    public String WRAPPED_USERNAME;
    Preferences prefs;
    public HashMap defaults = new HashMap();
    public HashMap keyBinds = new HashMap();
    public HashMap defKeyBinds = new HashMap();
    private HashSet putBracesAroundCapitalsFields = new HashSet(4);
    private HashSet nonWrappableFields = new HashSet(4);
    private static final LabelPattern KEY_PATTERN = new DefaultLabelPatterns();
    private static LabelPattern keyPattern;
    public CustomExportList customExports;
    public CustomImportList customImports;
    private EntryEditorTabList tabList = null;
    private Map externalFileTypes = new HashMap();
    private static JabRefPreferences INSTANCE;

    public static JabRefPreferences getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JabRefPreferences();
        }
        return INSTANCE;
    }

    private JabRefPreferences() {
        this.prefs = Preferences.userNodeForPackage(JabRef.class);
        if (Globals.osName.equals("Mac OS X")) {
            this.defaults.put("pdfviewer", "/Applications/Preview.app");
            this.defaults.put("psviewer", "/Applications/Preview.app");
            this.defaults.put("htmlviewer", "/Applications/Safari.app");
        } else if (Globals.osName.toLowerCase().startsWith("windows")) {
            this.defaults.put("pdfviewer", "cmd.exe /c start /b");
            this.defaults.put("psviewer", "cmd.exe /c start /b");
            this.defaults.put("htmlviewer", "cmd.exe /c start /b");
            this.defaults.put("lookAndFeel", "com.jgoodies.plaf.windows.ExtWindowsLookAndFeel");
        } else {
            this.defaults.put("pdfviewer", "acroread");
            this.defaults.put("psviewer", "gv");
            this.defaults.put("htmlviewer", "mozilla");
            this.defaults.put("lookAndFeel", "com.jgoodies.plaf.plastic.Plastic3DLookAndFeel");
        }
        this.defaults.put("useDefaultLookAndFeel", Boolean.TRUE);
        this.defaults.put("lyxpipe", System.getProperty("user.home") + File.separator + ".lyx/lyxpipe");
        this.defaults.put("posX", new Integer(0));
        this.defaults.put("posY", new Integer(0));
        this.defaults.put("sizeX", new Integer(840));
        this.defaults.put("sizeY", new Integer(680));
        this.defaults.put("autoResizeMode", new Integer(0));
        this.defaults.put("tableColorCodesOn", Boolean.TRUE);
        this.defaults.put("namesAsIs", Boolean.FALSE);
        this.defaults.put("namesFf", Boolean.FALSE);
        this.defaults.put("namesLf", Boolean.FALSE);
        this.defaults.put("namesNatbib", Boolean.TRUE);
        this.defaults.put("abbrAuthorNames", Boolean.TRUE);
        this.defaults.put("namesLastOnly", Boolean.TRUE);
        this.defaults.put("language", "en");
        this.defaults.put("showShort", Boolean.TRUE);
        this.defaults.put("priSort", "author");
        this.defaults.put("priDescending", Boolean.FALSE);
        this.defaults.put("priBinary", Boolean.FALSE);
        this.defaults.put("secSort", "year");
        this.defaults.put("secDescending", Boolean.TRUE);
        this.defaults.put("terSort", "author");
        this.defaults.put("terDescending", Boolean.FALSE);
        this.defaults.put("columnNames", "entrytype;author;title;year;journal;owner;timestamp;bibtexkey");
        this.defaults.put("columnWidths", "75;280;400;60;100;100;100;100");
        this.defaults.put("numberColWidth", new Integer(GUIGlobals.NUMBER_COL_LENGTH));
        this.defaults.put("workingDirectory", System.getProperty("user.home"));
        this.defaults.put("exportWorkingDirectory", System.getProperty("user.home"));
        this.defaults.put("autoOpenForm", Boolean.TRUE);
        this.defaults.put("entryTypeFormHeightFactor", new Integer(1));
        this.defaults.put("entryTypeFormWidth", new Integer(1));
        this.defaults.put("backup", Boolean.TRUE);
        this.defaults.put("openLastEdited", Boolean.TRUE);
        this.defaults.put("lastEdited", null);
        this.defaults.put("stringsPosX", new Integer(0));
        this.defaults.put("stringsPosY", new Integer(0));
        this.defaults.put("stringsSizeX", new Integer(600));
        this.defaults.put("stringsSizeY", new Integer(400));
        this.defaults.put("defaultShowSource", Boolean.FALSE);
        this.defaults.put("showSource", Boolean.TRUE);
        this.defaults.put("defaultAutoSort", Boolean.FALSE);
        this.defaults.put("enableSourceEditing", Boolean.TRUE);
        this.defaults.put("caseSensitiveSearch", Boolean.FALSE);
        this.defaults.put("searchReq", Boolean.TRUE);
        this.defaults.put("searchOpt", Boolean.TRUE);
        this.defaults.put("searchGen", Boolean.TRUE);
        this.defaults.put("searchAll", Boolean.FALSE);
        this.defaults.put("incrementS", Boolean.FALSE);
        this.defaults.put("saveInStandardOrder", Boolean.TRUE);
        this.defaults.put("saveInOriginalOrder", Boolean.FALSE);
        this.defaults.put("selectS", Boolean.FALSE);
        this.defaults.put("regExpSearch", Boolean.TRUE);
        this.defaults.put("searchPanePosX", new Integer(0));
        this.defaults.put("searchPanePosY", new Integer(0));
        this.defaults.put("autoComplete", Boolean.TRUE);
        this.defaults.put("autoCompFields", new byte[]{0, 1, 28});
        this.defaults.put("groupSelectorVisible", Boolean.TRUE);
        this.defaults.put("groupFloatSelections", Boolean.TRUE);
        this.defaults.put("groupIntersectSelections", Boolean.TRUE);
        this.defaults.put("groupInvertSelections", Boolean.FALSE);
        this.defaults.put("groupShowOverlapping", Boolean.FALSE);
        this.defaults.put("groupSelectMatches", Boolean.FALSE);
        this.defaults.put("groupsDefaultField", "keywords");
        this.defaults.put("groupShowIcons", Boolean.TRUE);
        this.defaults.put("groupShowDynamic", Boolean.TRUE);
        this.defaults.put("groupExpandTree", Boolean.TRUE);
        this.defaults.put("groupAutoShow", Boolean.TRUE);
        this.defaults.put("groupAutoHide", Boolean.TRUE);
        this.defaults.put("groupKeywordSeparator", ", ");
        this.defaults.put("highlightGroupsMatchingAny", Boolean.FALSE);
        this.defaults.put("highlightGroupsMatchingAll", Boolean.FALSE);
        this.defaults.put("searchPanelVisible", Boolean.FALSE);
        this.defaults.put("defaultEncoding", System.getProperty("file.encoding"));
        this.defaults.put("winEdtPath", "C:\\Program Files\\WinEdt Team\\WinEdt\\WinEdt.exe");
        this.defaults.put("latexEditorPath", "C:\\TEMP\\Led.exe");
        this.defaults.put("groupsVisibleRows", new Integer(8));
        this.defaults.put("defaultOwner", System.getProperty("user.name"));
        this.defaults.put("preserveFieldFormatting", Boolean.FALSE);
        this.defaults.put("generalFields", "crossref;keywords;doi;url;urldate;citeseerurl;pdf;comment;owner");
        this.defaults.put("useCustomIconTheme", Boolean.FALSE);
        this.defaults.put("customIconThemeFile", "/home/alver/div/crystaltheme_16/Icons.properties");
        this.defaults.put("customTabName__def0", Globals.lang("General"));
        this.defaults.put("customTabFields__def0", "crossref;keywords;doi;url;citeseerurl;pdf;comment;owner;timestamp");
        this.defaults.put("customTabFields__def1", "abstract");
        this.defaults.put("customTabName__def1", Globals.lang("Abstract"));
        this.defaults.put("customTabFields__def2", "review");
        this.defaults.put("customTabName__def2", Globals.lang("Review"));
        this.defaults.put("historySize", new Integer(8));
        this.defaults.put("fontFamily", "Times");
        this.defaults.put("fontStyle", new Integer(0));
        this.defaults.put("fontSize", new Integer(12));
        this.defaults.put("overrideDefaultFonts", Boolean.FALSE);
        this.defaults.put("menuFontFamily", "Times");
        this.defaults.put("menuFontStyle", new Integer(0));
        this.defaults.put("menuFontSize", new Integer(11));
        this.defaults.put("tableBackground", "255:255:255");
        this.defaults.put("tableReqFieldBackground", "230:235:255");
        this.defaults.put("tableOptFieldBackground", "230:255:230");
        this.defaults.put("tableText", "0:0:0");
        this.defaults.put("gridColor", "210:210:210");
        this.defaults.put("grayedOutBackground", "210:210:210");
        this.defaults.put("grayedOutText", "40:40:40");
        this.defaults.put("veryGrayedOutBackground", "180:180:180");
        this.defaults.put("veryGrayedOutText", "40:40:40");
        this.defaults.put("markedEntryBackground", "255:255:180");
        this.defaults.put("incompleteEntryBackground", "250:175:175");
        this.defaults.put("antialias", Boolean.FALSE);
        this.defaults.put("ctrlClick", Boolean.FALSE);
        this.defaults.put("disableOnMultipleSelection", Boolean.FALSE);
        this.defaults.put("pdfColumn", Boolean.TRUE);
        this.defaults.put("urlColumn", Boolean.TRUE);
        this.defaults.put("citeseerColumn", Boolean.FALSE);
        this.defaults.put("useOwner", Boolean.TRUE);
        this.defaults.put("allowTableEditing", Boolean.FALSE);
        this.defaults.put("dialogWarningForDuplicateKey", Boolean.TRUE);
        this.defaults.put("dialogWarningForEmptyKey", Boolean.TRUE);
        this.defaults.put("displayKeyWarningDialogAtStartup", Boolean.TRUE);
        this.defaults.put("avoidOverwritingKey", Boolean.FALSE);
        this.defaults.put("warnBeforeOverwritingKey", Boolean.TRUE);
        this.defaults.put("confirmDelete", Boolean.TRUE);
        this.defaults.put("grayOutNonHits", Boolean.TRUE);
        this.defaults.put("defaultLabelPattern", "[auth][year]");
        this.defaults.put("previewEnabled", Boolean.TRUE);
        this.defaults.put("preview0", "<font face=\"arial\"><b><i>\\bibtextype</i><a name=\"\\bibtexkey\">\\begin{bibtexkey} (\\bibtexkey)</a>\\end{bibtexkey}</b><br>__NEWLINE__\\begin{author} \\format[AuthorLastFirst,HTMLChars,AuthorAbbreviator,AuthorAndsReplacer]{\\author}<BR>\\end{author}__NEWLINE__\\begin{editor} \\format[AuthorLastFirst,HTMLChars,AuthorAbbreviator,AuthorAndsReplacer]{\\editor} <i>(ed.)</i><BR>\\end{editor}__NEWLINE__\\begin{title} \\format[HTMLChars]{\\title} \\end{title}<BR>__NEWLINE__\\begin{chapter} \\format[HTMLChars]{\\chapter}<BR>\\end{chapter}__NEWLINE__\\begin{journal} <em>\\format[HTMLChars]{\\journal}, </em>\\end{journal}__NEWLINE__\\begin{booktitle} <em>\\format[HTMLChars]{\\booktitle}, </em>\\end{booktitle}__NEWLINE__\\begin{school} <em>\\format[HTMLChars]{\\school}, </em>\\end{school}__NEWLINE__\\begin{institution} <em>\\format[HTMLChars]{\\institution}, </em>\\end{institution}__NEWLINE__\\begin{publisher} <em>\\format[HTMLChars]{\\publisher}, </em>\\end{publisher}__NEWLINE__\\begin{year}<b>\\year</b>\\end{year}\\begin{volume}<i>, \\volume</i>\\end{volume}\\begin{pages}, \\format[FormatPagesForHTML]{\\pages} \\end{pages}</dd>__NEWLINE__<p></p></font>");
        this.defaults.put("preview1", "<font face=\"arial\"><b><i>\\bibtextype</i><a name=\"\\bibtexkey\">\\begin{bibtexkey} (\\bibtexkey)</a>\\end{bibtexkey}</b><br>__NEWLINE__\\begin{author} \\format[AuthorLastFirst,HTMLChars,AuthorAbbreviator,AuthorAndsReplacer]{\\author}<BR>\\end{author}__NEWLINE__\\begin{editor} \\format[AuthorLastFirst,HTMLChars,AuthorAbbreviator,AuthorAndsReplacer]{\\editor} <i>(ed.)</i><BR>\\end{editor}__NEWLINE__\\begin{title} \\format[HTMLChars]{\\title} \\end{title}<BR>__NEWLINE__\\begin{chapter} \\format[HTMLChars]{\\chapter}<BR>\\end{chapter}__NEWLINE__\\begin{journal} <em>\\format[HTMLChars]{\\journal}, </em>\\end{journal}__NEWLINE__\\begin{booktitle} <em>\\format[HTMLChars]{\\booktitle}, </em>\\end{booktitle}__NEWLINE__\\begin{school} <em>\\format[HTMLChars]{\\school}, </em>\\end{school}__NEWLINE__\\begin{institution} <em>\\format[HTMLChars]{\\institution}, </em>\\end{institution}__NEWLINE__\\begin{publisher} <em>\\format[HTMLChars]{\\publisher}, </em>\\end{publisher}__NEWLINE__\\begin{year}<b>\\year</b>\\end{year}\\begin{volume}<i>, \\volume</i>\\end{volume}\\begin{pages}, \\format[FormatPagesForHTML]{\\pages} \\end{pages}__NEWLINE__\\begin{abstract}<BR><BR><b>Abstract: </b> \\format[HTMLChars]{\\abstract} \\end{abstract}__NEWLINE__\\begin{review}<BR><BR><b>Review: </b> \\format[HTMLChars]{\\review} \\end{review}</dd>__NEWLINE__<p></p></font>");
        this.defaults.put("autoDoubleBraces", Boolean.FALSE);
        this.defaults.put("putBracesAroundCapitals", "");
        this.defaults.put("nonWrappableFields", "pdf;ps;url;doi");
        this.defaults.put("useImportInspectionDialog", Boolean.TRUE);
        this.defaults.put("useImportInspectionDialogForSingle", Boolean.FALSE);
        this.defaults.put("generateKeysAfterInspection", Boolean.TRUE);
        this.defaults.put("warnAboutDuplicatesInInspection", Boolean.TRUE);
        this.defaults.put("useTimeStamp", Boolean.TRUE);
        this.defaults.put("timeStampFormat", "yyyy.MM.dd");
        this.defaults.put("timeStampField", "timestamp");
        this.defaults.put("generateKeysBeforeSaving", Boolean.FALSE);
        this.defaults.put("useRemoteServer", Boolean.FALSE);
        this.defaults.put("remoteServerPort", new Integer(6050));
        this.defaults.put("personalJournalList", null);
        this.defaults.put("externalJournalLists", null);
        this.defaults.put("citeCommand", "cite");
        this.defaults.put("floatMarkedEntries", Boolean.TRUE);
        this.defaults.put("useNativeFileDialogOnMac", Boolean.TRUE);
        this.restoreKeyBindings();
        this.customExports = new CustomExportList(this, new ExportComparator());
        this.customImports = new CustomImportList(this);
        this.updateSpecialFieldHandling();
        this.WRAPPED_USERNAME = "[" + this.get("defaultOwner") + "]";
        this.externalFileTypes.put("pdf", new ExternalFileType("PDF", "pdf", "acroread", null));
        this.externalFileTypes.put("ps", new ExternalFileType("PostScript", "ps", "gs", null));
        this.externalFileTypes.put("doc", new ExternalFileType("Word file", "doc", "oowriter", null));
        this.externalFileTypes.put("odt", new ExternalFileType("OpenDocument text", "odt", "oowriter", null));
    }

    public boolean putBracesAroundCapitals(String string) {
        return this.putBracesAroundCapitalsFields.contains(string);
    }

    public void updateSpecialFieldHandling() {
        int n;
        String[] stringArray;
        this.putBracesAroundCapitalsFields.clear();
        String string = this.get("putBracesAroundCapitals");
        if (string.length() > 0) {
            stringArray = string.split(";");
            for (n = 0; n < stringArray.length; ++n) {
                this.putBracesAroundCapitalsFields.add(stringArray[n]);
            }
        }
        this.nonWrappableFields.clear();
        string = this.get("nonWrappableFields");
        if (string.length() > 0) {
            stringArray = string.split(";");
            for (n = 0; n < stringArray.length; ++n) {
                this.nonWrappableFields.add(stringArray[n]);
            }
        }
    }

    public boolean hasKey(String string) {
        return this.prefs.get(string, null) != null;
    }

    public String get(String string) {
        return this.prefs.get(string, (String)this.defaults.get(string));
    }

    public String get(String string, String string2) {
        return this.prefs.get(string, string2);
    }

    public boolean getBoolean(String string) {
        return this.prefs.getBoolean(string, (Boolean)this.defaults.get(string));
    }

    public double getDouble(String string) {
        return this.prefs.getDouble(string, (Double)this.defaults.get(string));
    }

    public int getInt(String string) {
        return this.prefs.getInt(string, (Integer)this.defaults.get(string));
    }

    public byte[] getByteArray(String string) {
        return this.prefs.getByteArray(string, (byte[])this.defaults.get(string));
    }

    public void put(String string, String string2) {
        this.prefs.put(string, string2);
    }

    public void putBoolean(String string, boolean bl) {
        this.prefs.putBoolean(string, bl);
    }

    public void putDouble(String string, double d) {
        this.prefs.putDouble(string, d);
    }

    public void putInt(String string, int n) {
        this.prefs.putInt(string, n);
    }

    public void putByteArray(String string, byte[] byArray) {
        this.prefs.putByteArray(string, byArray);
    }

    public void remove(String string) {
        this.prefs.remove(string);
    }

    public void putStringArray(String string, String[] stringArray) {
        if (stringArray == null) {
            this.remove(string);
            return;
        }
        if (stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuffer.append(this.makeEscape(stringArray[i]));
                stringBuffer.append(";");
            }
            stringBuffer.append(this.makeEscape(stringArray[stringArray.length - 1]));
            this.put(string, stringBuffer.toString());
        } else {
            this.put(string, "");
        }
    }

    public String[] getStringArray(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string2);
        Vector<String> vector = new Vector<String>();
        try {
            String string3;
            while ((string3 = this.getNextUnit(stringReader)) != null) {
                vector.add(string3);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public Color getColor(String string) {
        String string2 = this.get(string);
        int[] nArray = this.getRgb(string2);
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public Color getDefaultColor(String string) {
        String string2 = (String)this.defaults.get(string);
        int[] nArray = this.getRgb(string2);
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public void putColor(String string, Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(color.getRed()));
        stringBuffer.append(':');
        stringBuffer.append(String.valueOf(color.getGreen()));
        stringBuffer.append(':');
        stringBuffer.append(String.valueOf(color.getBlue()));
        this.put(string, stringBuffer.toString());
    }

    public int[] getRgb(String string) {
        String[] stringArray = string.split(":");
        int[] nArray = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2])};
        return nArray;
    }

    public KeyStroke getKey(String string) {
        String string2 = (String)this.keyBinds.get(string);
        if (string2 == null) {
            string2 = (String)this.defKeyBinds.get(string);
            this.keyBinds.put(string, string2);
        }
        if (string2 == null) {
            Globals.logger("Could not get key binding for \"" + string + "\"");
        }
        if (Globals.ON_MAC) {
            return this.getKeyForMac(KeyStroke.getKeyStroke(string2));
        }
        return KeyStroke.getKeyStroke(string2);
    }

    private KeyStroke getKeyForMac(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return null;
        }
        int n = keyStroke.getKeyCode();
        if ((keyStroke.getModifiers() & 2) == 0) {
            return keyStroke;
        }
        if ((keyStroke.getModifiers() & 1) != 0) {
            return KeyStroke.getKeyStroke(n, Globals.SHORTCUT_MASK + 1);
        }
        return KeyStroke.getKeyStroke(n, Globals.SHORTCUT_MASK);
    }

    public HashMap getKeyBindings() {
        return this.keyBinds;
    }

    public HashMap getDefaultKeys() {
        return this.defKeyBinds;
    }

    public void flush() {
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public void setNewKeyBindings(HashMap hashMap) {
        if (!hashMap.equals(this.keyBinds)) {
            String[] stringArray = new String[hashMap.size()];
            String[] stringArray2 = new String[hashMap.size()];
            int n = 0;
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)hashMap.get(string);
                stringArray[n] = string;
                stringArray2[n] = string2;
                ++n;
            }
            this.putStringArray("bindNames", stringArray);
            this.putStringArray("bindings", stringArray2);
            this.keyBinds = hashMap;
        }
    }

    public LabelPattern getKeyPattern() {
        keyPattern = new LabelPattern(KEY_PATTERN);
        Preferences preferences = Preferences.userNodeForPackage(LabelPattern.class);
        try {
            String[] stringArray = preferences.keys();
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    keyPattern.addLabelPattern(stringArray[i], preferences.get(stringArray[i], null));
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            Globals.logger("BackingStoreException in JabRefPreferences.getKeyPattern");
        }
        return keyPattern;
    }

    public void putKeyPattern(LabelPattern labelPattern) {
        keyPattern = labelPattern;
        LabelPattern labelPattern2 = labelPattern.getParent();
        if (labelPattern2 == null) {
            return;
        }
        Preferences preferences = Preferences.userNodeForPackage(LabelPattern.class);
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            Globals.logger("BackingStoreException in JabRefPreferences.putKeyPattern");
        }
        Iterator iterator = labelPattern.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (labelPattern.get(string).equals(labelPattern2.get(string))) continue;
            preferences.put(string, labelPattern.getValue(string).get(0).toString());
        }
    }

    private void restoreKeyBindings() {
        this.defineDefaultKeyBindings();
        String[] stringArray = this.getStringArray("bindNames");
        String[] stringArray2 = this.getStringArray("bindings");
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            this.setDefaultKeyBindings();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.keyBinds.put(stringArray[i], stringArray2[i]);
        }
    }

    private void setDefaultKeyBindings() {
        this.keyBinds = this.defKeyBinds;
    }

    private void defineDefaultKeyBindings() {
        this.defKeyBinds.put("Push to LyX", "ctrl L");
        this.defKeyBinds.put("Push to WinEdt", "ctrl shift W");
        this.defKeyBinds.put("Push to Emacs", "ctrl shift E");
        this.defKeyBinds.put("Quit JabRef", "ctrl Q");
        this.defKeyBinds.put("Open database", "ctrl O");
        this.defKeyBinds.put("Save database", "ctrl S");
        this.defKeyBinds.put("Save database as ...", "ctrl shift S");
        this.defKeyBinds.put("Close database", "ctrl W");
        this.defKeyBinds.put("New entry", "ctrl N");
        this.defKeyBinds.put("Cut", "ctrl X");
        this.defKeyBinds.put("Copy", "ctrl C");
        this.defKeyBinds.put("Paste", "ctrl V");
        this.defKeyBinds.put("Undo", "ctrl Z");
        this.defKeyBinds.put("Redo", "ctrl Y");
        this.defKeyBinds.put("Help", "F1");
        this.defKeyBinds.put("New article", "ctrl shift A");
        this.defKeyBinds.put("New book", "ctrl shift B");
        this.defKeyBinds.put("New phdthesis", "ctrl shift T");
        this.defKeyBinds.put("New inbook", "ctrl shift I");
        this.defKeyBinds.put("New mastersthesis", "ctrl shift M");
        this.defKeyBinds.put("New proceedings", "ctrl shift P");
        this.defKeyBinds.put("New unpublished", "ctrl shift U");
        this.defKeyBinds.put("Edit strings", "ctrl T");
        this.defKeyBinds.put("Edit preamble", "ctrl P");
        this.defKeyBinds.put("Select all", "ctrl A");
        this.defKeyBinds.put("Toggle groups interface", "ctrl shift G");
        this.defKeyBinds.put("Autogenerate BibTeX keys", "ctrl G");
        this.defKeyBinds.put("Search", "ctrl F");
        this.defKeyBinds.put("Incremental search", "ctrl shift F");
        this.defKeyBinds.put("Repeat incremental search", "ctrl shift F");
        this.defKeyBinds.put("Close dialog", "ESCAPE");
        this.defKeyBinds.put("Close entry editor", "ESCAPE");
        this.defKeyBinds.put("Close preamble editor", "ESCAPE");
        this.defKeyBinds.put("Back, help dialog", "LEFT");
        this.defKeyBinds.put("Forward, help dialog", "RIGHT");
        this.defKeyBinds.put("Preamble editor, store changes", "alt S");
        this.defKeyBinds.put("Clear search", "ESCAPE");
        this.defKeyBinds.put("Entry editor, next panel", "ctrl TAB");
        this.defKeyBinds.put("Entry editor, previous panel", "ctrl shift TAB");
        this.defKeyBinds.put("Entry editor, next panel 2", "ctrl PLUS");
        this.defKeyBinds.put("Entry editor, previous panel 2", "ctrl MINUS");
        this.defKeyBinds.put("Entry editor, next entry", "ctrl shift DOWN");
        this.defKeyBinds.put("Entry editor, previous entry", "ctrl shift UP");
        this.defKeyBinds.put("Entry editor, store field", "alt S");
        this.defKeyBinds.put("String dialog, add string", "ctrl N");
        this.defKeyBinds.put("String dialog, remove string", "shift DELETE");
        this.defKeyBinds.put("String dialog, move string up", "ctrl UP");
        this.defKeyBinds.put("String dialog, move string down", "ctrl DOWN");
        this.defKeyBinds.put("Save session", "F11");
        this.defKeyBinds.put("Load session", "F12");
        this.defKeyBinds.put("Copy \\cite{BibTeX key}", "ctrl K");
        this.defKeyBinds.put("Next tab", "ctrl PAGE_DOWN");
        this.defKeyBinds.put("Previous tab", "ctrl PAGE_UP");
        this.defKeyBinds.put("Replace string", "ctrl R");
        this.defKeyBinds.put("Delete", "DELETE");
        this.defKeyBinds.put("Open PDF or PS", "F4");
        this.defKeyBinds.put("Open URL or DOI", "F3");
        this.defKeyBinds.put("Toggle entry preview", "ctrl F9");
        this.defKeyBinds.put("Switch preview layout", "F9");
        this.defKeyBinds.put("Edit entry", "ctrl E");
        this.defKeyBinds.put("Mark entries", "ctrl M");
        this.defKeyBinds.put("Unmark entries", "ctrl shift M");
        this.defKeyBinds.put("Fetch Medline", "F5");
        this.defKeyBinds.put("Fetch CiteSeer", "F6");
        this.defKeyBinds.put("New from plain text", "ctrl shift N");
        this.defKeyBinds.put("Import Fields from CiteSeer", "ctrl shift C");
        this.defKeyBinds.put("Fetch citations from CiteSeer", "F7");
        this.defKeyBinds.put("Synchronize PDF", "shift F4");
        this.defKeyBinds.put("Synchronize PS", "ctrl F4");
        this.defKeyBinds.put("Abbreviate", "ctrl alt A");
        this.defKeyBinds.put("Unabbreviate", "ctrl alt shift A");
        this.defKeyBinds.put("Search IEEXplore", "F8");
    }

    private String getNextUnit(Reader reader) throws IOException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (!bl2 && (n = reader.read()) != -1) {
            if (n == 92) {
                if (!bl) {
                    bl = true;
                    continue;
                }
                bl = false;
                stringBuffer.append('\\');
                continue;
            }
            if (n == 59) {
                if (!bl) {
                    bl2 = true;
                } else {
                    stringBuffer.append(';');
                }
            } else {
                stringBuffer.append((char)n);
            }
            bl = false;
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    private String makeEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == ';') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void storeCustomEntryType(CustomEntryType customEntryType, int n) {
        String string = "" + n;
        this.put("customTypeName_" + string, customEntryType.getName());
        this.putStringArray("customTypeReq_" + string, customEntryType.getRequiredFields());
        this.putStringArray("customTypeOpt_" + string, customEntryType.getOptionalFields());
    }

    public CustomEntryType getCustomEntryType(int n) {
        String string = "" + n;
        String string2 = this.get("customTypeName_" + string);
        String[] stringArray = this.getStringArray("customTypeReq_" + string);
        String[] stringArray2 = this.getStringArray("customTypeOpt_" + string);
        if (string2 == null) {
            return null;
        }
        return new CustomEntryType(Util.nCase(string2), stringArray, stringArray2);
    }

    public ExternalFileType getExternalFileType(String string) {
        return (ExternalFileType)this.externalFileTypes.get(string);
    }

    public void purgeCustomEntryTypes(int n) {
        this.purgeSeries("customTypeName_", n);
        this.purgeSeries("customTypeReq_", n);
        this.purgeSeries("customTypeOpt_", n);
    }

    public void purgeSeries(String string, int n) {
        while (this.get(string + n) != null) {
            this.remove(string + n);
            ++n;
        }
    }

    public EntryEditorTabList getEntryEditorTabList() {
        if (this.tabList == null) {
            this.updateEntryEditorTabList();
        }
        return this.tabList;
    }

    public void updateEntryEditorTabList() {
        this.tabList = new EntryEditorTabList();
    }

    public void exportPreferences(String string) throws IOException {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.prefs.exportSubtree(fileOutputStream);
        }
        catch (BackingStoreException backingStoreException) {
            throw new IOException(backingStoreException.getMessage());
        }
    }

    public void importPreferences(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Preferences.importPreferences(fileInputStream);
        }
        catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
            throw new IOException(invalidPreferencesFormatException.getMessage());
        }
    }

    public boolean isNonWrappableField(String string) {
        return this.nonWrappableFields.contains(string);
    }

    static {
        INSTANCE = null;
    }
}

